/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NonCodeUsageInfo
extends MoveRenameUsageInfo {
    public final String newText;

    private NonCodeUsageInfo(@NotNull PsiElement element, int startOffset, int endOffset, PsiElement referencedElement, String newText) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/util/NonCodeUsageInfo.<init> must not be null");
        }
        super(element, null, startOffset, endOffset, referencedElement, true);
        this.newText = newText;
    }

    @Nullable
    public static NonCodeUsageInfo create(PsiFile file, int startOffset, int endOffset, PsiElement referencedElement, String newText) {
        TextRange range;
        PsiElement element;
        for (element = file.findElementAt(startOffset); element != null && (range = element.getTextRange()).getEndOffset() < endOffset; element = element.getParent()) {
        }
        if (element == null) {
            return null;
        }
        int elementStart = element.getTextRange().getStartOffset();
        return new NonCodeUsageInfo(element, startOffset -= elementStart, endOffset -= elementStart, referencedElement, newText);
    }

    @Override
    @Nullable
    public PsiReference getReference() {
        return null;
    }

    public NonCodeUsageInfo replaceElement(PsiElement newElement) {
        return new NonCodeUsageInfo(newElement, this.startOffset, this.endOffset, this.getReferencedElement(), this.newText);
    }
}

