/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.treeStructure.filtered;

import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.ui.speedSearch.ElementFilter;
import com.intellij.ui.treeStructure.CachingSimpleNode;
import com.intellij.ui.treeStructure.SimpleNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class FilteringTreeStructure
extends AbstractTreeStructure {
    private final ElementFilter myFilter;
    private final AbstractTreeStructure myStructure;
    private final Node myRoot;
    private final Map<Object, Node> myNodeObject2Node = new HashMap<Object, Node>();

    public FilteringTreeStructure(Project project, ElementFilter filter, AbstractTreeStructure originalStructure) {
        this.myFilter = filter;
        this.myStructure = originalStructure;
        this.myRoot = new Node(project);
        this.refilter();
    }

    public void refilter() {
        this.myRoot.clear();
        this.myNodeObject2Node.clear();
        this.fillChildren(this.myRoot, this.getStructure().getRootElement());
    }

    private void fillChildren(Node node, Object nodeObject) {
        Object[] nodeChildren;
        node.setDelegate(nodeObject);
        this.myNodeObject2Node.put(nodeObject, node);
        for (Object aNodeChildren : nodeChildren = this.getStructure().getChildElements(nodeObject)) {
            Node nodeChild = node.add(aNodeChildren);
            this.fillChildren(nodeChild, aNodeChildren);
            if (this.myFilter.shouldBeShowing(aNodeChildren) || nodeChild.getChildren().length != 0) continue;
            node.remove(nodeChild);
        }
    }

    public Node getVisibleNodeFor(Object nodeObject) {
        return this.myNodeObject2Node.get(nodeObject);
    }

    private AbstractTreeStructure getStructure() {
        return this.myStructure;
    }

    @Override
    public Object getRootElement() {
        return this.myRoot;
    }

    @Override
    public Object[] getChildElements(Object element) {
        return ((Node)element).getChildren();
    }

    @Override
    public Object getParentElement(Object element) {
        return ((Node)element).getParent();
    }

    @Override
    @NotNull
    public NodeDescriptor createDescriptor(Object element, NodeDescriptor parentDescriptor) {
        Node node = (Node)element;
        if (node == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/treeStructure/filtered/FilteringTreeStructure.createDescriptor must not return null");
        }
        return node;
    }

    @Override
    public void commit() {
        this.getStructure().commit();
    }

    @Override
    public boolean hasSomethingToCommit() {
        return this.getStructure().hasSomethingToCommit();
    }

    public class Node
    extends CachingSimpleNode {
        private Object myDelegate;
        private final List<Node> myChildren;

        public Node(Project project) {
            super(project, null);
            this.myChildren = new ArrayList<Node>();
        }

        public Node(SimpleNode parent, Object delegate) {
            super(parent);
            this.myChildren = new ArrayList<Node>();
            this.myDelegate = delegate;
        }

        public void setDelegate(Object delegate) {
            this.myDelegate = delegate;
        }

        public Object getDelegate() {
            return this.myDelegate;
        }

        @Override
        public String toString() {
            return String.valueOf(this.getDelegate());
        }

        @Override
        public boolean isContentHighlighted() {
            if (this.myDelegate instanceof SimpleNode) {
                return ((SimpleNode)this.myDelegate).isContentHighlighted();
            }
            return false;
        }

        @Override
        public boolean isHighlightableContentNode(PresentableNodeDescriptor kid) {
            if (this.myDelegate instanceof PresentableNodeDescriptor) {
                return ((PresentableNodeDescriptor)this.myDelegate).isHighlightableContentNode(kid);
            }
            return false;
        }

        @Override
        protected void updateFileStatus() {
        }

        @Override
        protected void doUpdate() {
            this.clearColoredText();
            if (this.myDelegate instanceof PresentableNodeDescriptor) {
                PresentableNodeDescriptor node = (PresentableNodeDescriptor)this.myDelegate;
                node.update();
                this.apply(node.getPresentation());
            } else if (this.myDelegate != null) {
                NodeDescriptor descriptor = FilteringTreeStructure.this.getStructure().createDescriptor(this.myDelegate, this.getParentDescriptor());
                Icon closedIcon = null;
                Icon openIcon = null;
                if (descriptor != null) {
                    descriptor.update();
                    closedIcon = descriptor.getClosedIcon();
                    openIcon = descriptor.getOpenIcon();
                }
                this.setIcons(closedIcon, openIcon);
                this.setPlainText(this.myDelegate.toString());
            }
        }

        @Override
        public int getWeight() {
            if (this.getDelegate() instanceof SimpleNode) {
                return ((SimpleNode)this.getDelegate()).getWeight();
            }
            return super.getWeight();
        }

        public void clear() {
            this.cleanUpCache();
            this.myChildren.clear();
        }

        public Node add(Object child) {
            Node childNode = new Node(this, child);
            this.myChildren.add(childNode);
            return childNode;
        }

        public void remove(Node node) {
            this.myChildren.remove(node);
        }

        @Override
        protected SimpleNode[] buildChildren() {
            return this.myChildren.toArray(new SimpleNode[this.myChildren.size()]);
        }

        @Override
        public Object[] getEqualityObjects() {
            return new Object[]{this.myDelegate};
        }
    }
}

