/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.config;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.config.Storage;
import org.jetbrains.annotations.NonNls;

public class StorageAccessors {
    private final Storage myStorage;

    public StorageAccessors(Storage storage) {
        this.myStorage = storage;
    }

    public static StorageAccessors createGlobal(@NonNls String prefix) {
        Application application = ApplicationManager.getApplication();
        Storage storage = application != null ? new Storage.PropertiesComponentStorage(prefix + ".") : new Storage.MapStorage();
        return new StorageAccessors(storage);
    }

    public float getFloat(@NonNls String id, float defaultValue) {
        String value = this.myStorage.get(id);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public void setFloat(String id, float value) {
        this.myStorage.put(id, String.valueOf(value));
    }

    public boolean getBoolean(String id, boolean defaultValue) {
        return Boolean.valueOf(this.myStorage.get(id));
    }

    public void setBoolean(String id, boolean value) {
        this.myStorage.put(id, String.valueOf(value));
    }
}

