/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;

public class NetUtils {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.net.NetUtils");

    private NetUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int findAvailableSocketPort() throws IOException {
        ServerSocket serverSocket = new ServerSocket(0);
        int port = serverSocket.getLocalPort();
        ServerSocket serverSocket2 = serverSocket;
        synchronized (serverSocket2) {
            try {
                serverSocket.wait(1L);
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
            }
        }
        serverSocket.close();
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] findAvailableSocketPorts(int capacity) throws IOException {
        int[] ports = new int[capacity];
        ServerSocket[] sockets = new ServerSocket[capacity];
        for (int i = 0; i < capacity; ++i) {
            ServerSocket serverSocket;
            sockets[i] = serverSocket = new ServerSocket(0);
            ports[i] = serverSocket.getLocalPort();
        }
        ServerSocket[] i = sockets;
        synchronized (sockets) {
            try {
                sockets.wait(1L);
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
            }
            for (ServerSocket socket : sockets) {
                socket.close();
            }
            return ports;
        }
    }

    public static String getLocalHostString() {
        String localHostString = "localhost";
        try {
            InetAddress localHost = InetAddress.getByName(localHostString);
            if (localHost.getAddress().length != 4 && SystemInfo.isWindows) {
                localHostString = "127.0.0.1";
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return localHostString;
    }
}

