/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.vcs.FileStatus;
import org.jetbrains.idea.svn.SvnFileStatus;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SvnStatusConvertor {
    private SvnStatusConvertor() {
    }

    public static FileStatus convertStatus(SVNStatus status) throws SVNException {
        if (status == null) {
            return FileStatus.UNKNOWN;
        }
        if (status.getContentsStatus() == SVNStatusType.STATUS_UNVERSIONED) {
            return FileStatus.UNKNOWN;
        }
        if (status.getContentsStatus() == SVNStatusType.STATUS_MISSING) {
            return FileStatus.DELETED_FROM_FS;
        }
        if (status.getContentsStatus() == SVNStatusType.STATUS_EXTERNAL) {
            return SvnFileStatus.EXTERNAL;
        }
        if (status.getContentsStatus() == SVNStatusType.STATUS_OBSTRUCTED) {
            return SvnFileStatus.OBSTRUCTED;
        }
        if (status.getContentsStatus() == SVNStatusType.STATUS_IGNORED) {
            return FileStatus.IGNORED;
        }
        if (status.getContentsStatus() == SVNStatusType.STATUS_ADDED) {
            return FileStatus.ADDED;
        }
        if (status.getContentsStatus() == SVNStatusType.STATUS_DELETED) {
            return FileStatus.DELETED;
        }
        if (status.getContentsStatus() == SVNStatusType.STATUS_REPLACED) {
            return SvnFileStatus.REPLACED;
        }
        if (status.getContentsStatus() == SVNStatusType.STATUS_CONFLICTED || status.getPropertiesStatus() == SVNStatusType.STATUS_CONFLICTED) {
            if (status.getContentsStatus() == SVNStatusType.STATUS_CONFLICTED && status.getPropertiesStatus() == SVNStatusType.STATUS_CONFLICTED) {
                return FileStatus.MERGED_WITH_BOTH_CONFLICTS;
            }
            if (status.getContentsStatus() == SVNStatusType.STATUS_CONFLICTED) {
                return FileStatus.MERGED_WITH_CONFLICTS;
            }
            return FileStatus.MERGED_WITH_PROPERTY_CONFLICTS;
        }
        if (status.getContentsStatus() == SVNStatusType.STATUS_MODIFIED || status.getPropertiesStatus() == SVNStatusType.STATUS_MODIFIED) {
            return FileStatus.MODIFIED;
        }
        if (status.isSwitched()) {
            return FileStatus.SWITCHED;
        }
        if (status.isCopied()) {
            return FileStatus.ADDED;
        }
        return FileStatus.NOT_CHANGED;
    }
}

