/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.BackgroundFromStartOption;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.ConflictedSvnChange;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNConflictChoice;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class MarkTreeConflictResolvedAction
extends AnAction
implements DumbAware {
    private static final String myText = SvnBundle.message("action.mark.tree.conflict.resolved.text", new Object[0]);

    public MarkTreeConflictResolvedAction() {
        super(myText);
    }

    public void update(AnActionEvent e) {
        MyChecker checker = new MyChecker(e);
        e.getPresentation().setVisible(checker.isEnabled());
        e.getPresentation().setEnabled(checker.isEnabled());
        e.getPresentation().setText(myText);
    }

    public void actionPerformed(AnActionEvent e) {
        final MyChecker checker = new MyChecker(e);
        if (!checker.isEnabled()) {
            return;
        }
        String markText = SvnBundle.message("action.mark.tree.conflict.resolved.confirmation.title", new Object[0]);
        int result = Messages.showYesNoDialog((Project)checker.getProject(), (String)SvnBundle.message("action.mark.tree.conflict.resolved.confirmation.text", new Object[0]), (String)markText, (Icon)Messages.getQuestionIcon());
        if (result == 0) {
            final Ref exception = new Ref();
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(checker.getProject(), markText, true, BackgroundFromStartOption.getInstance()){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/svn/actions/MarkTreeConflictResolvedAction$1.run must not be null");
                    }
                    ConflictedSvnChange change = checker.getChange();
                    FilePath path = change.getTreeConflictMarkHolder();
                    SVNWCClient client = SvnVcs.getInstance(checker.getProject()).createWCClient();
                    try {
                        client.doResolve(path.getIOFile(), SVNDepth.EMPTY, false, false, true, SVNConflictChoice.MERGED);
                    }
                    catch (SVNException e1) {
                        exception.set((Object)new VcsException((Throwable)e1));
                    }
                    VcsDirtyScopeManager.getInstance((Project)checker.getProject()).filePathsDirty(MarkTreeConflictResolvedAction.this.getDistinctFiles(change), null);
                }
            });
            if (!exception.isNull()) {
                AbstractVcsHelper.getInstance((Project)checker.getProject()).showError((VcsException)((Object)exception.get()), markText);
            }
        }
    }

    private Collection<FilePath> getDistinctFiles(Change change) {
        ArrayList<FilePath> result = new ArrayList<FilePath>(2);
        if (change.getBeforeRevision() != null) {
            result.add(change.getBeforeRevision().getFile());
        }
        if (change.getAfterRevision() != null && (change.getBeforeRevision() == null || change.getBeforeRevision() != null && (change.isMoved() || change.isRenamed()))) {
            result.add(change.getAfterRevision().getFile());
        }
        return result;
    }

    private static class MyChecker {
        private boolean myEnabled;
        private ConflictedSvnChange myChange;
        private final Project myProject;

        public MyChecker(AnActionEvent e) {
            DataContext dc = e.getDataContext();
            this.myProject = (Project)PlatformDataKeys.PROJECT.getData(dc);
            Change[] changes = (Change[])VcsDataKeys.CHANGE_LEAD_SELECTION.getData(dc);
            if (this.myProject == null || changes == null || changes.length != 1) {
                return;
            }
            Change change = changes[0];
            boolean bl = this.myEnabled = change instanceof ConflictedSvnChange && ((ConflictedSvnChange)change).getConflictState().isTree();
            if (this.myEnabled) {
                this.myChange = (ConflictedSvnChange)change;
            }
        }

        public boolean isEnabled() {
            return this.myEnabled;
        }

        public ConflictedSvnChange getChange() {
            return this.myChange;
        }

        public Project getProject() {
            return this.myProject;
        }
    }
}

