/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.ObjectsConvertor;
import com.intellij.openapi.vcs.QuantitySelection;
import com.intellij.openapi.vcs.SelectionResult;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.committed.CommittedChangeListRenderer;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.committed.RepositoryChangesBrowser;
import com.intellij.openapi.vcs.changes.issueLinks.AbstractBaseTagMouseListener;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableViewSpeedSearch;
import com.intellij.ui.table.TableView;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.idea.svn.dialogs.BasePageEngine;
import org.jetbrains.idea.svn.dialogs.PageEngine;
import org.jetbrains.idea.svn.dialogs.PagedListWithActions;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.mergeinfo.MergeChecker;

public class ToBeMergedDialog
extends DialogWrapper {
    public static final int MERGE_ALL_CODE = 222;
    private final JPanel myPanel;
    private final Project myProject;
    private final PageEngine<List<CommittedChangeList>> myListsEngine;
    private TableView<CommittedChangeList> myRevisionsList;
    private RepositoryChangesBrowser myRepositoryChangesBrowser;
    private Splitter mySplitter;
    private final QuantitySelection<Long> myWiseSelection;
    private final Set<Change> myAlreadyMerged;
    private final MergeChecker myMergeChecker;
    private static final int ourPageSize = 30;
    private static final ColumnInfo FAKE_COLUMN = new ColumnInfo<CommittedChangeList, CommittedChangeList>("fake column"){

        public CommittedChangeList valueOf(CommittedChangeList committedChangeList) {
            return committedChangeList;
        }
    };

    public ToBeMergedDialog(Project project, List<CommittedChangeList> lists, String title, MergeChecker mergeChecker) {
        super(project, true);
        this.myMergeChecker = mergeChecker;
        this.setTitle(title);
        this.myProject = project;
        this.myListsEngine = new BasePageEngine<CommittedChangeList>(lists, lists.size());
        this.myPanel = new JPanel(new BorderLayout());
        this.myWiseSelection = new QuantitySelection(true);
        this.myAlreadyMerged = new HashSet<Change>();
        this.setOKButtonText("Merge Selected");
        this.initUI();
        this.init();
    }

    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), new DialogWrapper.DialogWrapperAction("Merge All"){

            protected void doAction(ActionEvent e) {
                ToBeMergedDialog.this.close(222);
            }
        }, this.getCancelAction()};
    }

    public List<CommittedChangeList> getSelected() {
        SelectionResult selected = this.myWiseSelection.getSelected();
        SelectionResult unselected = this.myWiseSelection.getUnselected();
        LinkedList<CommittedChangeList> result = new LinkedList<CommittedChangeList>();
        result.addAll((Collection)this.myListsEngine.getCurrent());
        while (this.myListsEngine.hasNext()) {
            result.addAll((Collection)this.myListsEngine.next());
        }
        if (selected.isAll()) {
            Set excluded = unselected.getMarked();
            Iterator iterator = result.iterator();
            while (iterator.hasNext()) {
                CommittedChangeList list = (CommittedChangeList)iterator.next();
                if (!excluded.contains(list.getNumber())) continue;
                iterator.remove();
            }
        } else {
            Set included = selected.getMarked();
            Iterator iterator = result.iterator();
            while (iterator.hasNext()) {
                CommittedChangeList list = (CommittedChangeList)iterator.next();
                if (included.contains(list.getNumber())) continue;
                iterator.remove();
            }
        }
        return result;
    }

    protected String getDimensionServiceKey() {
        return "org.jetbrains.idea.svn.dialogs.ToBeMergedDialog";
    }

    private void initUI() {
        final ListSelectionListener selectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                List objects = ToBeMergedDialog.this.myRevisionsList.getSelectedObjects();
                ToBeMergedDialog.this.myRepositoryChangesBrowser.setChangesToDisplay(Collections.emptyList());
                ToBeMergedDialog.this.myAlreadyMerged.clear();
                if (objects != null && !objects.isEmpty()) {
                    List lists = ObjectsConvertor.convert((Collection)objects, (Convertor)new Convertor<Object, CommittedChangeList>(){

                        public CommittedChangeList convert(Object o) {
                            if (o instanceof CommittedChangeList) {
                                CommittedChangeList cl = (CommittedChangeList)o;
                                Collection<String> notMerged = ToBeMergedDialog.this.myMergeChecker.getNotMergedPaths(cl.getNumber());
                                SvnChangeList svnList = (SvnChangeList)cl;
                                HashSet<String> forCheck = new HashSet<String>();
                                forCheck.addAll(svnList.getAddedPaths());
                                forCheck.addAll(svnList.getChangedPaths());
                                forCheck.addAll(svnList.getDeletedPaths());
                                for (String path : forCheck) {
                                    if (notMerged == null || notMerged.isEmpty() || notMerged.contains(path)) continue;
                                    ToBeMergedDialog.this.myAlreadyMerged.add(((SvnChangeList)cl).getByPath(path));
                                }
                                return cl;
                            }
                            return null;
                        }
                    }, (NotNullFunction)ObjectsConvertor.NOT_NULL);
                    List changes = CommittedChangesTreeBrowser.collectChanges((List)lists, (boolean)false);
                    ToBeMergedDialog.this.myRepositoryChangesBrowser.setChangesToDisplay(changes);
                }
                ToBeMergedDialog.this.mySplitter.doLayout();
                ToBeMergedDialog.this.myRepositoryChangesBrowser.repaint();
            }
        };
        final MyListCellRenderer listCellRenderer = new MyListCellRenderer();
        this.myRevisionsList = new TableView<CommittedChangeList>(){

            public TableCellRenderer getCellRenderer(int row, int column) {
                return listCellRenderer;
            }

            public void valueChanged(ListSelectionEvent e) {
                super.valueChanged(e);
                selectionListener.valueChanged(e);
            }
        };
        new TableViewSpeedSearch(this.myRevisionsList){

            protected String getElementText(Object element) {
                if (element instanceof CommittedChangeList) {
                    return ((CommittedChangeList)element).getComment();
                }
                return null;
            }
        };
        final ListTableModel flatModel = new ListTableModel(new ColumnInfo[]{FAKE_COLUMN});
        this.myRevisionsList.setModel(flatModel);
        this.myRevisionsList.setTableHeader(null);
        this.myRevisionsList.setShowGrid(false);
        AbstractBaseTagMouseListener mouseListener = new AbstractBaseTagMouseListener(){

            protected Object getTagAt(MouseEvent e) {
                Object tag = null;
                JTable table = (JTable)e.getSource();
                int row = table.rowAtPoint(e.getPoint());
                int column = table.columnAtPoint(e.getPoint());
                listCellRenderer.customizeCellRenderer(table, table.getValueAt(row, column), table.isRowSelected(row), false, row, column);
                CommittedChangeListRenderer renderer = listCellRenderer.myRenderer;
                Rectangle rc = table.getCellRect(row, column, false);
                int index = renderer.findFragmentAt(e.getPoint().x - rc.x);
                if (index >= 0) {
                    tag = renderer.getFragmentTag(index);
                }
                return tag;
            }
        };
        mouseListener.install(this.myRevisionsList);
        PagedListWithActions.InnerComponentManager<CommittedChangeList> listsManager = new PagedListWithActions.InnerComponentManager<CommittedChangeList>(){

            @Override
            public Component getComponent() {
                return ToBeMergedDialog.this.myRevisionsList;
            }

            @Override
            public void setData(List<CommittedChangeList> committedChangeLists) {
                flatModel.setItems(committedChangeLists);
                flatModel.fireTableDataChanged();
            }

            @Override
            public void refresh() {
                ToBeMergedDialog.this.myRevisionsList.revalidate();
                ToBeMergedDialog.this.myRevisionsList.repaint();
            }
        };
        PagedListWithActions<CommittedChangeList> byRevisions = new PagedListWithActions<CommittedChangeList>(this.myListsEngine, listsManager, new AnAction[]{new MySelectAll(), new MyUnselectAll()});
        this.mySplitter = new Splitter(false, 0.7f);
        this.mySplitter.setFirstComponent(byRevisions.getComponent());
        flatModel.setItems(this.myListsEngine.getCurrent());
        flatModel.fireTableDataChanged();
        this.myRepositoryChangesBrowser = new RepositoryChangesBrowser(this.myProject, Collections.emptyList(), Collections.emptyList(), null);
        this.myRepositoryChangesBrowser.getDiffAction().registerCustomShortcutSet(CommonShortcuts.getDiff(), this.myRevisionsList);
        this.setChangesDecorator();
        this.mySplitter.setSecondComponent((JComponent)this.myRepositoryChangesBrowser);
        this.mySplitter.setDividerWidth(2);
        this.addRevisionListListeners();
        this.myPanel.add((Component)this.mySplitter, "Center");
    }

    private void setChangesDecorator() {
        this.myRepositoryChangesBrowser.setDecorator(new ChangeNodeDecorator(){

            public void decorate(Change change, SimpleColoredComponent component, boolean isShowFlatten) {
            }

            public List<Pair<String, ChangeNodeDecorator.Stress>> stressPartsOfFileName(Change change, String parentPath) {
                return null;
            }

            public void preDecorate(Change change, ChangesBrowserNodeRenderer renderer, boolean showFlatten) {
                if (ToBeMergedDialog.this.myAlreadyMerged.contains(change)) {
                    renderer.append(" [already merged] ", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                }
            }
        });
    }

    private void addRevisionListListeners() {
        final int checkboxWidth = new JCheckBox().getPreferredSize().width;
        this.myRevisionsList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int idx = ToBeMergedDialog.this.myRevisionsList.rowAtPoint(e.getPoint());
                if (idx >= 0) {
                    Rectangle baseRect = ToBeMergedDialog.this.myRevisionsList.getCellRect(idx, 0, false);
                    baseRect.setSize(checkboxWidth, baseRect.height);
                    if (baseRect.contains(e.getPoint())) {
                        SvnChangeList changeList = (SvnChangeList)ToBeMergedDialog.this.myRevisionsList.getModel().getValueAt(idx, 0);
                        long number = changeList.getNumber();
                        ToBeMergedDialog.this.toggleInclusion(number);
                        ToBeMergedDialog.this.myRevisionsList.repaint(baseRect);
                        e.consume();
                    }
                }
            }
        });
        this.myRevisionsList.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (32 == e.getKeyCode()) {
                    List selected = ToBeMergedDialog.this.myRevisionsList.getSelectedObjects();
                    if (selected == null || selected.isEmpty()) {
                        return;
                    }
                    for (Object o : selected) {
                        if (!(o instanceof SvnChangeList)) continue;
                        SvnChangeList changeList = (SvnChangeList)o;
                        ToBeMergedDialog.this.toggleInclusion(changeList.getNumber());
                    }
                    ToBeMergedDialog.this.myRevisionsList.repaint();
                    e.consume();
                }
            }
        });
    }

    private void toggleInclusion(long number) {
        if (this.myWiseSelection.isSelected((Object)number)) {
            this.myWiseSelection.remove((Object)number);
        } else {
            this.myWiseSelection.add((Object)number);
        }
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    private class MyListCellRenderer
    implements TableCellRenderer {
        private final JPanel myPanel = new JPanel(new BorderLayout());
        private final CommittedChangeListRenderer myRenderer;
        private JCheckBox myCheckBox = new JCheckBox();

        private MyListCellRenderer() {
            this.myCheckBox.setEnabled(true);
            this.myCheckBox.setSelected(true);
            this.myRenderer = new CommittedChangeListRenderer(ToBeMergedDialog.this.myProject, Collections.emptyList());
        }

        protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            this.myPanel.removeAll();
            this.myPanel.setBackground(null);
            this.myRenderer.clear();
            this.myRenderer.setBackground(null);
            if (value instanceof SvnChangeList) {
                SvnChangeList changeList = (SvnChangeList)value;
                this.myRenderer.renderChangeList((JComponent)table, (CommittedChangeList)changeList);
                Color bg = selected ? UIUtil.getTableSelectionBackground() : UIUtil.getTableBackground();
                Color fg = selected ? UIUtil.getTableSelectionForeground() : UIUtil.getTableForeground();
                this.myRenderer.setBackground(bg);
                this.myRenderer.setForeground(fg);
                this.myCheckBox.setBackground(bg);
                this.myCheckBox.setForeground(fg);
                this.myPanel.setBackground(bg);
                this.myPanel.setForeground(fg);
                this.myCheckBox.setSelected(ToBeMergedDialog.this.myWiseSelection.isSelected((Object)changeList.getNumber()));
                this.myPanel.add((Component)this.myCheckBox, "West");
                this.myPanel.add((Component)this.myRenderer, "Center");
            }
        }

        @Override
        public final Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.customizeCellRenderer(table, value, isSelected, hasFocus, row, column);
            return this.myPanel;
        }
    }

    private class MyUnselectAll
    extends DumbAwareAction {
        private MyUnselectAll() {
            super("Unselect All", "Unselect All", IconLoader.getIcon((String)"/actions/unselectall.png"));
        }

        public void actionPerformed(AnActionEvent e) {
            ToBeMergedDialog.this.myWiseSelection.clearAll();
            ToBeMergedDialog.this.myRevisionsList.repaint();
        }
    }

    private class MySelectAll
    extends DumbAwareAction {
        private MySelectAll() {
            super("Select All", "Select All", IconLoader.getIcon((String)"/actions/selectall.png"));
        }

        public void actionPerformed(AnActionEvent e) {
            ToBeMergedDialog.this.myWiseSelection.setAll();
            ToBeMergedDialog.this.myRevisionsList.repaint();
        }
    }
}

