/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gpp;

import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyIcons;
import org.jetbrains.plugins.groovy.config.AbstractGroovyLibraryManager;

public class GppLibraryManager
extends AbstractGroovyLibraryManager {
    private static final Pattern GROOVYPP_JAR = Pattern.compile("groovypp-([\\d\\.]+)\\.jar");
    private static final Pattern GROOVYPP_ALL_JAR = Pattern.compile("groovypp-all-([\\d\\.]+)\\.jar");

    protected void fillLibrary(String path, Library.ModifiableModel model) {
        File srcRoot;
        File lib = new File(path + "/lib");
        if (lib.exists()) {
            model.addJarDirectory(VfsUtil.getUrlForLibraryRoot((File)lib), false);
        }
        GppLibraryManager.addSources(model, (srcRoot = new File(path + "/src")).exists() ? srcRoot : new File(path));
    }

    private static void addSources(Library.ModifiableModel model, File srcRoot) {
        File mainSrc;
        File stdLibSrc;
        File compilerSrc = new File(srcRoot, "Compiler/src");
        if (compilerSrc.exists()) {
            model.addRoot(VfsUtil.getUrlForLibraryRoot((File)compilerSrc), OrderRootType.SOURCES);
        }
        if ((stdLibSrc = new File(srcRoot, "StdLib/src")).exists()) {
            model.addRoot(VfsUtil.getUrlForLibraryRoot((File)stdLibSrc), OrderRootType.SOURCES);
        }
        if ((mainSrc = new File(srcRoot, "main")).exists()) {
            model.addRoot(VfsUtil.getUrlForLibraryRoot((File)mainSrc), OrderRootType.SOURCES);
        }
    }

    public boolean managesLibrary(@NotNull Library library, LibrariesContainer container) {
        if (library == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/gpp/GppLibraryManager.managesLibrary must not be null");
        }
        return GppLibraryManager.getGppVersion(container.getLibraryFiles(library, OrderRootType.CLASSES)) != null;
    }

    @Nls
    public String getLibraryVersion(@NotNull Library library, LibrariesContainer librariesContainer) {
        if (library == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/gpp/GppLibraryManager.getLibraryVersion must not be null");
        }
        return GppLibraryManager.getGppVersion(librariesContainer.getLibraryFiles(library, OrderRootType.CLASSES));
    }

    @Nullable
    private static String getGppVersion(VirtualFile[] files) {
        for (VirtualFile file : files) {
            Matcher matcher = GROOVYPP_JAR.matcher(file.getName());
            if (matcher.matches()) {
                return matcher.group(1);
            }
            matcher = GROOVYPP_ALL_JAR.matcher(file.getName());
            if (!matcher.matches()) continue;
            return matcher.group(1);
        }
        return null;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = GroovyIcons.GROOVY_ICON_16x16;
        if (icon == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/gpp/GppLibraryManager.getIcon must not return null");
        }
        return icon;
    }

    @NotNull
    public String getSDKVersion(String path) {
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
        assert (file != null);
        VirtualFile libDir = file.findChild("lib");
        assert (libDir != null);
        String version = GppLibraryManager.getGppVersion(libDir.getChildren());
        if (version != null) {
            String string = version;
            if (string == null) {
                throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/gpp/GppLibraryManager.getSDKVersion must not return null");
            }
            return string;
        }
        throw new AssertionError((Object)path);
    }

    @NotNull
    public String getAddActionText() {
        if ("Create new Groovy++ SDK..." == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/gpp/GppLibraryManager.getAddActionText must not return null");
        }
        return "Create new Groovy++ SDK...";
    }

    @Nls
    @NotNull
    public String getLibraryCategoryName() {
        if ("Groovy++" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/gpp/GppLibraryManager.getLibraryCategoryName must not return null");
        }
        return "Groovy++";
    }

    public boolean managesName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/gpp/GppLibraryManager.managesName must not be null");
        }
        return super.managesName(name) || StringUtil.startsWithIgnoreCase((String)name, (String)"groovypp");
    }

    public boolean isSDKHome(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/gpp/GppLibraryManager.isSDKHome must not be null");
        }
        VirtualFile libDir = file.findChild("lib");
        return libDir != null && GppLibraryManager.getGppVersion(libDir.getChildren()) != null;
    }
}

