/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.ide.highlighter.XmlHighlighterFactory;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class CodeStyleXmlPanel
extends CodeStyleAbstractPanel {
    private JTextField myKeepBlankLines;
    private JComboBox myWrapAttributes;
    private JCheckBox myAlignAttributes;
    private JCheckBox myKeepWhiteSpaces;
    private JPanel myPanel;
    private JPanel myPreviewPanel;
    private JCheckBox mySpacesAroundEquality;
    private JCheckBox mySpacesAfterTagName;
    private JCheckBox myKeepLineBreaks;
    private JCheckBox myInEmptyTag;
    private JCheckBox myWrapText;
    private JCheckBox myKeepLineBreaksInText;

    public CodeStyleXmlPanel(CodeStyleSettings settings) {
        super(settings);
        this.$$$setupUI$$$();
        this.installPreviewPanel(this.myPreviewPanel);
        CodeStyleXmlPanel.fillWrappingCombo(this.myWrapAttributes);
        this.addPanelToWatch(this.myPanel);
    }

    @Override
    protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
        return XmlHighlighterFactory.createXMLHighlighter(scheme);
    }

    @Override
    protected int getRightMargin() {
        return 60;
    }

    @Override
    public void apply(CodeStyleSettings settings) {
        settings.XML_KEEP_BLANK_LINES = this.getIntValue(this.myKeepBlankLines);
        settings.XML_KEEP_LINE_BREAKS = this.myKeepLineBreaks.isSelected();
        settings.XML_KEEP_LINE_BREAKS_IN_TEXT = this.myKeepLineBreaksInText.isSelected();
        settings.XML_ATTRIBUTE_WRAP = ourWrappings[this.myWrapAttributes.getSelectedIndex()];
        settings.XML_TEXT_WRAP = this.myWrapText.isSelected() ? 1 : 0;
        settings.XML_ALIGN_ATTRIBUTES = this.myAlignAttributes.isSelected();
        settings.XML_KEEP_WHITESPACES = this.myKeepWhiteSpaces.isSelected();
        settings.XML_SPACE_AROUND_EQUALITY_IN_ATTRIBUTE = this.mySpacesAroundEquality.isSelected();
        settings.XML_SPACE_AFTER_TAG_NAME = this.mySpacesAfterTagName.isSelected();
        settings.XML_SPACE_INSIDE_EMPTY_TAG = this.myInEmptyTag.isSelected();
    }

    private int getIntValue(JTextField keepBlankLines) {
        try {
            return Integer.parseInt(keepBlankLines.getText());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    protected void resetImpl(CodeStyleSettings settings) {
        this.myKeepBlankLines.setText(String.valueOf(settings.XML_KEEP_BLANK_LINES));
        this.myWrapAttributes.setSelectedIndex(CodeStyleXmlPanel.getIndexForWrapping(settings.XML_ATTRIBUTE_WRAP));
        this.myAlignAttributes.setSelected(settings.XML_ALIGN_ATTRIBUTES);
        this.myKeepWhiteSpaces.setSelected(settings.XML_KEEP_WHITESPACES);
        this.mySpacesAfterTagName.setSelected(settings.XML_SPACE_AFTER_TAG_NAME);
        this.mySpacesAroundEquality.setSelected(settings.XML_SPACE_AROUND_EQUALITY_IN_ATTRIBUTE);
        this.myKeepLineBreaks.setSelected(settings.XML_KEEP_LINE_BREAKS);
        this.myKeepLineBreaksInText.setSelected(settings.XML_KEEP_LINE_BREAKS_IN_TEXT);
        this.myInEmptyTag.setSelected(settings.XML_SPACE_INSIDE_EMPTY_TAG);
        this.myWrapText.setSelected(this.wrapText(settings));
    }

    @Override
    public boolean isModified(CodeStyleSettings settings) {
        if (this.myWrapText.isSelected() != this.wrapText(settings)) {
            return true;
        }
        if (settings.XML_KEEP_BLANK_LINES != this.getIntValue(this.myKeepBlankLines)) {
            return true;
        }
        if (settings.XML_ATTRIBUTE_WRAP != ourWrappings[this.myWrapAttributes.getSelectedIndex()]) {
            return true;
        }
        if (settings.XML_ALIGN_ATTRIBUTES != this.myAlignAttributes.isSelected()) {
            return true;
        }
        if (settings.XML_KEEP_WHITESPACES != this.myKeepWhiteSpaces.isSelected()) {
            return true;
        }
        if (settings.XML_SPACE_AROUND_EQUALITY_IN_ATTRIBUTE != this.mySpacesAroundEquality.isSelected()) {
            return true;
        }
        if (settings.XML_SPACE_AFTER_TAG_NAME != this.mySpacesAfterTagName.isSelected()) {
            return true;
        }
        if (settings.XML_KEEP_LINE_BREAKS != this.myKeepLineBreaks.isSelected()) {
            return true;
        }
        if (settings.XML_KEEP_LINE_BREAKS_IN_TEXT != this.myKeepLineBreaksInText.isSelected()) {
            return true;
        }
        return settings.XML_SPACE_INSIDE_EMPTY_TAG != this.myInEmptyTag.isSelected();
    }

    private boolean wrapText(CodeStyleSettings settings) {
        return settings.XML_TEXT_WRAP == 1;
    }

    @Override
    public JComponent getPanel() {
        return this.myPanel;
    }

    @Override
    protected String getPreviewText() {
        return CodeStyleXmlPanel.readFromFile(this.getClass(), "preview.xml.template");
    }

    @Override
    @NotNull
    protected FileType getFileType() {
        LanguageFileType languageFileType = StdFileTypes.XML;
        if (languageFileType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/application/options/CodeStyleXmlPanel.getFileType must not return null");
        }
        return languageFileType;
    }

    @Override
    protected void prepareForReformat(PsiFile psiFile) {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JTextField jTextField;
        JCheckBox jCheckBox7;
        JComboBox jComboBox;
        JCheckBox jCheckBox8;
        JPanel jPanel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myPreviewPanel = jPanel = new JPanel();
        jPanel2.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("messages/ApplicationBundle").getString("title.preview"), 0, 0, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 3, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 2, 0, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(7, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.wrap.attributes"));
        jPanel4.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAlignAttributes = jCheckBox8 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox8, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.align.attributes"));
        jCheckBox8.setMargin(new Insets(0, 0, 0, 0));
        jPanel4.add((Component)jCheckBox8, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myWrapAttributes = jComboBox = new JComboBox();
        ((Component)jComboBox).setEnabled(true);
        jPanel4.add(jComboBox, new GridConstraints(3, 1, 1, 2, 8, 1, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(2, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myKeepLineBreaks = jCheckBox7 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox7, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.keep.line.breaks"));
        jCheckBox7.setMargin(new Insets(0, 0, 0, 0));
        jPanel4.add((Component)jCheckBox7, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(0, 1, 1, 2, 0, 1, 6, 1, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("editbox.keep.blank.lines"));
        jPanel4.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myKeepBlankLines = jTextField = new JTextField();
        jTextField.setColumns(3);
        jPanel4.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(40, -1), null));
        this.myWrapText = jCheckBox6 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.wrap.text"));
        jCheckBox6.setMargin(new Insets(2, 0, 2, 3));
        jPanel4.add((Component)jCheckBox6, new GridConstraints(6, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myKeepWhiteSpaces = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.keep.white.spaces"));
        jCheckBox5.setMargin(new Insets(0, 0, 0, 0));
        jPanel4.add((Component)jCheckBox5, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myKeepLineBreaksInText = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.keep.line.breaks.in.text"));
        jCheckBox4.setMargin(new Insets(0, 0, 0, 0));
        jPanel4.add((Component)jCheckBox4, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel4.add((Component)spacer3, new GridConstraints(1, 1, 1, 2, 0, 1, 6, 1, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("messages/ApplicationBundle").getString("title.spaces"), 0, 0, null, null));
        this.mySpacesAroundEquality = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.spaces.around.equals.in.attribute"));
        jCheckBox3.setMargin(new Insets(0, 0, 0, 0));
        jPanel5.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySpacesAfterTagName = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.spaces.around.tag.name"));
        jCheckBox2.setMargin(new Insets(0, 0, 0, 0));
        jPanel5.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myInEmptyTag = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.spaces.in.empty.tag"));
        jCheckBox.setMargin(new Insets(0, 0, 0, 0));
        jPanel5.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel3.add((Component)spacer4, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

