/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.OptionsContainingConfigurable;
import com.intellij.application.options.colors.ColorAndFontDescription;
import com.intellij.application.options.colors.ColorAndFontPanelFactory;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.ColorSettingsUtil;
import com.intellij.application.options.colors.EditorSchemeAttributeDescriptor;
import com.intellij.application.options.colors.FileStatusColorsPageFactory;
import com.intellij.application.options.colors.FontEditorPreview;
import com.intellij.application.options.colors.FontOptions;
import com.intellij.application.options.colors.NewColorAndFontPanel;
import com.intellij.application.options.colors.SchemesPanel;
import com.intellij.application.options.colors.ScopeColorsPageFactory;
import com.intellij.application.options.colors.SimpleEditorPreview;
import com.intellij.application.options.colors.TextAttributesDescription;
import com.intellij.application.options.editor.EditorOptionsProvider;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.diff.impl.settings.DiffOptionsPanel;
import com.intellij.openapi.diff.impl.settings.DiffPreviewPanel;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.ex.DefaultColorSchemesManager;
import com.intellij.openapi.editor.colors.impl.DefaultColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorsSchemeImpl;
import com.intellij.openapi.editor.colors.impl.ReadOnlyColorsScheme;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.options.colors.ColorSettingsPages;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusFactory;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorAndFontOptions
extends SearchableConfigurable.Parent.Abstract
implements EditorOptionsProvider {
    private HashMap<String, MyColorScheme> mySchemes;
    private MyColorScheme mySelectedScheme;
    public static final String DIFF_GROUP = ApplicationBundle.message((String)"title.diff", (Object[])new Object[0]);
    public static final String FILE_STATUS_GROUP = ApplicationBundle.message((String)"title.file.status", (Object[])new Object[0]);
    public static final String SCOPES_GROUP = ApplicationBundle.message((String)"title.scope.based", (Object[])new Object[0]);
    private boolean mySomeSchemesDeleted = false;
    private Map<ColorAndFontPanelFactory, InnerSearchableConfigurable> mySubPanelFactories;
    private SchemesPanel myRootSchemesPanel;
    private boolean myInitResetCompleted = false;
    private boolean myInitResetInvoked = false;
    private boolean myRevertChangesCompleted = false;
    private boolean myApplyCompleted = false;
    private boolean myDisposeCompleted = false;
    private final Disposable myDisposable = Disposer.newDisposable();
    private boolean myIsReset = false;

    public boolean isModified() {
        boolean listModified = this.isSchemeListModified();
        boolean schemeModified = this.isSomeSchemeModified();
        if (listModified || schemeModified) {
            this.myApplyCompleted = false;
        }
        return listModified;
    }

    private boolean isSchemeListModified() {
        if (this.mySomeSchemesDeleted) {
            return true;
        }
        if (!this.mySelectedScheme.getName().equals(EditorColorsManager.getInstance().getGlobalScheme().getName())) {
            return true;
        }
        for (MyColorScheme scheme : this.mySchemes.values()) {
            if (!scheme.isNew()) continue;
            return true;
        }
        return false;
    }

    private boolean isSomeSchemeModified() {
        for (MyColorScheme scheme : this.mySchemes.values()) {
            if (!scheme.isModified()) continue;
            return true;
        }
        return false;
    }

    public EditorColorsScheme selectScheme(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/application/options/colors/ColorAndFontOptions.selectScheme must not be null");
        }
        this.mySelectedScheme = this.getScheme(name);
        return this.mySelectedScheme;
    }

    private MyColorScheme getScheme(String name) {
        return (MyColorScheme)this.mySchemes.get((Object)name);
    }

    public EditorColorsScheme getSelectedScheme() {
        return this.mySelectedScheme;
    }

    public EditorColorsScheme getOriginalSelectedScheme() {
        return this.mySelectedScheme == null ? null : this.mySelectedScheme.getOriginalScheme();
    }

    public EditorSchemeAttributeDescriptor[] getCurrentDescriptions() {
        return this.mySelectedScheme.getDescriptors();
    }

    public static boolean isReadOnly(EditorColorsScheme scheme) {
        return ((MyColorScheme)scheme).isReadOnly();
    }

    public String[] getSchemeNames() {
        ArrayList schemes = new ArrayList(this.mySchemes.values());
        Collections.sort(schemes, new Comparator<MyColorScheme>(){

            @Override
            public int compare(MyColorScheme o1, MyColorScheme o2) {
                if (ColorAndFontOptions.isReadOnly(o1) && !ColorAndFontOptions.isReadOnly(o2)) {
                    return -1;
                }
                if (!ColorAndFontOptions.isReadOnly(o1) && ColorAndFontOptions.isReadOnly(o2)) {
                    return 1;
                }
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        ArrayList<String> names = new ArrayList<String>(schemes.size());
        for (MyColorScheme scheme : schemes) {
            names.add(scheme.getName());
        }
        return ArrayUtil.toStringArray(names);
    }

    public Collection<EditorColorsScheme> getSchemes() {
        return new ArrayList<EditorColorsScheme>(this.mySchemes.values());
    }

    public void saveSchemeAs(String name) {
        MyColorScheme scheme = this.mySelectedScheme;
        if (scheme == null) {
            return;
        }
        EditorColorsScheme clone = (EditorColorsScheme)scheme.getOriginalScheme().clone();
        scheme.apply(clone);
        clone.setName(name);
        MyColorScheme newScheme = new MyColorScheme(clone);
        ColorAndFontOptions.initScheme(newScheme);
        newScheme.setIsNew();
        this.mySchemes.put((Object)name, (Object)newScheme);
        this.selectScheme(newScheme.getName());
        this.resetSchemesCombo(null);
    }

    public void addImportedScheme(EditorColorsScheme imported) {
        MyColorScheme newScheme = new MyColorScheme(imported);
        ColorAndFontOptions.initScheme(newScheme);
        this.mySchemes.put((Object)imported.getName(), (Object)newScheme);
        this.selectScheme(newScheme.getName());
        this.resetSchemesCombo(null);
    }

    public void removeScheme(String name) {
        if (this.mySelectedScheme.getName().equals(name)) {
            this.selectScheme("Default");
        }
        boolean deletedNewlyCreated = false;
        MyColorScheme toDelete = (MyColorScheme)this.mySchemes.get((Object)name);
        if (toDelete != null) {
            deletedNewlyCreated = toDelete.isNew();
        }
        this.mySchemes.remove((Object)name);
        this.resetSchemesCombo(null);
        this.mySomeSchemesDeleted = this.mySomeSchemesDeleted || !deletedNewlyCreated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply() throws ConfigurationException {
        if (!this.myApplyCompleted) {
            try {
                EditorColorsManager myColorsManager = EditorColorsManager.getInstance();
                myColorsManager.removeAllSchemes();
                for (MyColorScheme scheme : this.mySchemes.values()) {
                    if (scheme.isDefault()) continue;
                    scheme.apply();
                    myColorsManager.addColorsScheme(scheme.getOriginalScheme());
                }
                EditorColorsScheme originalScheme = this.mySelectedScheme.getOriginalScheme();
                myColorsManager.setGlobalScheme(originalScheme);
                ColorAndFontOptions.applyChangesToEditors();
                this.reset();
            }
            finally {
                this.myApplyCompleted = true;
            }
        }
    }

    private static void applyChangesToEditors() {
        Project[] openProjects;
        EditorFactory.getInstance().refreshAllEditors();
        for (Project openProject : openProjects = ProjectManager.getInstance().getOpenProjects()) {
            FileStatusManager.getInstance((Project)openProject).fileStatusesChanged();
            DaemonCodeAnalyzer.getInstance((Project)openProject).restart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetSchemesCombo(Object source) {
        this.myIsReset = true;
        try {
            this.myRootSchemesPanel.resetSchemesCombo(source);
            if (this.mySubPanelFactories != null) {
                for (NewColorAndFontPanel subPartialConfigurable : this.getPanels()) {
                    subPartialConfigurable.reset(source);
                }
            }
        }
        finally {
            this.myIsReset = false;
        }
    }

    public JComponent createComponent() {
        if (this.myRootSchemesPanel == null) {
            this.ensureSchemesPanel();
        }
        return this.myRootSchemesPanel;
    }

    public boolean hasOwnContent() {
        return true;
    }

    protected Configurable[] buildConfigurables() {
        this.myDisposeCompleted = false;
        this.initAll();
        List<ColorAndFontPanelFactory> panelFactories = this.createPanelFactories();
        ArrayList<InnerSearchableConfigurable> result = new ArrayList<InnerSearchableConfigurable>();
        this.mySubPanelFactories = new LinkedHashMap<ColorAndFontPanelFactory, InnerSearchableConfigurable>(panelFactories.size());
        for (ColorAndFontPanelFactory panelFactory : panelFactories) {
            this.mySubPanelFactories.put(panelFactory, new InnerSearchableConfigurable(panelFactory));
        }
        result.addAll(new ArrayList<InnerSearchableConfigurable>(this.mySubPanelFactories.values()));
        return result.toArray(new Configurable[result.size()]);
    }

    private Set<NewColorAndFontPanel> getPanels() {
        HashSet<NewColorAndFontPanel> result = new HashSet<NewColorAndFontPanel>();
        for (InnerSearchableConfigurable configurable : this.mySubPanelFactories.values()) {
            NewColorAndFontPanel panel = configurable.getSubPanelIfInitialized();
            if (panel == null) continue;
            result.add(panel);
        }
        return result;
    }

    private List<ColorAndFontPanelFactory> createPanelFactories() {
        ColorSettingsPage[] pages;
        ArrayList<ColorAndFontPanelFactory> result = new ArrayList<ColorAndFontPanelFactory>();
        result.add(new FontConfigurableFactory());
        for (final ColorSettingsPage page : pages = ColorSettingsPages.getInstance().getRegisteredPages()) {
            result.add(new ColorAndFontPanelFactory(){

                @Override
                public NewColorAndFontPanel createPanel(ColorAndFontOptions options) {
                    SimpleEditorPreview preview = new SimpleEditorPreview(options, page);
                    return NewColorAndFontPanel.create(preview, page.getDisplayName(), options, null, page);
                }

                @Override
                public String getPanelDisplayName() {
                    return page.getDisplayName();
                }
            });
        }
        result.add(new DiffColorsPageFactory());
        result.add(new FileStatusColorsPageFactory());
        result.add(new ScopeColorsPageFactory());
        return result;
    }

    private void initAll() {
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        EditorColorsScheme[] allSchemes = colorsManager.getAllSchemes();
        this.mySchemes = new HashMap();
        for (EditorColorsScheme allScheme : allSchemes) {
            MyColorScheme schemeDelegate = new MyColorScheme(allScheme);
            ColorAndFontOptions.initScheme(schemeDelegate);
            this.mySchemes.put((Object)schemeDelegate.getName(), (Object)schemeDelegate);
        }
        this.mySelectedScheme = (MyColorScheme)this.mySchemes.get((Object)EditorColorsManager.getInstance().getGlobalScheme().getName());
        assert (this.mySelectedScheme != null) : EditorColorsManager.getInstance().getGlobalScheme().getName() + "; myschemes=" + this.mySchemes;
    }

    private static void initScheme(MyColorScheme scheme) {
        ArrayList<EditorSchemeAttributeDescriptor> descriptions = new ArrayList<EditorSchemeAttributeDescriptor>();
        ColorAndFontOptions.initPluggedDescriptions(descriptions, scheme);
        ColorAndFontOptions.initDiffDescriptors(descriptions, scheme);
        ColorAndFontOptions.initFileStatusDescriptors(descriptions, scheme);
        ColorAndFontOptions.initScopesDescriptors(descriptions, scheme);
        scheme.setDescriptors(descriptions.toArray(new EditorSchemeAttributeDescriptor[descriptions.size()]));
    }

    private static void initPluggedDescriptions(ArrayList<EditorSchemeAttributeDescriptor> descriptions, MyColorScheme scheme) {
        ColorSettingsPage[] pages;
        for (ColorSettingsPage page : pages = ColorSettingsPages.getInstance().getRegisteredPages()) {
            ColorAndFontOptions.initDescriptions(page, descriptions, scheme);
        }
    }

    private static void initDescriptions(ColorSettingsPage page, ArrayList<EditorSchemeAttributeDescriptor> descriptions, MyColorScheme scheme) {
        ColorDescriptor[] colorDescriptors;
        String group = page.getDisplayName();
        List<AttributesDescriptor> attributeDescriptors = ColorSettingsUtil.getAllAttributeDescriptors(page);
        for (AttributesDescriptor descriptor : attributeDescriptors) {
            ColorAndFontOptions.addSchemedDescription(descriptions, descriptor.getDisplayName(), group, descriptor.getKey(), scheme, null, null);
        }
        for (ColorDescriptor descriptor : colorDescriptors = page.getColorDescriptors()) {
            ColorKey back = descriptor.getKind() == ColorDescriptor.Kind.BACKGROUND ? descriptor.getKey() : null;
            ColorKey fore = descriptor.getKind() == ColorDescriptor.Kind.FOREGROUND ? descriptor.getKey() : null;
            ColorAndFontOptions.addEditorSettingDescription(descriptions, descriptor.getDisplayName(), group, back, fore, scheme);
        }
    }

    private static void initDiffDescriptors(ArrayList<EditorSchemeAttributeDescriptor> descriptions, MyColorScheme scheme) {
        DiffOptionsPanel.addSchemeDescriptions(descriptions, scheme);
    }

    private static void initFileStatusDescriptors(ArrayList<EditorSchemeAttributeDescriptor> descriptions, MyColorScheme scheme) {
        FileStatus[] statuses;
        for (FileStatus fileStatus : statuses = FileStatusFactory.SERVICE.getInstance().getAllFileStatuses()) {
            ColorAndFontOptions.addEditorSettingDescription(descriptions, fileStatus.getText(), FILE_STATUS_GROUP, null, fileStatus.getColorKey(), scheme);
        }
    }

    private static void initScopesDescriptors(ArrayList<EditorSchemeAttributeDescriptor> descriptions, MyColorScheme scheme) {
        Project[] projects;
        THashSet namedScopes = new THashSet((TObjectHashingStrategy)new TObjectHashingStrategy<Pair<NamedScope, NamedScopesHolder>>(){

            public int computeHashCode(Pair<NamedScope, NamedScopesHolder> object) {
                return ((NamedScope)object.getFirst()).getName().hashCode();
            }

            public boolean equals(Pair<NamedScope, NamedScopesHolder> o1, Pair<NamedScope, NamedScopesHolder> o2) {
                return ((NamedScope)o1.getFirst()).getName().equals(((NamedScope)o2.getFirst()).getName());
            }
        });
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            DaemonCodeAnalyzerImpl codeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)project);
            List<Pair<NamedScope, NamedScopesHolder>> cachedScopes = codeAnalyzer.getScopeBasedHighlightingCachedScopes();
            namedScopes.addAll(cachedScopes);
        }
        ArrayList list = new ArrayList(namedScopes);
        Collections.sort(list, new Comparator<Pair<NamedScope, NamedScopesHolder>>(){

            @Override
            public int compare(Pair<NamedScope, NamedScopesHolder> o1, Pair<NamedScope, NamedScopesHolder> o2) {
                return ((NamedScope)o1.getFirst()).getName().compareToIgnoreCase(((NamedScope)o2.getFirst()).getName());
            }
        });
        for (Pair pair : list) {
            NamedScope namedScope = (NamedScope)pair.getFirst();
            String name = namedScope.getName();
            TextAttributesKey textAttributesKey = ColorAndFontOptions.getScopeTextAttributeKey(name);
            if (scheme.getAttributes(textAttributesKey) == null) {
                scheme.setAttributes(textAttributesKey, new TextAttributes());
            }
            NamedScopesHolder holder = (NamedScopesHolder)pair.getSecond();
            PackageSet value = namedScope.getValue();
            String toolTip = holder.getDisplayName() + (value == null ? "" : ": " + value.getText());
            ColorAndFontOptions.addSchemedDescription(descriptions, name, SCOPES_GROUP, textAttributesKey, scheme, holder.getIcon(), toolTip);
        }
    }

    public static TextAttributesKey getScopeTextAttributeKey(String scope) {
        return TextAttributesKey.find((String)("SCOPE_KEY_" + scope));
    }

    private static void addEditorSettingDescription(ArrayList<EditorSchemeAttributeDescriptor> array, String name, String group, ColorKey backgroundKey, ColorKey foregroundKey, EditorColorsScheme scheme) {
        String type = null;
        if (foregroundKey != null) {
            type = foregroundKey.getExternalName();
        } else if (backgroundKey != null) {
            type = backgroundKey.getExternalName();
        }
        EditorSettingColorDescription descr = new EditorSettingColorDescription(name, group, backgroundKey, foregroundKey, type, scheme);
        array.add(descr);
    }

    private static void addSchemedDescription(ArrayList<EditorSchemeAttributeDescriptor> array, String name, String group, TextAttributesKey key, EditorColorsScheme scheme, Icon icon, String toolTip) {
        SchemeTextAttributesDescription descr = new SchemeTextAttributesDescription(name, group, key, scheme, icon, toolTip);
        array.add(descr);
    }

    public String getDisplayName() {
        return ApplicationBundle.message((String)"title.colors.and.fonts", (Object[])new Object[0]);
    }

    public Icon getIcon() {
        return IconLoader.getIcon((String)"/general/configurableColorsAndFonts.png");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void revertChanges() {
        if (this.isSchemeListModified() || this.isSomeSchemeModified()) {
            this.myRevertChangesCompleted = false;
        }
        if (!this.myRevertChangesCompleted) {
            this.ensureSchemesPanel();
            try {
                this.resetImpl();
            }
            finally {
                this.myRevertChangesCompleted = true;
            }
        }
    }

    private void resetImpl() {
        this.mySomeSchemesDeleted = false;
        this.initAll();
        this.resetSchemesCombo(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void reset() {
        if (!this.myInitResetInvoked) {
            try {
                super.reset();
                if (this.myInitResetCompleted) return;
                this.ensureSchemesPanel();
                try {
                    this.resetImpl();
                    return;
                }
                finally {
                    this.myInitResetCompleted = true;
                }
            }
            finally {
                this.myInitResetInvoked = true;
            }
        } else {
            this.revertChanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void resetFromChild() {
        if (!this.myInitResetCompleted) {
            this.ensureSchemesPanel();
            try {
                this.resetImpl();
            }
            finally {
                this.myInitResetCompleted = true;
            }
        }
    }

    private void ensureSchemesPanel() {
        if (this.myRootSchemesPanel == null) {
            this.myRootSchemesPanel = new SchemesPanel(this);
            this.myRootSchemesPanel.addListener(new ColorAndFontSettingsListener.Abstract(){

                @Override
                public void schemeChanged(Object source) {
                    if (!ColorAndFontOptions.this.myIsReset) {
                        ColorAndFontOptions.this.resetSchemesCombo(source);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeUIResources() {
        block7: {
            try {
                if (this.myDisposeCompleted) break block7;
                try {
                    super.disposeUIResources();
                    Disposer.dispose((Disposable)this.myDisposable);
                    if (this.myRootSchemesPanel != null) {
                        this.myRootSchemesPanel.disposeUIResources();
                    }
                }
                finally {
                    this.myDisposeCompleted = true;
                }
            }
            finally {
                this.mySubPanelFactories = null;
                this.myInitResetCompleted = false;
                this.myInitResetInvoked = false;
                this.myRevertChangesCompleted = false;
                this.myApplyCompleted = false;
                this.myRootSchemesPanel = null;
            }
        }
    }

    public boolean currentSchemeIsReadOnly() {
        return ColorAndFontOptions.isReadOnly(this.mySelectedScheme);
    }

    public boolean currentSchemeIsShared() {
        return ColorSettingsUtil.isSharedScheme(this.mySelectedScheme);
    }

    public String getHelpTopic() {
        return "reference.settingsdialog.IDE.editor.colors";
    }

    public String getId() {
        return this.getHelpTopic();
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    @Nullable
    public InnerSearchableConfigurable findSubConfigurable(Class pageClass) {
        if (this.mySubPanelFactories == null) {
            this.buildConfigurables();
        }
        for (Map.Entry<ColorAndFontPanelFactory, InnerSearchableConfigurable> entry : this.mySubPanelFactories.entrySet()) {
            if (!pageClass.isInstance(entry.getValue().createPanel().getSettingsPage())) continue;
            return entry.getValue();
        }
        return null;
    }

    @Nullable
    public NewColorAndFontPanel findPage(String pageName) {
        if (this.mySubPanelFactories == null) {
            this.buildConfigurables();
        }
        for (InnerSearchableConfigurable configurable : this.mySubPanelFactories.values()) {
            if (!configurable.getDisplayName().equals(pageName)) continue;
            return configurable.createPanel();
        }
        return null;
    }

    private class InnerSearchableConfigurable
    implements SearchableConfigurable,
    OptionsContainingConfigurable,
    Configurable.NoScroll {
        private NewColorAndFontPanel mySubPanel;
        private boolean mySubInitInvoked = false;
        private final ColorAndFontPanelFactory myFactory;

        private InnerSearchableConfigurable(ColorAndFontPanelFactory factory) {
            this.myFactory = factory;
        }

        @Nls
        public String getDisplayName() {
            return this.myFactory.getPanelDisplayName();
        }

        public NewColorAndFontPanel getSubPanelIfInitialized() {
            return this.mySubPanel;
        }

        private NewColorAndFontPanel createPanel() {
            if (this.mySubPanel == null) {
                this.mySubPanel = this.myFactory.createPanel(ColorAndFontOptions.this);
                this.mySubPanel.reset(this);
                this.mySubPanel.addSchemesListener(new ColorAndFontSettingsListener.Abstract(){

                    @Override
                    public void schemeChanged(Object source) {
                        if (!ColorAndFontOptions.this.myIsReset) {
                            ColorAndFontOptions.this.resetSchemesCombo(source);
                        }
                    }
                });
                this.mySubPanel.addDescriptionListener(new ColorAndFontSettingsListener.Abstract(){

                    @Override
                    public void fontChanged() {
                        for (NewColorAndFontPanel panel : ColorAndFontOptions.this.getPanels()) {
                            panel.updatePreview();
                        }
                    }
                });
            }
            return this.mySubPanel;
        }

        public Icon getIcon() {
            return null;
        }

        public String getHelpTopic() {
            return null;
        }

        public JComponent createComponent() {
            return this.createPanel().getPanel();
        }

        public boolean isModified() {
            this.createPanel();
            for (MyColorScheme scheme : ColorAndFontOptions.this.mySchemes.values()) {
                if (this.mySubPanel.containsFontOptions()) {
                    if (!scheme.isFontModified()) continue;
                    ColorAndFontOptions.this.myRevertChangesCompleted = false;
                    return true;
                }
                for (EditorSchemeAttributeDescriptor descriptor : scheme.getDescriptors()) {
                    if (!this.mySubPanel.contains(descriptor) || !descriptor.isModified()) continue;
                    ColorAndFontOptions.this.myRevertChangesCompleted = false;
                    return true;
                }
            }
            return false;
        }

        public void apply() throws ConfigurationException {
            ColorAndFontOptions.this.apply();
        }

        public void reset() {
            if (!this.mySubInitInvoked) {
                if (!ColorAndFontOptions.this.myInitResetCompleted) {
                    ColorAndFontOptions.this.resetFromChild();
                }
                this.mySubInitInvoked = true;
            } else {
                ColorAndFontOptions.this.revertChanges();
            }
        }

        public void disposeUIResources() {
            if (this.mySubPanel != null) {
                this.mySubPanel.disposeUIResources();
                this.mySubPanel = null;
            }
        }

        public String getId() {
            return ColorAndFontOptions.this.getId() + "." + this.getDisplayName();
        }

        public Runnable enableSearch(String option) {
            return this.createPanel().showOption(option);
        }

        @Override
        public Set<String> processListOptions() {
            return this.createPanel().processListOptions();
        }
    }

    private static class MyColorScheme
    extends EditorColorsSchemeImpl {
        private int myFontSize;
        private float myLineSpacing;
        private String myFontName;
        private EditorSchemeAttributeDescriptor[] myDescriptors;
        private String myName;
        private boolean myIsNew = false;

        private MyColorScheme(EditorColorsScheme parenScheme) {
            super(parenScheme, DefaultColorSchemesManager.getInstance());
            this.myFontSize = parenScheme.getEditorFontSize();
            this.myLineSpacing = parenScheme.getLineSpacing();
            this.myFontName = parenScheme.getEditorFontName();
            this.myName = parenScheme.getName();
            if (parenScheme instanceof ExternalizableScheme) {
                this.getExternalInfo().copy(((ExternalizableScheme)parenScheme).getExternalInfo());
            }
            this.initFonts();
        }

        @Override
        public String getName() {
            return this.myName;
        }

        @Override
        public void setName(String name) {
            this.myName = name;
        }

        public void setDescriptors(EditorSchemeAttributeDescriptor[] descriptors) {
            this.myDescriptors = descriptors;
        }

        public EditorSchemeAttributeDescriptor[] getDescriptors() {
            return this.myDescriptors;
        }

        public boolean isDefault() {
            return this.myParentScheme instanceof DefaultColorsScheme;
        }

        public boolean isReadOnly() {
            return this.myParentScheme instanceof ReadOnlyColorsScheme;
        }

        public boolean isModified() {
            if (this.isFontModified()) {
                return true;
            }
            for (EditorSchemeAttributeDescriptor descriptor : this.myDescriptors) {
                if (!descriptor.isModified()) continue;
                return true;
            }
            return false;
        }

        private boolean isFontModified() {
            if (this.myFontSize != this.myParentScheme.getEditorFontSize()) {
                return true;
            }
            if (this.myLineSpacing != this.myParentScheme.getLineSpacing()) {
                return true;
            }
            return !this.myFontName.equals(this.myParentScheme.getEditorFontName());
        }

        public void apply() {
            this.apply(this.myParentScheme);
        }

        public void apply(EditorColorsScheme scheme) {
            scheme.setEditorFontSize(this.myFontSize);
            scheme.setEditorFontName(this.myFontName);
            scheme.setLineSpacing(this.myLineSpacing);
            for (EditorSchemeAttributeDescriptor descriptor : this.myDescriptors) {
                descriptor.apply(scheme);
            }
        }

        @Override
        public String getEditorFontName() {
            return this.myFontName;
        }

        @Override
        public int getEditorFontSize() {
            return this.myFontSize;
        }

        @Override
        public float getLineSpacing() {
            return this.myLineSpacing;
        }

        @Override
        public void setEditorFontSize(int fontSize) {
            this.myFontSize = fontSize;
            this.initFonts();
        }

        @Override
        public void setLineSpacing(float lineSpacing) {
            this.myLineSpacing = lineSpacing;
        }

        @Override
        public void setEditorFontName(String fontName) {
            this.myFontName = fontName;
            this.initFonts();
        }

        @Override
        public Object clone() {
            return null;
        }

        public EditorColorsScheme getOriginalScheme() {
            return this.myParentScheme;
        }

        public void setIsNew() {
            this.myIsNew = true;
        }

        public boolean isNew() {
            return this.myIsNew;
        }
    }

    private static class EditorSettingColorDescription
    extends ColorAndFontDescription {
        private GetSetColor myGetSetForeground;
        private GetSetColor myGetSetBackground;

        private EditorSettingColorDescription(String name, String group, ColorKey backgroundKey, ColorKey foregroundKey, String type, EditorColorsScheme scheme) {
            super(name, group, type, scheme, null, null);
            if (backgroundKey != null) {
                this.myGetSetBackground = new GetSetColor(backgroundKey, scheme);
            }
            if (foregroundKey != null) {
                this.myGetSetForeground = new GetSetColor(foregroundKey, scheme);
            }
            this.initCheckedStatus();
        }

        @Override
        public int getFontType() {
            return 0;
        }

        @Override
        public void setFontType(int type) {
        }

        @Override
        public Color getExternalEffectColor() {
            return null;
        }

        @Override
        public void setExternalEffectColor(Color color) {
        }

        @Override
        public void setExternalEffectType(EffectType type) {
        }

        @Override
        public EffectType getExternalEffectType() {
            return EffectType.LINE_UNDERSCORE;
        }

        @Override
        public Color getExternalForeground() {
            if (this.myGetSetForeground == null) {
                return null;
            }
            return this.myGetSetForeground.getColor();
        }

        @Override
        public void setExternalForeground(Color col) {
            if (this.myGetSetForeground == null) {
                return;
            }
            this.myGetSetForeground.setColor(col);
        }

        @Override
        public Color getExternalBackground() {
            if (this.myGetSetBackground == null) {
                return null;
            }
            return this.myGetSetBackground.getColor();
        }

        @Override
        public void setExternalBackground(Color col) {
            if (this.myGetSetBackground == null) {
                return;
            }
            this.myGetSetBackground.setColor(col);
        }

        @Override
        public Color getExternalErrorStripe() {
            return null;
        }

        @Override
        public void setExternalErrorStripe(Color col) {
        }

        @Override
        public boolean isFontEnabled() {
            return false;
        }

        @Override
        public boolean isForegroundEnabled() {
            return this.myGetSetForeground != null;
        }

        @Override
        public boolean isBackgroundEnabled() {
            return this.myGetSetBackground != null;
        }

        @Override
        public boolean isEffectsColorEnabled() {
            return false;
        }

        @Override
        public boolean isModified() {
            return this.myGetSetBackground != null && this.myGetSetBackground.isModified() || this.myGetSetForeground != null && this.myGetSetForeground.isModified();
        }

        @Override
        public void apply(EditorColorsScheme scheme) {
            if (this.myGetSetBackground != null) {
                this.myGetSetBackground.apply(scheme);
            }
            if (this.myGetSetForeground != null) {
                this.myGetSetForeground.apply(scheme);
            }
        }
    }

    private static class GetSetColor {
        private final ColorKey myKey;
        private final EditorColorsScheme myScheme;
        private boolean isModified = false;
        private Color myColor;

        private GetSetColor(ColorKey key, EditorColorsScheme scheme) {
            this.myKey = key;
            this.myScheme = scheme;
            this.myColor = this.myScheme.getColor(this.myKey);
        }

        public Color getColor() {
            return this.myColor;
        }

        public void setColor(Color col) {
            if (this.getColor() == null || !this.getColor().equals(col)) {
                this.isModified = true;
                this.myColor = col;
            }
        }

        public void apply(EditorColorsScheme scheme) {
            if (scheme == null) {
                scheme = this.myScheme;
            }
            scheme.setColor(this.myKey, this.myColor);
        }

        public boolean isModified() {
            return this.isModified;
        }
    }

    private static class SchemeTextAttributesDescription
    extends TextAttributesDescription {
        private final TextAttributes myAttributesToApply;
        private final TextAttributesKey key;

        private SchemeTextAttributesDescription(String name, String group, TextAttributesKey key, EditorColorsScheme scheme, Icon icon, String toolTip) {
            super(name, group, scheme.getAttributes(key) == null ? new TextAttributes() : scheme.getAttributes(key).clone(), key, scheme, icon, toolTip);
            this.key = key;
            this.myAttributesToApply = scheme.getAttributes(key);
            this.initCheckedStatus();
        }

        @Override
        public void apply(EditorColorsScheme scheme) {
            if (scheme == null) {
                scheme = this.getScheme();
            }
            if (this.myAttributesToApply != null) {
                scheme.setAttributes(this.key, this.getTextAttributes());
            }
        }

        @Override
        public boolean isModified() {
            return !Comparing.equal((Object)this.myAttributesToApply, (Object)this.getTextAttributes());
        }

        @Override
        public boolean isErrorStripeEnabled() {
            return true;
        }
    }

    private class DiffColorsPageFactory
    implements ColorAndFontPanelFactory {
        private DiffColorsPageFactory() {
        }

        @Override
        public NewColorAndFontPanel createPanel(ColorAndFontOptions options) {
            final DiffPreviewPanel diffPreviewPanel = new DiffPreviewPanel(ColorAndFontOptions.this.myDisposable);
            diffPreviewPanel.setMergeRequest(null);
            final DiffOptionsPanel optionsPanel = new DiffOptionsPanel(options);
            SchemesPanel schemesPanel = new SchemesPanel(options);
            schemesPanel.addListener(new ColorAndFontSettingsListener.Abstract(){

                @Override
                public void schemeChanged(Object source) {
                    diffPreviewPanel.setColorScheme(ColorAndFontOptions.this.getSelectedScheme());
                    optionsPanel.updateOptionsList();
                    diffPreviewPanel.updateView();
                }
            });
            return new NewColorAndFontPanel(schemesPanel, optionsPanel, diffPreviewPanel, DIFF_GROUP, null, null);
        }

        @Override
        public String getPanelDisplayName() {
            return DIFF_GROUP;
        }
    }

    private static class FontConfigurableFactory
    implements ColorAndFontPanelFactory {
        private FontConfigurableFactory() {
        }

        @Override
        public NewColorAndFontPanel createPanel(ColorAndFontOptions options) {
            return new NewColorAndFontPanel(new SchemesPanel(options), new FontOptions(options), new FontEditorPreview(options), "Font", null, null){

                @Override
                public boolean containsFontOptions() {
                    return true;
                }
            };
        }

        @Override
        public String getPanelDisplayName() {
            return "Font";
        }
    }
}

