/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.TailType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import org.jetbrains.annotations.NotNull;

public class ExpectedTypeInfoImpl
implements ExpectedTypeInfo {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.ExpectedTypeInfoImpl");
    private final PsiType type;
    private final PsiType defaultType;
    private boolean myInsertExplicitTypeParams;
    private final int dimCount;
    public int kind;
    public TailType myTailType;
    public String expectedName;
    private PsiMethod myCalledMethod;

    int getDimCount() {
        return this.dimCount;
    }

    @Override
    public int getKind() {
        return this.kind;
    }

    @Override
    public TailType getTailType() {
        return this.myTailType;
    }

    public ExpectedTypeInfoImpl(@NotNull PsiType type, int kind, int dimCount, @NotNull PsiType defaultType, @NotNull TailType myTailType) {
        PsiType bound;
        PsiType[] parameters;
        PsiClassType psiClassType;
        PsiClass psiClass;
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/ExpectedTypeInfoImpl.<init> must not be null");
        }
        if (defaultType == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/codeInsight/ExpectedTypeInfoImpl.<init> must not be null");
        }
        if (myTailType == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/codeInsight/ExpectedTypeInfoImpl.<init> must not be null");
        }
        this.type = type;
        this.kind = kind;
        this.myTailType = myTailType;
        this.dimCount = dimCount;
        if (type == defaultType && type instanceof PsiClassType && (psiClass = (psiClassType = (PsiClassType)type).resolve()) != null && "java.lang.Class".equals(psiClass.getQualifiedName()) && (parameters = psiClassType.getParameters()).length == 1 && parameters[0] instanceof PsiWildcardType && (bound = ((PsiWildcardType)parameters[0]).getExtendsBound()) instanceof PsiClassType) {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)psiClass.getProject()).getElementFactory();
            defaultType = factory.createTypeFromText("java.lang.Class<" + bound.getCanonicalText() + ">", null);
        }
        this.defaultType = defaultType;
    }

    @Override
    public PsiMethod getCalledMethod() {
        return this.myCalledMethod;
    }

    public void setCalledMethod(PsiMethod calledMethod) {
        this.myCalledMethod = calledMethod;
    }

    @Override
    @NotNull
    public PsiType getType() {
        PsiType t = this.type;
        int dims = this.dimCount;
        while (dims-- > 0) {
            t = t.createArrayType();
        }
        PsiType psiType = t;
        if (psiType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExpectedTypeInfoImpl.getType must not return null");
        }
        return psiType;
    }

    @Override
    @NotNull
    public PsiType getDefaultType() {
        PsiType t = this.defaultType;
        int dims = this.dimCount;
        while (dims-- > 0) {
            t = t.createArrayType();
        }
        PsiType psiType = t;
        if (psiType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExpectedTypeInfoImpl.getDefaultType must not return null");
        }
        return psiType;
    }

    @Override
    public boolean isInsertExplicitTypeParams() {
        return this.myInsertExplicitTypeParams;
    }

    public void setInsertExplicitTypeParams(boolean insertExplicitTypeParams) {
        this.myInsertExplicitTypeParams = insertExplicitTypeParams;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExpectedTypeInfoImpl)) {
            return false;
        }
        ExpectedTypeInfoImpl that = (ExpectedTypeInfoImpl)o;
        if (this.dimCount != that.dimCount) {
            return false;
        }
        if (this.kind != that.kind) {
            return false;
        }
        if (this.defaultType != null ? !this.defaultType.equals(that.defaultType) : that.defaultType != null) {
            return false;
        }
        if (this.myTailType != null ? !this.myTailType.equals(that.myTailType) : that.myTailType != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.defaultType != null ? this.defaultType.hashCode() : 0);
        result = 31 * result + this.dimCount;
        result = 31 * result + this.kind;
        result = 31 * result + (this.myTailType != null ? this.myTailType.hashCode() : 0);
        return result;
    }

    @Override
    public boolean equals(ExpectedTypeInfo obj) {
        return this.equals((Object)obj);
    }

    @Override
    public String toString() {
        return "ExpectedTypeInfo[type='" + this.type + "' kind='" + this.kind + "' dims='" + this.dimCount + "']";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ExpectedTypeInfo[] intersect(ExpectedTypeInfo info) {
        PsiType otherType;
        ExpectedTypeInfoImpl info1 = (ExpectedTypeInfoImpl)info;
        LOG.assertTrue(!(this.type instanceof PsiArrayType) && !(info1.type instanceof PsiArrayType));
        if (this.kind == 0) {
            if (info1.kind != 0) return info1.intersect(this);
            if (this.dimCount != info1.dimCount) {
                return ExpectedTypeInfo.EMPTY_ARRAY;
            }
            if (!info1.type.equals(this.type)) return ExpectedTypeInfo.EMPTY_ARRAY;
            return new ExpectedTypeInfoImpl[]{this};
        }
        if (this.kind == 1) {
            PsiType otherType2;
            if (info1.kind == 0) {
                if (this.dimCount != info1.dimCount) {
                    return ExpectedTypeInfo.EMPTY_ARRAY;
                }
                if (!this.type.isAssignableFrom(info1.type)) return ExpectedTypeInfo.EMPTY_ARRAY;
                return new ExpectedTypeInfoImpl[]{info1};
            }
            if (info1.kind != 1) return info1.intersect(this);
            PsiType type = this.dimCount == info1.dimCount ? this.type : this.getType();
            PsiType psiType = otherType2 = this.dimCount == info1.dimCount ? info1.type : info1.getType();
            if (type.isAssignableFrom(otherType2)) {
                return new ExpectedTypeInfoImpl[]{info1};
            }
            if (!otherType2.isAssignableFrom(type)) return ExpectedTypeInfo.EMPTY_ARRAY;
            return new ExpectedTypeInfoImpl[]{this};
        }
        if (this.kind != 2) return ExpectedTypeInfo.EMPTY_ARRAY;
        if (info1.kind == 0) {
            if (this.dimCount != info1.dimCount) {
                return ExpectedTypeInfo.EMPTY_ARRAY;
            }
            if (!info1.type.isAssignableFrom(this.type)) return ExpectedTypeInfo.EMPTY_ARRAY;
            return new ExpectedTypeInfoImpl[]{info1};
        }
        if (info1.kind == 1) {
            PsiType otherType3;
            PsiType type = this.dimCount == info1.dimCount ? this.type : this.getType();
            PsiType psiType = otherType3 = this.dimCount == info1.dimCount ? info1.type : info1.getType();
            if (!otherType3.isAssignableFrom(type)) return ExpectedTypeInfo.EMPTY_ARRAY;
            return new ExpectedTypeInfoImpl[]{this};
        }
        if (info1.kind != 2) return info1.intersect(this);
        PsiType type = this.dimCount == info1.dimCount ? this.type : this.getType();
        PsiType psiType = otherType = this.dimCount == info1.dimCount ? info1.type : info1.getType();
        if (type.isAssignableFrom(otherType)) {
            return new ExpectedTypeInfoImpl[]{this};
        }
        if (!otherType.isAssignableFrom(type)) return ExpectedTypeInfo.EMPTY_ARRAY;
        return new ExpectedTypeInfoImpl[]{info1};
    }

    @Override
    public boolean isArrayTypeInfo() {
        return this.dimCount > 0;
    }
}

