/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.daemon.impl.actions.AddImportAction;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupActionProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Consumer;

public class ExcludeFromCompletionLookupActionProvider
implements LookupActionProvider {
    @Override
    public void fillActions(LookupElement element, Lookup lookup, Consumer<LookupElementAction> consumer) {
        String qname;
        Object o = element.getObject();
        PsiClass clazz = null;
        if (o instanceof PsiType) {
            clazz = PsiUtil.resolveClassInType((PsiType)((PsiType)o));
        } else if (o instanceof PsiClass) {
            clazz = (PsiClass)o;
        }
        if (clazz != null && clazz.isValid() && (qname = clazz.getQualifiedName()) != null) {
            Project project = clazz.getProject();
            for (String s : AddImportAction.getAllExcludableStrings(qname)) {
                consumer.consume((Object)new ExcludeFromCompletionAction(project, s));
            }
        }
    }

    private static class ExcludeFromCompletionAction
    extends LookupElementAction {
        private final Project myProject;
        private final String myToExclude;

        public ExcludeFromCompletionAction(Project project, String s) {
            super(null, "Exclude '" + s + "' from completion");
            this.myProject = project;
            this.myToExclude = s;
        }

        @Override
        public void performLookupAction() {
            AddImportAction.excludeFromImport(this.myProject, this.myToExclude);
        }
    }
}

