/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.CompletionVariant;
import com.intellij.codeInsight.completion.XmlCompletionData;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.OrFilter;
import com.intellij.psi.filters.TextContainFilter;
import com.intellij.psi.filters.getters.HtmlAttributeValueGetter;
import com.intellij.psi.filters.getters.XmlAttributeValueGetter;
import com.intellij.psi.filters.position.XmlTokenTypeFilter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import java.util.Set;
import org.jetbrains.annotations.NonNls;

public class HtmlCompletionData
extends XmlCompletionData {
    private static CompletionData ourStyleCompletionData;
    private boolean myCaseInsensitive;
    private static CompletionData ourScriptCompletionData;
    @NonNls
    private static final String JAVASCRIPT_LANGUAGE_ID = "JavaScript";
    @NonNls
    private static final String STYLE_TAG = "style";
    @NonNls
    private static final String SCRIPT_TAG = "script";

    public HtmlCompletionData() {
        this(true);
    }

    protected HtmlCompletionData(boolean _caseInsensitive) {
        this.myCaseInsensitive = _caseInsensitive;
    }

    @Override
    protected ElementFilter createXmlEntityCompletionFilter() {
        if (this.isCaseInsensitive()) {
            return new AndFilter((ElementFilter)new OrFilter(new XmlTokenTypeFilter(XmlTokenType.XML_DATA_CHARACTERS), new XmlTokenTypeFilter(XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN)), (ElementFilter)new TextContainFilter("&"));
        }
        return super.createXmlEntityCompletionFilter();
    }

    private boolean equalNames(String str, String str2) {
        if (!this.myCaseInsensitive) {
            return str.equals(str2);
        }
        return str.equalsIgnoreCase(str2);
    }

    protected boolean isCaseInsensitive() {
        return true;
    }

    protected void setCaseInsensitive(boolean caseInsensitive) {
        this.myCaseInsensitive = caseInsensitive;
    }

    @Override
    protected XmlAttributeValueGetter getAttributeValueGetter() {
        return new HtmlAttributeValueGetter(!this.isCaseInsensitive());
    }

    @Override
    protected ElementFilter createTagCompletionFilter() {
        return new ElementFilter(){

            public boolean isAcceptable(Object element, PsiElement context) {
                String name = ((XmlTag)context).getName();
                if (name == null) {
                    return true;
                }
                if (element instanceof PsiElement && ((PsiElement)element).getParent() == context) {
                    return true;
                }
                if (HtmlCompletionData.this.equalNames(name, HtmlCompletionData.STYLE_TAG) || HtmlCompletionData.this.equalNames(name, HtmlCompletionData.SCRIPT_TAG)) {
                    return false;
                }
                return !HtmlCompletionData.this.isStyleAttributeContext((PsiElement)element);
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        };
    }

    @Override
    protected ElementFilter createAttributeCompletionFilter() {
        return new ElementFilter(){

            public boolean isAcceptable(Object element, PsiElement context) {
                return !HtmlCompletionData.this.isStyleAttributeContext(context);
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        };
    }

    @Override
    protected ElementFilter createAttributeValueCompletionFilter() {
        return new ElementFilter(){

            public boolean isAcceptable(Object element, PsiElement context) {
                if (HtmlCompletionData.this.isStyleAttributeContext(context)) {
                    return false;
                }
                return !HtmlCompletionData.this.isScriptContext((PsiElement)element);
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        };
    }

    private boolean isScriptContext(PsiElement element) {
        Language language = element.getLanguage();
        return language.getID().equals(JAVASCRIPT_LANGUAGE_ID);
    }

    private boolean isScriptTag(XmlTag tag) {
        if (tag != null) {
            String tagName = tag.getName();
            if (tagName == null) {
                return false;
            }
            if (this.myCaseInsensitive) {
                return tagName.equalsIgnoreCase(SCRIPT_TAG);
            }
            return tagName.equals(SCRIPT_TAG);
        }
        return false;
    }

    private boolean isStyleTag(XmlTag tag) {
        if (tag != null) {
            String tagName = tag.getName();
            if (tagName == null) {
                return false;
            }
            if (this.myCaseInsensitive) {
                return tagName.equalsIgnoreCase(STYLE_TAG);
            }
            return tagName.equals(STYLE_TAG);
        }
        return false;
    }

    @Override
    public CompletionVariant[] findVariants(final PsiElement position, final PsiFile file) {
        return (CompletionVariant[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<CompletionVariant[]>(){

            public CompletionVariant[] compute() {
                Object[] variants = HtmlCompletionData.super.findVariants(position, file);
                if (ourStyleCompletionData != null && HtmlCompletionData.this.isStyleContext(position)) {
                    Object[] styleVariants = ourStyleCompletionData.findVariants(position, file);
                    variants = (CompletionVariant[])ArrayUtil.mergeArrays((Object[])variants, (Object[])styleVariants, CompletionVariant.class);
                }
                if (ourScriptCompletionData != null && HtmlCompletionData.this.isScriptContext(position)) {
                    Object[] scriptVariants = ourScriptCompletionData.findVariants(position, file);
                    variants = (CompletionVariant[])ArrayUtil.mergeArrays((Object[])variants, (Object[])scriptVariants, CompletionVariant.class);
                }
                return variants;
            }
        });
    }

    private boolean isStyleAttributeContext(PsiElement position) {
        String name;
        XmlAttribute parentOfType = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)position, XmlAttribute.class, (boolean)false);
        if (parentOfType != null && (name = parentOfType.getName()) != null) {
            if (this.myCaseInsensitive) {
                return STYLE_TAG.equalsIgnoreCase(name);
            }
            return STYLE_TAG.equals(name);
        }
        return false;
    }

    private boolean isStyleContext(PsiElement position) {
        if (this.isStyleAttributeContext(position)) {
            return true;
        }
        return this.isStyleTag((XmlTag)PsiTreeUtil.getParentOfType((PsiElement)position, XmlTag.class, (boolean)false));
    }

    @Override
    public void addKeywordVariants(final Set<CompletionVariant> set, final PsiElement position, final PsiFile file) {
        super.addKeywordVariants(set, position, file);
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                if (ourStyleCompletionData != null && HtmlCompletionData.this.isStyleContext(position)) {
                    ourStyleCompletionData.addKeywordVariants(set, position, file);
                } else if (ourScriptCompletionData != null && HtmlCompletionData.this.isScriptContext(position)) {
                    ourScriptCompletionData.addKeywordVariants(set, position, file);
                }
            }
        });
    }

    public static void setStyleCompletionData(CompletionData cssCompletionData) {
        ourStyleCompletionData = cssCompletionData;
    }

    @Override
    public void registerVariant(CompletionVariant variant) {
        super.registerVariant(variant);
        if (this.isCaseInsensitive()) {
            variant.setCaseInsensitive(true);
        }
    }

    @Override
    public String findPrefix(PsiElement insertedElement, int offset) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)insertedElement, XmlTag.class, (boolean)false);
        String prefix = null;
        if (this.isScriptTag(tag) && ourScriptCompletionData != null && !(insertedElement.getParent() instanceof XmlAttributeValue)) {
            prefix = ourScriptCompletionData.findPrefix(insertedElement, offset);
        } else if (this.isStyleTag(tag) && ourStyleCompletionData != null) {
            prefix = ourStyleCompletionData.findPrefix(insertedElement, offset);
        }
        if (prefix == null) {
            boolean searchForEntities;
            prefix = super.findPrefix(insertedElement, offset);
            boolean bl = searchForEntities = insertedElement instanceof XmlToken && (((XmlToken)insertedElement).getTokenType() == XmlTokenType.XML_DATA_CHARACTERS || ((XmlToken)insertedElement).getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN);
            if (searchForEntities && prefix != null) {
                if (prefix.startsWith("&")) {
                    prefix = prefix.substring(1);
                } else if (prefix.contains("&")) {
                    prefix = prefix.substring(prefix.indexOf("&") + 1);
                }
            }
        }
        return prefix;
    }

    public static void setScriptCompletionData(CompletionData scriptCompletionData) {
        ourScriptCompletionData = scriptCompletionData;
    }
}

