/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.AllClassesGetter;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.util.PsiTreeUtil;

public class JavaClassNameInsertHandler
implements AllClassesGetter.ClassNameInsertHandler {
    @Override
    public AllClassesGetter.ClassNameInsertHandlerResult handleInsert(InsertionContext context, JavaPsiClassReferenceElement item) {
        Editor editor = context.getEditor();
        PsiFile file = context.getFile();
        int endOffset = editor.getCaretModel().getOffset();
        if (file.getLanguage() == StdLanguages.JAVA) {
            if (PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)(endOffset - 1), PsiImportStatementBase.class, (boolean)false) != null) {
                return AllClassesGetter.ClassNameInsertHandlerResult.INSERT_FQN;
            }
            JavaPsiClassReferenceElement.JAVA_CLASS_INSERT_HANDLER.handleInsert(context, (LookupElement)item);
        }
        return AllClassesGetter.ClassNameInsertHandlerResult.CHECK_FOR_CORRECT_REFERENCE;
    }
}

