/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.MacroFactory;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.htmlInspections.RequiredAttributesInspection;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementDescriptorWithCDataContent;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class XmlTagInsertHandler
implements InsertHandler<LookupElement> {
    public static final XmlTagInsertHandler INSTANCE = new XmlTagInsertHandler();

    public void handleInsert(InsertionContext context, LookupElement item) {
        Project project = context.getProject();
        Editor editor = context.getEditor();
        int offset = editor.getCaretModel().getOffset();
        editor.getDocument().insertString(offset, (CharSequence)" ");
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        PsiElement current = context.getFile().findElementAt(context.getStartOffset());
        editor.getDocument().deleteString(offset, offset + 1);
        XmlTag tag = (XmlTag)PsiTreeUtil.getContextOfType((PsiElement)current, XmlTag.class, (boolean)true);
        if (tag == null) {
            return;
        }
        context.setAddCompletionChar(false);
        XmlElementDescriptor descriptor = tag.getDescriptor();
        if (XmlUtil.getTokenOfType((PsiElement)tag, XmlTokenType.XML_TAG_END) == null && XmlUtil.getTokenOfType((PsiElement)tag, XmlTokenType.XML_EMPTY_ELEMENT_END) == null) {
            Template t = TemplateManager.getInstance(project).getActiveTemplate(editor);
            if (t == null && descriptor != null) {
                XmlTagInsertHandler.insertIncompleteTag(context.getCompletionChar(), editor, project, descriptor, tag);
            }
        } else if (context.getCompletionChar() == '\t') {
            PsiElement sibling;
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            int caretOffset = editor.getCaretModel().getOffset();
            PsiElement otherTag = PsiTreeUtil.getParentOfType((PsiElement)context.getFile().findElementAt(caretOffset), XmlTag.class);
            XmlToken endTagStart = XmlUtil.getTokenOfType(otherTag, XmlTokenType.XML_END_TAG_START);
            if (endTagStart != null && (sibling = endTagStart.getNextSibling()).getNode().getElementType() == XmlTokenType.XML_NAME) {
                int sOffset = sibling.getTextRange().getStartOffset();
                int eOffset = sibling.getTextRange().getEndOffset();
                editor.getDocument().deleteString(sOffset, eOffset);
                editor.getDocument().insertString(sOffset, (CharSequence)((XmlTag)otherTag).getName());
            }
            editor.getCaretModel().moveToOffset(caretOffset + 1);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            editor.getSelectionModel().removeSelection();
        }
        if (context.getCompletionChar() == ' ' && TemplateManager.getInstance(project).getActiveTemplate(editor) != null) {
            return;
        }
        TailType tailType = LookupItem.handleCompletionChar(editor, item, context.getCompletionChar());
        tailType.processTail(editor, editor.getCaretModel().getOffset());
    }

    private static void insertIncompleteTag(char completionChar, final Editor editor, final Project project, XmlElementDescriptor descriptor, XmlTag tag) {
        TemplateManager templateManager = TemplateManager.getInstance(project);
        Template template = templateManager.createTemplate("", "");
        template.setToIndent(true);
        boolean htmlCode = HtmlUtil.hasHtml(tag.getContainingFile());
        Set notRequiredAttributes = Collections.emptySet();
        if (tag instanceof HtmlTag) {
            RequiredAttributesInspection inspection;
            InspectionProfile profile = InspectionProjectProfileManager.getInstance(tag.getProject()).getInspectionProfile();
            LocalInspectionToolWrapper localInspectionToolWrapper = (LocalInspectionToolWrapper)profile.getInspectionTool("RequiredAttributes", (PsiElement)tag);
            RequiredAttributesInspection requiredAttributesInspection = inspection = localInspectionToolWrapper != null ? (RequiredAttributesInspection)localInspectionToolWrapper.getTool() : null;
            if (inspection != null) {
                StringTokenizer tokenizer = new StringTokenizer(inspection.getAdditionalEntries(0));
                notRequiredAttributes = new HashSet(1);
                while (tokenizer.hasMoreElements()) {
                    notRequiredAttributes.add(tokenizer.nextToken());
                }
            }
        }
        boolean toReformat = true;
        boolean weInsertedSomeCodeThatCouldBeInvalidated = false;
        if (htmlCode) {
            toReformat = false;
        }
        template.setToReformat(toReformat);
        XmlAttributeDescriptor[] attributes = descriptor.getAttributesDescriptors(tag);
        StringBuilder indirectRequiredAttrs = null;
        XmlExtension extension = XmlExtension.getExtension(tag.getContainingFile());
        if (WebEditorOptions.getInstance().isAutomaticallyInsertRequiredAttributes()) {
            for (XmlAttributeDescriptor attributeDecl : attributes) {
                String attributeName = attributeDecl.getName((PsiElement)tag);
                if (attributeDecl.isRequired() && tag.getAttributeValue(attributeName) == null) {
                    if (notRequiredAttributes.contains(attributeName)) continue;
                    if (!extension.isIndirectSyntax(attributeDecl)) {
                        template.addTextSegment(" " + attributeName + "=\"");
                        MacroCallNode expression = new MacroCallNode(MacroFactory.createMacro("complete"));
                        template.addVariable(attributeName, expression, expression, true);
                        template.addTextSegment("\"");
                        continue;
                    }
                    if (indirectRequiredAttrs == null) {
                        indirectRequiredAttrs = new StringBuilder();
                    }
                    indirectRequiredAttrs.append("\n<jsp:attribute name=\"").append(attributeName).append("\"></jsp:attribute>\n");
                    continue;
                }
                if (!attributeDecl.isFixed() || attributeDecl.getDefaultValue() == null || htmlCode) continue;
                template.addTextSegment(" " + attributeName + "=\"" + attributeDecl.getDefaultValue() + "\"");
            }
        }
        if (completionChar == '>' || completionChar == '/' && indirectRequiredAttrs != null) {
            String name;
            XmlElementDescriptorWithCDataContent cDataContainer;
            template.addTextSegment(">");
            boolean toInsertCDataEnd = false;
            if (descriptor instanceof XmlElementDescriptorWithCDataContent && (cDataContainer = (XmlElementDescriptorWithCDataContent)descriptor).requiresCdataBracesInContext(tag)) {
                template.addTextSegment("<![CDATA[\n");
                toInsertCDataEnd = true;
            }
            if (indirectRequiredAttrs != null) {
                template.addTextSegment(indirectRequiredAttrs.toString());
            }
            template.addEndVariable();
            if (toInsertCDataEnd) {
                template.addTextSegment("\n]]>");
            }
            if (!(tag instanceof HtmlTag && HtmlUtil.isSingleHtmlTag(tag.getName()) || tag.getAttributes().length != 0 || !WebEditorOptions.getInstance().isAutomaticallyInsertClosingTag() || (name = descriptor.getName((PsiElement)tag)) == null)) {
                template.addTextSegment("</");
                template.addTextSegment(name);
                template.addTextSegment(">");
            }
        } else if (completionChar == '/') {
            template.addTextSegment("/>");
        } else if (completionChar == ' ' && template.getSegmentsCount() == 0) {
            if (WebEditorOptions.getInstance().isAutomaticallyStartAttribute() && (attributes.length > 0 || XmlTagInsertHandler.isTagFromHtml(tag) && !HtmlUtil.isTagWithoutAttributes(tag.getName()))) {
                template.addTextSegment(" ");
                MacroCallNode completeAttrExpr = new MacroCallNode(MacroFactory.createMacro("complete"));
                template.addVariable("attrComplete", completeAttrExpr, completeAttrExpr, true);
                weInsertedSomeCodeThatCouldBeInvalidated = true;
                template.addTextSegment("=\"");
                template.addEndVariable();
                template.addTextSegment("\"");
            }
        } else if ((completionChar == '\u0000' || completionChar == '\n') && WebEditorOptions.getInstance().isAutomaticallyInsertClosingTag() && HtmlUtil.isSingleHtmlTag(tag.getName())) {
            template.addTextSegment(tag instanceof HtmlTag ? ">" : "/>");
        }
        final boolean weInsertedSomeCodeThatCouldBeInvalidated1 = weInsertedSomeCodeThatCouldBeInvalidated;
        templateManager.startTemplate(editor, template, new TemplateEditingAdapter(){

            @Override
            public void templateFinished(Template template, boolean brokenOff) {
                final int offset = editor.getCaretModel().getOffset();
                if (weInsertedSomeCodeThatCouldBeInvalidated1 && offset >= 3 && editor.getDocument().getCharsSequence().charAt(offset - 3) == '/') {
                    new WriteCommandAction.Simple(project, new PsiFile[0]){

                        protected void run() throws Throwable {
                            editor.getDocument().replaceString(offset - 2, offset + 1, (CharSequence)">");
                        }
                    }.execute();
                }
            }

            @Override
            public void templateCancelled(Template template) {
            }
        });
    }

    private static boolean isTagFromHtml(XmlTag tag) {
        String ns = tag.getNamespace();
        return "http://www.w3.org/1999/xhtml".equals(ns) || "http://www.w3.org/1999/html".equals(ns);
    }
}

