/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ShowAutoImportPass
extends TextEditorHighlightingPass {
    private final Editor myEditor;
    private final PsiFile myFile;
    private final int myStartOffset;
    private final int myEndOffset;

    public ShowAutoImportPass(@NotNull Project project, @NotNull PsiFile file, @NotNull Editor editor) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/ShowAutoImportPass.<init> must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/ShowAutoImportPass.<init> must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/ShowAutoImportPass.<init> must not be null");
        }
        super(project, editor.getDocument(), false);
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myEditor = editor;
        TextRange range = ShowAutoImportPass.getVisibleRange(this.myEditor);
        this.myStartOffset = range.getStartOffset();
        this.myEndOffset = range.getEndOffset();
        this.myFile = file;
    }

    public static TextRange getVisibleRange(Editor editor) {
        Rectangle visibleRect = editor.getScrollingModel().getVisibleArea();
        LogicalPosition startPosition = editor.xyToLogicalPosition(new Point(visibleRect.x, visibleRect.y));
        int myStartOffset = editor.logicalPositionToOffset(startPosition);
        LogicalPosition endPosition = editor.xyToLogicalPosition(new Point(visibleRect.x + visibleRect.width, visibleRect.y + visibleRect.height));
        int myEndOffset = editor.logicalPositionToOffset(new LogicalPosition(endPosition.line + 1, 0));
        return new TextRange(myStartOffset, myEndOffset);
    }

    @Override
    public void doCollectInformation(ProgressIndicator progress) {
    }

    @Override
    public void doApplyInformationToEditor() {
        Application application = ApplicationManager.getApplication();
        application.assertIsDispatchThread();
        if (!application.isUnitTestMode() && !this.myEditor.getContentComponent().hasFocus()) {
            return;
        }
        List<HighlightInfo> visibleHighlights = ShowAutoImportPass.getVisibleHighlights(this.myStartOffset, this.myEndOffset, this.myProject, this.myEditor);
        int caretOffset = this.myEditor.getCaretModel().getOffset();
        for (int i = visibleHighlights.size() - 1; i >= 0; --i) {
            HighlightInfo info = visibleHighlights.get(i);
            if (info.startOffset > caretOffset || !this.showAddImportHint(info)) continue;
            return;
        }
        for (HighlightInfo visibleHighlight : visibleHighlights) {
            if (visibleHighlight.startOffset <= caretOffset || !this.showAddImportHint(visibleHighlight)) continue;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static List<HighlightInfo> getVisibleHighlights(int startOffset, int endOffset, Project project, Editor editor) {
        List<HighlightInfo> list;
        List<HighlightInfo> highlights = DaemonCodeAnalyzerImpl.getHighlights(editor.getDocument(), project);
        if (highlights == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/ShowAutoImportPass.getVisibleHighlights must not return null");
            return list;
        }
        ArrayList<HighlightInfo> array = new ArrayList<HighlightInfo>();
        for (HighlightInfo info : highlights) {
            if (!info.hasHint() || startOffset > info.startOffset || info.endOffset > endOffset || editor.getFoldingModel().isOffsetCollapsed(info.startOffset)) continue;
            array.add(info);
        }
        list = array;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/ShowAutoImportPass.getVisibleHighlights must not return null");
    }

    private boolean showAddImportHint(HighlightInfo info) {
        if (!DaemonCodeAnalyzerSettings.getInstance().isImportHintEnabled()) {
            return false;
        }
        if (!DaemonCodeAnalyzer.getInstance((Project)this.myProject).isImportHintsEnabled(this.myFile)) {
            return false;
        }
        PsiElement element = this.myFile.findElementAt(info.startOffset);
        if (element == null || !element.isValid()) {
            return false;
        }
        List<Pair<HighlightInfo.IntentionActionDescriptor, TextRange>> list = info.quickFixActionRanges;
        for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> pair : list) {
            IntentionAction action = ((HighlightInfo.IntentionActionDescriptor)pair.getFirst()).getAction();
            if (!(action instanceof HintAction) || !action.isAvailable(this.myProject, this.myEditor, this.myFile)) continue;
            return ((HintAction)action).showHint(this.myEditor);
        }
        return false;
    }

    public static String getMessage(boolean multiple, String name) {
        String messageKey = multiple ? "import.popup.multiple" : "import.popup.text";
        String hintText = DaemonBundle.message((String)messageKey, (Object[])new Object[]{name});
        hintText = hintText + " " + KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ShowIntentionActions"));
        return hintText;
    }
}

