/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassFromNewFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageBaseFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class CreateConstructorFromCallFix
extends CreateFromUsageBaseFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.CreateConstructorFromCallFix");
    private final PsiConstructorCall myConstructorCall;

    public CreateConstructorFromCallFix(PsiConstructorCall constructorCall) {
        this.myConstructorCall = constructorCall;
    }

    @Override
    protected void invokeImpl(PsiClass targetClass) {
        final Project project = this.myConstructorCall.getProject();
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        try {
            PsiMethod constructor = (PsiMethod)targetClass.add((PsiElement)elementFactory.createConstructor());
            final PsiFile file = targetClass.getContainingFile();
            TemplateBuilderImpl templateBuilder = new TemplateBuilderImpl((PsiElement)constructor);
            CreateFromUsageUtils.setupMethodParameters(constructor, templateBuilder, this.myConstructorCall.getArgumentList(), CreateConstructorFromCallFix.getTargetSubstitutor((PsiElement)this.myConstructorCall));
            CreateClassFromNewFix.setupSuperCall(targetClass, constructor, templateBuilder);
            constructor = CodeInsightUtilBase.forcePsiPostprocessAndRestoreElement(constructor);
            Template template = templateBuilder.buildTemplate();
            targetClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)constructor, PsiClass.class);
            if (targetClass == null) {
                return;
            }
            final Editor editor = CreateConstructorFromCallFix.positionCursor(project, targetClass.getContainingFile(), (PsiElement)targetClass);
            TextRange textRange = constructor.getTextRange();
            editor.getDocument().deleteString(textRange.getStartOffset(), textRange.getEndOffset());
            editor.getCaretModel().moveToOffset(textRange.getStartOffset());
            CreateConstructorFromCallFix.startTemplate(editor, template, project, new TemplateEditingAdapter(){

                @Override
                public void templateFinished(Template template, boolean brokenOff) {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                                int offset = editor.getCaretModel().getOffset();
                                PsiMethod constructor = (PsiMethod)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, PsiMethod.class, (boolean)false);
                                CreateFromUsageUtils.setupMethodBody(constructor);
                                CreateFromUsageUtils.setupEditor(constructor, editor);
                            }
                            catch (IncorrectOperationException e) {
                                LOG.error((Throwable)e);
                            }
                        }
                    });
                }
            });
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static PsiFile getTargetFile(PsiElement element) {
        PsiJavaCodeReferenceElement qualifier;
        PsiElement psiElement;
        PsiConstructorCall constructorCall = (PsiConstructorCall)element;
        if (constructorCall instanceof PsiEnumConstant) {
            return constructorCall.getContainingFile();
        }
        PsiJavaCodeReferenceElement referenceElement = CreateConstructorFromCallFix.getReferenceElement(constructorCall);
        if (referenceElement.getQualifier() instanceof PsiJavaCodeReferenceElement && (psiElement = (qualifier = (PsiJavaCodeReferenceElement)referenceElement.getQualifier()).resolve()) instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)psiElement;
            return psiClass.getContainingFile();
        }
        return null;
    }

    @Override
    protected PsiElement getElement() {
        if (!this.myConstructorCall.isValid() || !this.myConstructorCall.getManager().isInProject((PsiElement)this.myConstructorCall)) {
            return null;
        }
        PsiExpressionList argumentList = this.myConstructorCall.getArgumentList();
        if (argumentList == null) {
            return null;
        }
        if (this.myConstructorCall instanceof PsiEnumConstant) {
            return this.myConstructorCall;
        }
        PsiJavaCodeReferenceElement referenceElement = CreateConstructorFromCallFix.getReferenceElement(this.myConstructorCall);
        if (referenceElement == null) {
            return null;
        }
        if (referenceElement.getReferenceNameElement() instanceof PsiIdentifier) {
            return this.myConstructorCall;
        }
        return null;
    }

    @Override
    protected boolean isValidElement(PsiElement element) {
        PsiConstructorCall constructorCall = (PsiConstructorCall)element;
        PsiMethod method = constructorCall.resolveConstructor();
        PsiExpressionList argumentList = constructorCall.getArgumentList();
        PsiClass targetClass = this.getTargetClasses((PsiElement)constructorCall).get(0);
        return !CreateFromUsageUtils.shouldCreateConstructor(targetClass, argumentList, method);
    }

    @Override
    protected boolean isAvailableImpl(int offset) {
        PsiElement element = CreateConstructorFromCallFix.getElement((PsiElement)this.myConstructorCall);
        PsiFile targetFile = CreateConstructorFromCallFix.getTargetFile((PsiElement)this.myConstructorCall);
        if (targetFile != null && !targetFile.getManager().isInProject((PsiElement)targetFile)) {
            return false;
        }
        if (CreateFromUsageUtils.shouldShowTag(offset, element, (PsiElement)this.myConstructorCall)) {
            this.setText(QuickFixBundle.message("create.constructor.from.new.text", new Object[0]));
            return true;
        }
        return false;
    }

    private static PsiJavaCodeReferenceElement getReferenceElement(PsiConstructorCall constructorCall) {
        if (constructorCall instanceof PsiNewExpression) {
            return ((PsiNewExpression)constructorCall).getClassOrAnonymousClassReference();
        }
        return null;
    }

    private static PsiElement getElement(PsiElement targetElement) {
        if (targetElement instanceof PsiNewExpression) {
            PsiJavaCodeReferenceElement referenceElement = CreateConstructorFromCallFix.getReferenceElement((PsiConstructorCall)((PsiNewExpression)targetElement));
            if (referenceElement == null) {
                return null;
            }
            return referenceElement.getReferenceNameElement();
        }
        if (targetElement instanceof PsiEnumConstant) {
            return targetElement;
        }
        return null;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("create.constructor.from.new.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/CreateConstructorFromCallFix.getFamilyName must not return null");
        }
        return string;
    }
}

