/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypeUtil;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateVarFromUsageFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CreateEnumConstantFromUsageFix
extends CreateVarFromUsageFix {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.codeInsight.daemon.impl.quickfix.CreateEnumConstantFromUsageFix");

    public CreateEnumConstantFromUsageFix(PsiReferenceExpression referenceElement) {
        super(referenceElement);
    }

    @Override
    protected String getText(String varName) {
        return QuickFixBundle.message("create.enum.constant.from.usage.text", this.myReferenceExpression.getReferenceName());
    }

    @Override
    protected void invokeImpl(PsiClass targetClass) {
        LOG.assertTrue(targetClass.isEnum());
        String name = this.myReferenceExpression.getReferenceName();
        LOG.assertTrue(name != null);
        try {
            PsiEnumConstant enumConstant = JavaPsiFacade.getInstance((Project)this.myReferenceExpression.getProject()).getElementFactory().createEnumConstantFromText(name, null);
            targetClass.add((PsiElement)enumConstant);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    protected boolean isAvailableImpl(int offset) {
        if (!super.isAvailableImpl(offset)) {
            return false;
        }
        PsiElement element = this.getElement();
        List<PsiClass> classes = this.getTargetClasses(element);
        if (classes.size() != 1 || !classes.get(0).isEnum()) {
            return false;
        }
        ExpectedTypeInfo[] typeInfos = CreateFromUsageUtils.guessExpectedTypes((PsiExpression)this.myReferenceExpression, false);
        PsiClassType enumType = JavaPsiFacade.getInstance((Project)this.myReferenceExpression.getProject()).getElementFactory().createType(classes.get(0));
        for (ExpectedTypeInfo typeInfo : typeInfos) {
            if (!ExpectedTypeUtil.matches((PsiType)enumType, typeInfo)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("create.constant.from.usage.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/CreateEnumConstantFromUsageFix.getFamilyName must not return null");
        }
        return string;
    }
}

