/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.util.XmlUtil;

public class XmlSlashTypedHandler
extends TypedHandlerDelegate {
    public TypedHandlerDelegate.Result beforeCharTyped(char c, Project project, Editor editor, PsiFile editedFile, FileType fileType) {
        if ((editedFile.getLanguage() instanceof XMLLanguage || editedFile.getViewProvider().getBaseLanguage() instanceof XMLLanguage) && c == '/') {
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            int offset = editor.getCaretModel().getOffset();
            FileViewProvider provider = file.getViewProvider();
            PsiElement element = provider.findElementAt(offset, XMLLanguage.class);
            if (element instanceof XmlToken) {
                ASTNode parentNode;
                ASTNode child;
                IElementType tokenType = ((XmlToken)element).getTokenType();
                if (tokenType == XmlTokenType.XML_EMPTY_ELEMENT_END && offset == element.getTextOffset()) {
                    editor.getCaretModel().moveToOffset(offset + 1);
                    editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                    return TypedHandlerDelegate.Result.STOP;
                }
                if (tokenType == XmlTokenType.XML_TAG_END && offset == element.getTextOffset() && (child = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(parentNode = element.getParent().getNode())) != null && offset + 1 == child.getTextRange().getStartOffset()) {
                    editor.getDocument().replaceString(offset + 1, parentNode.getTextRange().getEndOffset(), (CharSequence)"");
                }
            }
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    public TypedHandlerDelegate.Result charTyped(char c, Project project, Editor editor, PsiFile editedFile) {
        if ((editedFile.getLanguage() instanceof XMLLanguage || editedFile.getViewProvider().getBaseLanguage() instanceof XMLLanguage) && c == '/') {
            PsiElement element2;
            String prevLeafText;
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            FileViewProvider provider = file.getViewProvider();
            int offset = editor.getCaretModel().getOffset();
            PsiElement element = provider.findElementAt(offset - 1, XMLLanguage.class);
            if (element == null) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            if (!(element.getLanguage() instanceof XMLLanguage)) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            ASTNode prevLeaf = element.getNode();
            String string = prevLeafText = prevLeaf != null ? prevLeaf.getText() : null;
            if (prevLeaf != null && !"/".equals(prevLeafText) && !"/".equals(prevLeafText.trim())) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            while ((prevLeaf = TreeUtil.prevLeaf(prevLeaf)) != null && prevLeaf.getElementType() == XmlTokenType.XML_WHITE_SPACE) {
            }
            if (prevLeaf instanceof OuterLanguageElement) {
                element = file.getViewProvider().findElementAt(offset - 1, file.getLanguage());
                prevLeaf = element.getNode();
                while ((prevLeaf = TreeUtil.prevLeaf(prevLeaf)) != null && prevLeaf.getElementType() == XmlTokenType.XML_WHITE_SPACE) {
                }
            }
            if (prevLeaf == null) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)prevLeaf.getPsi(), XmlTag.class);
            if (tag == null && (tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)(element2 = provider.findElementAt(prevLeaf.getStartOffset(), XMLLanguage.class)), XmlTag.class)) == null) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            XmlToken startToken = XmlUtil.getTokenOfType((PsiElement)tag, XmlTokenType.XML_START_TAG_START);
            if (startToken == null || !startToken.getText().equals("<")) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            if (XmlUtil.getTokenOfType((PsiElement)tag, XmlTokenType.XML_TAG_END) != null) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            if (XmlUtil.getTokenOfType((PsiElement)tag, XmlTokenType.XML_EMPTY_ELEMENT_END) != null) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttributeValue.class) != null) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)">");
            return TypedHandlerDelegate.Result.STOP;
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }
}

