/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.codeInsight.folding.impl.FoldingPolicy;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class ExpandAllRegionsHandler
implements CodeInsightActionHandler {
    public void invoke(@NotNull Project project, final @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/folding/impl/ExpandAllRegionsHandler.invoke must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/folding/impl/ExpandAllRegionsHandler.invoke must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/folding/impl/ExpandAllRegionsHandler.invoke must not be null");
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        CodeFoldingManager foldingManager = CodeFoldingManager.getInstance(project);
        foldingManager.updateFoldRegions(editor);
        final FoldRegion[] regions = editor.getFoldingModel().getAllFoldRegions();
        Runnable processor = new Runnable(){

            @Override
            public void run() {
                boolean anythingDone = false;
                for (FoldRegion region : regions) {
                    PsiElement element = EditorFoldingInfo.get(editor).getPsiElement(region);
                    if (region.isExpanded() || element != null && FoldingPolicy.isCollapseByDefault(element)) continue;
                    region.setExpanded(true);
                    anythingDone = true;
                }
                if (!anythingDone) {
                    for (FoldRegion region : regions) {
                        region.setExpanded(true);
                    }
                }
            }
        };
        editor.getFoldingModel().runBatchFoldingOperation(processor);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

