/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.ParameterInfoComponent;
import com.intellij.codeInsight.hint.ShowParameterInfoContext;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.lang.Language;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.LanguageParameterInfo;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LightweightHint;
import gnu.trove.THashSet;
import java.awt.Point;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowParameterInfoHandler
implements CodeInsightActionHandler {
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/hint/ShowParameterInfoHandler.invoke must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/hint/ShowParameterInfoHandler.invoke must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/hint/ShowParameterInfoHandler.invoke must not be null");
        }
        this.invoke(project, editor, file, -1, null);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(Project project, Editor editor, PsiFile file, int lbraceOffset, PsiElement highlightedElement) {
        Lookup lookup;
        ApplicationManager.getApplication().assertIsDispatchThread();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        int offset = editor.getCaretModel().getOffset();
        PsiElement psiElement = file.findElementAt(offset);
        if (psiElement == null) {
            return;
        }
        ShowParameterInfoContext context = new ShowParameterInfoContext(editor, project, file, offset, lbraceOffset);
        context.setHighlightedElement(highlightedElement);
        Language language = psiElement.getLanguage();
        ParameterInfoHandler[] handlers = ShowParameterInfoHandler.getHandlers(language, file.getViewProvider().getBaseLanguage());
        if (handlers == null) {
            handlers = new ParameterInfoHandler[]{};
        }
        if ((lookup = LookupManager.getInstance(project).getActiveLookup()) != null) {
            LookupElement item = lookup.getCurrentItem();
            if (item != null) {
                for (ParameterInfoHandler handler : handlers) {
                    if (!handler.couldShowInLookup()) continue;
                    Object[] items = handler.getParametersForLookup(item, (ParameterInfoContext)context);
                    if (items != null && items.length > 0) {
                        ShowParameterInfoHandler.showLookupEditorHint(items, editor, project, handler);
                    }
                    return;
                }
            }
            return;
        }
        for (ParameterInfoHandler handler : handlers) {
            Object element = handler.findElementForParameterInfo((CreateParameterInfoContext)context);
            if (element == null) continue;
            handler.showParameterInfo(element, (CreateParameterInfoContext)context);
        }
    }

    private static void showLookupEditorHint(Object[] descriptors, final Editor editor, Project project, ParameterInfoHandler handler) {
        ParameterInfoComponent component = new ParameterInfoComponent(descriptors, editor, handler);
        component.update();
        final LightweightHint hint = new LightweightHint(component);
        hint.setSelectingHint(true);
        final HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
        final Point p = ShowParameterInfoContext.chooseBestHintPosition(project, editor, -1, -1, hint);
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!editor.getComponent().isShowing()) {
                    return;
                }
                hintManager.showEditorHint(hint, editor, p, 134, 0, false);
            }
        });
    }

    @Nullable
    public static ParameterInfoHandler[] getHandlers(Language ... languages) {
        THashSet handlers = new THashSet();
        for (Language language : languages) {
            handlers.addAll(LanguageParameterInfo.INSTANCE.allForLanguage(language));
        }
        if (handlers.isEmpty()) {
            return null;
        }
        return handlers.toArray(new ParameterInfoHandler[handlers.size()]);
    }

    static interface BestLocationPointProvider {
        @NotNull
        public Point getBestPointPosition(LightweightHint var1, PsiElement var2, int var3);
    }
}

