/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.codeInsight.hint.TooltipRenderer;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public class TooltipController {
    private LightweightHint myCurrentTooltip;
    private TooltipRenderer myCurrentTooltipObject;
    private TooltipGroup myCurrentTooltipGroup;
    private final Alarm myTooltipAlarm = new Alarm();

    public static TooltipController getInstance() {
        return (TooltipController)ServiceManager.getService(TooltipController.class);
    }

    public void cancelTooltips() {
        this.myTooltipAlarm.cancelAllRequests();
        this.hideCurrentTooltip();
    }

    public void cancelTooltip(TooltipGroup groupId) {
        if (groupId.equals(this.myCurrentTooltipGroup)) {
            this.cancelTooltips();
        }
    }

    public void showTooltipByMouseMove(final Editor editor, MouseEvent e, final TooltipRenderer tooltipObject, final boolean alignToRight, final TooltipGroup group) {
        this.myTooltipAlarm.cancelAllRequests();
        if (this.myCurrentTooltip == null || !this.myCurrentTooltip.isVisible()) {
            this.myCurrentTooltipObject = null;
        }
        if (Comparing.equal((Object)tooltipObject, (Object)this.myCurrentTooltipObject)) {
            return;
        }
        this.hideCurrentTooltip();
        if (tooltipObject != null) {
            final Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), editor.getComponent().getRootPane().getLayeredPane());
            p.x = p.x + (alignToRight ? -10 : 10);
            this.myTooltipAlarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    Project project = editor.getProject();
                    if (project != null && !project.isOpen()) {
                        return;
                    }
                    if (editor.getContentComponent().isShowing()) {
                        TooltipController.this.showTooltip(editor, p, tooltipObject, alignToRight, group);
                    }
                }
            }, 50);
        }
    }

    private void hideCurrentTooltip() {
        if (this.myCurrentTooltip != null) {
            this.myCurrentTooltip.hide();
            this.myCurrentTooltip = null;
            this.myCurrentTooltipGroup = null;
        }
    }

    public void showTooltip(Editor editor, Point p, String text, boolean alignToRight, TooltipGroup group) {
        this.showTooltip(editor, p, ((EditorMarkupModel)editor.getMarkupModel()).getErrorStripTooltipRendererProvider().calcTooltipRenderer(text), alignToRight, group);
    }

    public void showTooltip(Editor editor, Point p, String text, int currentWidth, boolean alignToRight, TooltipGroup group) {
        this.showTooltip(editor, p, ((EditorMarkupModel)editor.getMarkupModel()).getErrorStripTooltipRendererProvider().calcTooltipRenderer(text, currentWidth), alignToRight, group);
    }

    public void showTooltip(Editor editor, Point p, TooltipRenderer tooltipRenderer, boolean alignToRight, TooltipGroup group) {
        this.myTooltipAlarm.cancelAllRequests();
        if (this.myCurrentTooltip == null || !this.myCurrentTooltip.isVisible()) {
            this.myCurrentTooltipObject = null;
        }
        if (Comparing.equal((Object)tooltipRenderer, (Object)this.myCurrentTooltipObject)) {
            return;
        }
        if (this.myCurrentTooltipGroup != null && group.compareTo(this.myCurrentTooltipGroup) < 0) {
            return;
        }
        p = new Point(p);
        this.hideCurrentTooltip();
        LightweightHint hint = tooltipRenderer.show(editor, p, alignToRight, group);
        this.myCurrentTooltipGroup = group;
        this.myCurrentTooltip = hint;
        this.myCurrentTooltipObject = tooltipRenderer;
    }

    public boolean shouldSurvive(MouseEvent e) {
        if (this.myCurrentTooltip != null) {
            Point pointOnComponent = new RelativePoint(e).getPointOn((Component)this.myCurrentTooltip.getComponent()).getPoint();
            Rectangle bounds = this.myCurrentTooltip.getBounds();
            if (bounds.x - 10 < pointOnComponent.x && bounds.width + bounds.x + 10 > pointOnComponent.x && bounds.y - 10 < pointOnComponent.y && bounds.y + bounds.height + 10 > pointOnComponent.y) {
                return true;
            }
        }
        return false;
    }
}

