/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SplitDeclarationAction
extends PsiElementBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.split.declaration.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/SplitDeclarationAction.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @Nullable PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/SplitDeclarationAction.isAvailable must not be null");
        }
        if (element == null) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        if (!(element instanceof PsiJavaToken)) {
            return false;
        }
        if (element instanceof PsiCompiledElement) {
            return false;
        }
        if (!element.getManager().isInProject(element)) {
            return false;
        }
        PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiDeclarationStatement.class, PsiClass.class});
        if (context instanceof PsiDeclarationStatement) {
            return this.isAvaliableOnDeclarationStatement((PsiDeclarationStatement)context, element);
        }
        PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class);
        if (field != null && PsiTreeUtil.getParentOfType((PsiElement)element, PsiDocComment.class) == null && SplitDeclarationAction.isAvaliableOnField(field)) {
            this.setText(CodeInsightBundle.message((String)"intention.split.declaration.text", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private static boolean isAvaliableOnField(PsiField field) {
        PsiElement nextField;
        PsiTypeElement typeElement = field.getTypeElement();
        if (typeElement == null) {
            return false;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)typeElement, PsiField.class) != field) {
            return true;
        }
        for (nextField = field.getNextSibling(); nextField != null && !(nextField instanceof PsiField); nextField = nextField.getNextSibling()) {
        }
        return nextField != null && ((PsiField)nextField).getTypeElement() == typeElement;
    }

    private boolean isAvaliableOnDeclarationStatement(PsiDeclarationStatement decl, PsiElement element) {
        PsiElement[] declaredElements = decl.getDeclaredElements();
        if (declaredElements.length == 1) {
            if (!(declaredElements[0] instanceof PsiLocalVariable)) {
                return false;
            }
            PsiLocalVariable var = (PsiLocalVariable)declaredElements[0];
            if (var.getInitializer() == null) {
                return false;
            }
            PsiTypeElement type = var.getTypeElement();
            if (PsiTreeUtil.isAncestor((PsiElement)type, (PsiElement)element, (boolean)false) || element.getParent() == var && ((PsiJavaToken)element).getTokenType() != JavaTokenType.SEMICOLON) {
                this.setText(CodeInsightBundle.message((String)"intention.split.declaration.assignment.text", (Object[])new Object[0]));
                return true;
            }
        } else if (declaredElements.length > 1) {
            if (decl.getParent() instanceof PsiForStatement) {
                return false;
            }
            for (PsiElement declaredElement : declaredElements) {
                if (!(declaredElement instanceof PsiLocalVariable)) {
                    return false;
                }
                PsiLocalVariable var = (PsiLocalVariable)declaredElement;
                PsiTypeElement type = var.getTypeElement();
                if (!PsiTreeUtil.isAncestor((PsiElement)type, (PsiElement)element, (boolean)false) && element != var.getNameIdentifier()) continue;
                this.setText(CodeInsightBundle.message((String)"intention.split.declaration.text", (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/SplitDeclarationAction.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(file)) {
            return;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        int offset = editor.getCaretModel().getOffset();
        PsiElement token = file.findElementAt(offset);
        PsiDeclarationStatement decl = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)token, PsiDeclarationStatement.class);
        if (decl != null) {
            SplitDeclarationAction.invokeOnDeclarationStatement(decl, psiManager, project);
        } else {
            PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)token, PsiField.class);
            if (field != null) {
                field.normalizeDeclaration();
            }
        }
    }

    private static void invokeOnDeclarationStatement(PsiDeclarationStatement decl, PsiManager psiManager, Project project) throws IncorrectOperationException {
        if (decl.getDeclaredElements().length == 1) {
            PsiLocalVariable var = (PsiLocalVariable)decl.getDeclaredElements()[0];
            var.normalizeDeclaration();
            PsiExpressionStatement statement = (PsiExpressionStatement)JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory().createStatementFromText(var.getName() + "=xxx;", null);
            statement = (PsiExpressionStatement)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)statement);
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)statement.getExpression();
            PsiExpression initializer = var.getInitializer();
            PsiExpression rExpression = initializer instanceof PsiArrayInitializerExpression ? JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory().createExpressionFromText("new " + var.getTypeElement().getText() + " " + initializer.getText(), null) : initializer;
            assignment.getRExpression().replace((PsiElement)rExpression);
            initializer.delete();
            PsiElement block = decl.getParent();
            if (block instanceof PsiForStatement) {
                PsiDeclarationStatement varDeclStatement = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory().createVariableDeclarationStatement(var.getName(), var.getType(), null);
                for (PsiElement varDecl : varDeclStatement.getDeclaredElements()) {
                    if (!(varDecl instanceof PsiModifierListOwner)) continue;
                    PsiModifierList modList = ((PsiModifierListOwner)varDecl).getModifierList();
                    assert (modList != null);
                    modList.setModifierProperty("final", false);
                }
                block.getParent().addBefore((PsiElement)varDeclStatement, block);
                decl.replace((PsiElement)statement);
            } else {
                block.addAfter((PsiElement)statement, (PsiElement)decl);
            }
        } else {
            ((PsiLocalVariable)decl.getDeclaredElements()[0]).normalizeDeclaration();
        }
    }
}

