/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.completion.simple.SimpleLookupItem;
import com.intellij.codeInsight.lookup.LookupElementFactory;
import com.intellij.codeInsight.lookup.MutableLookupElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.meta.PsiPresentableMetaData;
import org.jetbrains.annotations.NotNull;

public class LookupElementFactoryImpl
extends LookupElementFactory {
    @NotNull
    public static LookupElementFactoryImpl getInstance() {
        LookupElementFactoryImpl lookupElementFactoryImpl = (LookupElementFactoryImpl)LookupElementFactory.getInstance();
        if (lookupElementFactoryImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/lookup/LookupElementFactoryImpl.getInstance must not return null");
        }
        return lookupElementFactoryImpl;
    }

    public SimpleLookupItem<String> createLookupElement(@NotNull String lookupString) {
        if (lookupString == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/lookup/LookupElementFactoryImpl.createLookupElement must not be null");
        }
        return new SimpleLookupItem<String>(lookupString, lookupString);
    }

    public <T extends PsiNamedElement> SimpleLookupItem<T> createLookupElement(@NotNull T element) {
        PsiMetaData metaData;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/lookup/LookupElementFactoryImpl.createLookupElement must not be null");
        }
        MutableLookupElement lookupItem = this.createLookupElement((Object)element, StringUtil.notNullize((String)element.getName()));
        if (element instanceof PsiMetaOwner && (metaData = ((PsiMetaOwner)element).getMetaData()) instanceof PsiPresentableMetaData) {
            PsiPresentableMetaData presentableMetaData = (PsiPresentableMetaData)metaData;
            lookupItem.setIcon(presentableMetaData.getIcon());
            String name = presentableMetaData.getName();
            if (StringUtil.isNotEmpty((String)name)) {
                lookupItem.setPresentableText(name);
            }
        }
        return lookupItem;
    }

    public <T> SimpleLookupItem<T> createLookupElement(@NotNull T element, @NotNull String lookupString) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/lookup/LookupElementFactoryImpl.createLookupElement must not be null");
        }
        if (lookupString == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/lookup/LookupElementFactoryImpl.createLookupElement must not be null");
        }
        return new SimpleLookupItem<T>(element, lookupString);
    }
}

