/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.navigation.MethodNavigationOffsetProvider;
import com.intellij.codeInsight.navigation.MethodUpDownUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;

public class XmlMethodNavigationOffsetProvider
implements MethodNavigationOffsetProvider {
    public int[] getMethodNavigationOffsets(PsiFile file, int caretOffset) {
        if (file instanceof XmlFile) {
            PsiFile element = file;
            PsiElement elementAt = file.findElementAt(caretOffset);
            if ((elementAt = PsiTreeUtil.getParentOfType((PsiElement)elementAt, XmlTag.class)) != null) {
                element = elementAt;
            }
            ArrayList<PsiElement> array = new ArrayList<PsiElement>();
            XmlMethodNavigationOffsetProvider.addNavigationElements(array, (PsiElement)element);
            return MethodUpDownUtil.offsetsFromElements(array);
        }
        return null;
    }

    private static void addNavigationElements(ArrayList<PsiElement> array, PsiElement element) {
        PsiElement parentElement;
        PsiElement parent;
        PsiElement psiElement = parent = element instanceof XmlFile ? element : element.getParent();
        if (parent != null) {
            PsiElement[] children;
            for (PsiElement child : children = parent.getChildren()) {
                if (!(child instanceof XmlTag)) continue;
                array.add(child);
            }
        }
        if ((parentElement = element.getParent()) != null) {
            XmlMethodNavigationOffsetProvider.addNavigationElements(array, parentElement);
        }
    }
}

