/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template;

import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.Variable;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LiveTemplateBuilder {
    private final StringBuilder myText = new StringBuilder();
    private final List<Variable> myVariables = new ArrayList<Variable>();
    private final Set<String> myVarNames = new HashSet();
    private final List<VarOccurence> myVariableOccurences = new ArrayList<VarOccurence>();
    private final List<Marker> myMarkers = new ArrayList<Marker>();
    private final Map<String, String> myPredefinedValues = new HashMap();

    public CharSequence getText() {
        return this.myText;
    }

    public void insertVariableSegment(int offset, String name) {
        this.myVariableOccurences.add(new VarOccurence(name, offset));
    }

    public TemplateImpl buildTemplate() {
        TemplateImpl template = new TemplateImpl("", "");
        for (Variable variable : this.myVariables) {
            template.addVariable(variable.getName(), variable.getExpressionString(), variable.getDefaultValueString(), variable.isAlwaysStopAt());
        }
        Collections.sort(this.myVariableOccurences, new Comparator<VarOccurence>(){

            @Override
            public int compare(VarOccurence o1, VarOccurence o2) {
                if (o1.myOffset < o2.myOffset) {
                    return -1;
                }
                if (o1.myOffset > o2.myOffset) {
                    return 1;
                }
                return 0;
            }
        });
        int last = 0;
        for (VarOccurence occurence : this.myVariableOccurences) {
            template.addTextSegment(this.myText.substring(last, occurence.myOffset));
            template.addVariableSegment(occurence.myName);
            last = occurence.myOffset;
        }
        template.addTextSegment(this.myText.substring(last));
        return template;
    }

    public Map<String, String> getPredefinedValues() {
        return this.myPredefinedValues;
    }

    public void insertText(int offset, String text) {
        int delta = text.length();
        for (VarOccurence occurence : this.myVariableOccurences) {
            if (occurence.myOffset < offset) continue;
            occurence.myOffset += delta;
        }
        this.myText.insert(offset, text);
        this.updateMarkers(offset, text);
    }

    private void updateMarkers(int offset, String text) {
        for (Marker marker : this.myMarkers) {
            if (offset < marker.getStartOffset()) {
                marker.myStartOffset += text.length();
                continue;
            }
            if (offset > marker.getEndOffset()) continue;
            marker.myEndOffset += text.length();
        }
    }

    private String generateUniqueVarName(Set<String> existingNames) {
        String prefix = "VAR";
        int i = 0;
        while (this.myVarNames.contains(prefix + i) || existingNames.contains(prefix + i)) {
            ++i;
        }
        return prefix + i;
    }

    public int insertTemplate(int offset, TemplateImpl template, Map<String, String> predefinedVarValues) {
        String varName;
        int i;
        String text = template.getTemplateText();
        this.insertText(offset, text);
        HashMap newVarNames = new HashMap();
        HashSet oldVarNames = new HashSet();
        for (i = 0; i < template.getVariableCount(); ++i) {
            varName = template.getVariableNameAt(i);
            oldVarNames.add(varName);
        }
        for (i = 0; i < template.getVariableCount(); ++i) {
            String newVarName;
            varName = template.getVariableNameAt(i);
            if (TemplateImpl.INTERNAL_VARS_SET.contains(varName)) continue;
            if (this.myVarNames.contains(varName)) {
                oldVarNames.remove(varName);
                newVarName = this.generateUniqueVarName((Set<String>)oldVarNames);
                newVarNames.put(varName, newVarName);
            } else {
                newVarName = varName;
            }
            if (predefinedVarValues != null && predefinedVarValues.containsKey(varName)) {
                this.myPredefinedValues.put(newVarName, predefinedVarValues.get(varName));
            }
            Variable var = new Variable(newVarName, template.getExpressionStringAt(i), template.getDefaultValueStringAt(i), template.isAlwaysStopAt(i));
            this.myVariables.add(var);
            this.myVarNames.add(newVarName);
        }
        int end = -1;
        for (int i2 = 0; i2 < template.getSegmentsCount(); ++i2) {
            String segmentName = template.getSegmentName(i2);
            int localOffset = template.getSegmentOffset(i2);
            if (!TemplateImpl.INTERNAL_VARS_SET.contains(segmentName)) {
                if (newVarNames.containsKey(segmentName)) {
                    segmentName = (String)newVarNames.get(segmentName);
                }
                this.myVariableOccurences.add(new VarOccurence(segmentName, offset + localOffset));
                continue;
            }
            if (!"END".equals(segmentName)) continue;
            end = offset + localOffset;
        }
        return end >= 0 ? end : offset + text.length();
    }

    Marker createMarker(int offset) {
        Marker marker = new Marker(offset, offset);
        this.myMarkers.add(marker);
        return marker;
    }

    static class Marker {
        int myStartOffset;
        int myEndOffset;

        private Marker(int startOffset, int endOffset) {
            this.myStartOffset = startOffset;
            this.myEndOffset = endOffset;
        }

        public int getStartOffset() {
            return this.myStartOffset;
        }

        public int getEndOffset() {
            return this.myEndOffset;
        }
    }

    private static class VarOccurence {
        String myName;
        int myOffset;

        private VarOccurence(String name, int offset) {
            this.myName = name;
            this.myOffset = offset;
        }
    }
}

