/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class AddAssertStatementFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.AddAssertStatementFix");
    private final PsiExpression myExpressionToAssert;

    @NotNull
    public String getName() {
        String string = InspectionsBundle.message((String)"inspection.assert.quickfix", (Object[])new Object[]{this.myExpressionToAssert.getText()});
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/AddAssertStatementFix.getName must not return null");
        }
        return string;
    }

    public AddAssertStatementFix(PsiExpression expressionToAssert) {
        this.myExpressionToAssert = expressionToAssert;
        LOG.assertTrue(PsiType.BOOLEAN.equals(this.myExpressionToAssert.getType()));
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/AddAssertStatementFix.applyFix must not be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/AddAssertStatementFix.applyFix must not be null");
        }
        if (ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(new VirtualFile[]{PsiUtilBase.getVirtualFile((PsiElement)descriptor.getPsiElement())}).hasReadonlyFiles()) {
            return;
        }
        PsiElement element = descriptor.getPsiElement();
        PsiElement anchorElement = PsiTreeUtil.getParentOfType((PsiElement)element, PsiStatement.class);
        LOG.assertTrue(anchorElement != null);
        PsiElement prev = PsiTreeUtil.skipSiblingsBackward((PsiElement)anchorElement, (Class[])new Class[]{PsiWhiteSpace.class});
        if (prev instanceof PsiComment && SuppressManager.getInstance().getSuppressedInspectionIdsIn(prev) != null) {
            anchorElement = prev;
        }
        try {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)element.getProject()).getElementFactory();
            String text = "assert c;";
            PsiAssertStatement assertStatement = (PsiAssertStatement)factory.createStatementFromText(text, null);
            PsiExpression assertCondition = assertStatement.getAssertCondition();
            assert (assertCondition != null);
            assertCondition.replace((PsiElement)this.myExpressionToAssert);
            PsiElement parent = anchorElement.getParent();
            if (parent instanceof PsiCodeBlock) {
                parent.addBefore((PsiElement)assertStatement, anchorElement);
            } else {
                PsiBlockStatement blockStatement = (PsiBlockStatement)factory.createStatementFromText("{}", null);
                PsiCodeBlock block = blockStatement.getCodeBlock();
                block.add((PsiElement)assertStatement);
                block.add(anchorElement);
                anchorElement.replace((PsiElement)blockStatement);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionsBundle.message((String)"inspection.quickfix.assert.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/AddAssertStatementFix.getFamilyName must not return null");
        }
        return string;
    }
}

