/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;

public class GlobalInspectionUtil {
    private static final String LOC_MARKER = " #loc";

    static RefElement retrieveRefElement(PsiElement element, GlobalInspectionContext globalContext) {
        PsiElement context;
        PsiFile elementFile = element.getContainingFile();
        RefElement refElement = globalContext.getRefManager().getReference((PsiElement)elementFile);
        if (refElement == null && (context = elementFile.getContext()) != null) {
            refElement = globalContext.getRefManager().getReference((PsiElement)context.getContainingFile());
        }
        return refElement;
    }

    public static String createInspectionMessage(String message) {
        return message + LOC_MARKER;
    }

    public static void createProblem(PsiElement elt, String message, ProblemHighlightType problemHighlightType, TextRange range, InspectionManager manager, ProblemDescriptionsProcessor problemDescriptionsProcessor, GlobalInspectionContext globalContext) {
        ProblemDescriptor descriptor = manager.createProblemDescriptor(elt, range, GlobalInspectionUtil.createInspectionMessage(message), problemHighlightType, false, new LocalQuickFix[0]);
        problemDescriptionsProcessor.addProblemElement((RefEntity)GlobalInspectionUtil.retrieveRefElement(elt, globalContext), new CommonProblemDescriptor[]{descriptor});
    }

    public static void createProblem(PsiElement elt, String message, ProblemHighlightType problemHighlightType, TextRange range, InspectionManager manager, ProblemDescriptionsProcessor problemDescriptionsProcessor, GlobalInspectionContext globalContext, LocalQuickFix fix) {
        ProblemDescriptor descriptor = manager.createProblemDescriptor(elt, range, GlobalInspectionUtil.createInspectionMessage(message), problemHighlightType, false, new LocalQuickFix[]{fix});
        problemDescriptionsProcessor.addProblemElement((RefEntity)GlobalInspectionUtil.retrieveRefElement(elt, globalContext), new CommonProblemDescriptor[]{descriptor});
    }
}

