/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.util.PackageUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesProcessor;
import com.intellij.refactoring.move.moveClassesOrPackages.SingleSourceRootMoveDestination;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class MoveToPackageFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.MoveToPackageFix");
    private final PsiFile myFile;
    private final PsiPackage myTargetPackage;

    public MoveToPackageFix(PsiFile file, PsiPackage targetPackage) {
        this.myFile = file;
        this.myTargetPackage = targetPackage;
    }

    @NotNull
    public String getName() {
        String string = QuickFixBundle.message("move.class.to.package.text", this.myTargetPackage.getQualifiedName());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/MoveToPackageFix.getName must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("move.class.to.package.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/MoveToPackageFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable() {
        return this.myFile != null && this.myFile.isValid() && this.myFile.getManager().isInProject((PsiElement)this.myFile) && this.myFile instanceof PsiJavaFile && ((PsiJavaFile)this.myFile).getClasses().length != 0 && this.myTargetPackage != null && this.myTargetPackage.isValid();
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/MoveToPackageFix.applyFix must not be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/MoveToPackageFix.applyFix must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(this.myFile)) {
            return;
        }
        try {
            String packageName = this.myTargetPackage.getQualifiedName();
            PsiDirectory directory = PackageUtil.findOrCreateDirectoryForPackage(project, packageName, null, true);
            if (directory == null) {
                return;
            }
            String error = RefactoringMessageUtil.checkCanCreateFile(directory, this.myFile.getName());
            if (error != null) {
                Messages.showMessageDialog((Project)project, (String)error, (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                return;
            }
            new MoveClassesOrPackagesProcessor(project, new PsiElement[]{((PsiJavaFile)this.myFile).getClasses()[0]}, new SingleSourceRootMoveDestination(PackageWrapper.create((PsiPackage)JavaDirectoryService.getInstance().getPackage(directory)), directory), false, false, null).run();
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }
}

