/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class DfaNotNullValue
extends DfaValue {
    private PsiType myType;

    private DfaNotNullValue(PsiType myType, DfaValueFactory factory) {
        super(factory);
        this.myType = myType;
    }

    private DfaNotNullValue(DfaValueFactory factory) {
        super(factory);
    }

    public String toString() {
        return "@notnull " + this.myType.getCanonicalText();
    }

    public PsiType getType() {
        return this.myType;
    }

    private boolean hardEquals(DfaNotNullValue aNotNull) {
        return aNotNull.myType == this.myType;
    }

    public static class Factory {
        private final DfaNotNullValue mySharedInstance;
        private final HashMap<String, ArrayList<DfaNotNullValue>> myStringToObject;
        private final DfaValueFactory myFactory;

        Factory(DfaValueFactory factory) {
            this.myFactory = factory;
            this.mySharedInstance = new DfaNotNullValue(factory);
            this.myStringToObject = new HashMap();
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public DfaValue create(PsiType type) {
            DfaValue dfaValue;
            if (type == null) {
                dfaValue = DfaUnknownValue.getInstance();
                if (dfaValue == null) throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/value/DfaNotNullValue$Factory.create must not return null");
                return dfaValue;
            }
            this.mySharedInstance.myType = type;
            String id = this.mySharedInstance.toString();
            ArrayList<DfaNotNullValue> conditions = (ArrayList<DfaNotNullValue>)this.myStringToObject.get((Object)id);
            if (conditions == null) {
                conditions = new ArrayList<DfaNotNullValue>();
                this.myStringToObject.put((Object)id, conditions);
            } else {
                for (DfaNotNullValue value : conditions) {
                    if (!value.hardEquals(this.mySharedInstance)) continue;
                    dfaValue = value;
                    if (dfaValue == null) throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/value/DfaNotNullValue$Factory.create must not return null");
                    return dfaValue;
                }
            }
            DfaNotNullValue result = new DfaNotNullValue(type, this.myFactory);
            conditions.add(result);
            dfaValue = result;
            if (dfaValue != null) return dfaValue;
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/value/DfaNotNullValue$Factory.create must not return null");
        }
    }
}

