/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.defUse;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedVariableFix;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.BaseLocalInspectionTool;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DefUseInspection
extends BaseLocalInspectionTool {
    public boolean REPORT_PREFIX_EXPRESSIONS = false;
    public boolean REPORT_POSTFIX_EXPRESSIONS = true;
    public boolean REPORT_REDUNDANT_INITIALIZER = true;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.defUse.DefUseInspection");
    public static final String DISPLAY_NAME = InspectionsBundle.message((String)"inspection.unused.assignment.display.name", (Object[])new Object[0]);
    @NonNls
    public static final String SHORT_NAME = "UnusedAssignment";

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/defUse/DefUseInspection.buildVisitor must not be null");
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
            }

            public void visitMethod(PsiMethod method) {
                DefUseInspection.this.checkCodeBlock(method.getBody(), holder, isOnTheFly);
            }

            public void visitClassInitializer(PsiClassInitializer initializer) {
                DefUseInspection.this.checkCodeBlock(initializer.getBody(), holder, isOnTheFly);
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/defUse/DefUseInspection.buildVisitor must not return null");
        }
        return javaElementVisitor;
    }

    private void checkCodeBlock(PsiCodeBlock body, ProblemsHolder holder, boolean isOnTheFly) {
        if (body == null) {
            return;
        }
        THashSet usedVariables = new THashSet();
        List<DefUseUtil.Info> unusedDefs = DefUseUtil.getUnusedDefs(body, (Set<PsiVariable>)usedVariables);
        if (unusedDefs != null && !unusedDefs.isEmpty()) {
            Collections.sort(unusedDefs, new Comparator<DefUseUtil.Info>(){

                @Override
                public int compare(DefUseUtil.Info o1, DefUseUtil.Info o2) {
                    int offset2;
                    int offset1 = o1.getContext().getTextOffset();
                    if (offset1 == (offset2 = o2.getContext().getTextOffset())) {
                        return 0;
                    }
                    if (offset1 < offset2) {
                        return -1;
                    }
                    return 1;
                }
            });
            for (DefUseUtil.Info info : unusedDefs) {
                PsiElement context = info.getContext();
                PsiVariable psiVariable = info.getVariable();
                if (context instanceof PsiDeclarationStatement) {
                    if (!info.isRead()) {
                        if (isOnTheFly) continue;
                        holder.registerProblem((PsiElement)psiVariable.getNameIdentifier(), InspectionsBundle.message((String)"inspection.unused.assignment.problem.descriptor1", (Object[])new Object[]{"<code>#ref</code> #loc"}), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[0]);
                        continue;
                    }
                    if (!this.REPORT_REDUNDANT_INITIALIZER) continue;
                    holder.registerProblem((PsiElement)psiVariable.getInitializer(), InspectionsBundle.message((String)"inspection.unused.assignment.problem.descriptor2", (Object[])new Object[]{"<code>" + psiVariable.getName() + "</code>", "<code>#ref</code> #loc"}), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new RemoveInitializerFix()});
                    continue;
                }
                if (context instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)context).getOperationSign().getTokenType() == JavaTokenType.EQ) {
                    PsiAssignmentExpression assignment = (PsiAssignmentExpression)context;
                    holder.registerProblem((PsiElement)assignment.getRExpression(), InspectionsBundle.message((String)"inspection.unused.assignment.problem.descriptor3", (Object[])new Object[]{"<code>#ref</code>", assignment.getLExpression().getText() + " #loc"}), new LocalQuickFix[0]);
                    continue;
                }
                if ((!(context instanceof PsiPrefixExpression) || !this.REPORT_PREFIX_EXPRESSIONS) && (!(context instanceof PsiPostfixExpression) || !this.REPORT_POSTFIX_EXPRESSIONS)) continue;
                holder.registerProblem(context, InspectionsBundle.message((String)"inspection.unused.assignment.problem.descriptor4", (Object[])new Object[]{"<code>#ref</code> #loc"}), new LocalQuickFix[0]);
            }
        }
        body.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor((Set)usedVariables, isOnTheFly, holder){
            final /* synthetic */ Set val$usedVariables;
            final /* synthetic */ boolean val$isOnTheFly;
            final /* synthetic */ ProblemsHolder val$holder;
            {
                this.val$usedVariables = set;
                this.val$isOnTheFly = bl;
                this.val$holder = problemsHolder;
            }

            public void visitClass(PsiClass aClass) {
            }

            public void visitLocalVariable(PsiLocalVariable variable) {
                if (!this.val$usedVariables.contains(variable) && variable.getInitializer() == null && !this.val$isOnTheFly) {
                    this.val$holder.registerProblem((PsiElement)variable.getNameIdentifier(), InspectionsBundle.message((String)"inspection.unused.assignment.problem.descriptor5", (Object[])new Object[]{"<code>#ref</code> #loc"}), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[0]);
                }
            }

            public void visitAssignmentExpression(PsiAssignmentExpression expression) {
                PsiExpression lExpression = expression.getLExpression();
                PsiExpression rExpression = expression.getRExpression();
                if (lExpression instanceof PsiReferenceExpression && rExpression instanceof PsiReferenceExpression) {
                    PsiReferenceExpression lRef = (PsiReferenceExpression)lExpression;
                    PsiReferenceExpression rRef = (PsiReferenceExpression)rExpression;
                    if (lRef.resolve() != rRef.resolve()) {
                        return;
                    }
                    PsiExpression lQualifier = lRef.getQualifierExpression();
                    PsiExpression rQualifier = rRef.getQualifierExpression();
                    if ((lQualifier == null && rQualifier == null || lQualifier instanceof PsiThisExpression && rQualifier instanceof PsiThisExpression || lQualifier instanceof PsiThisExpression && rQualifier == null || lQualifier == null && rQualifier instanceof PsiThisExpression) && !this.val$isOnTheFly) {
                        this.val$holder.registerProblem((PsiElement)expression, InspectionsBundle.message((String)"inspection.unused.assignment.problem.descriptor6", (Object[])new Object[]{"<code>#ref</code>"}), new LocalQuickFix[0]);
                    }
                }
            }
        });
    }

    public JComponent createOptionsPanel() {
        return new OptionsPanel();
    }

    @NotNull
    public String getDisplayName() {
        String string = DISPLAY_NAME;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/defUse/DefUseInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.BUGS_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/defUse/DefUseInspection.getGroupDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/defUse/DefUseInspection.getShortName must not return null");
        }
        return SHORT_NAME;
    }

    private static class RemoveInitializerFix
    implements LocalQuickFix {
        private RemoveInitializerFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"inspection.unused.assignment.remove.quickfix", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/defUse/DefUseInspection$RemoveInitializerFix.getName must not return null");
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/defUse/DefUseInspection$RemoveInitializerFix.applyFix must not be null");
            }
            if (descriptor == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/defUse/DefUseInspection$RemoveInitializerFix.applyFix must not be null");
            }
            PsiElement psiInitializer = descriptor.getPsiElement();
            if (!(psiInitializer instanceof PsiExpression)) {
                return;
            }
            if (!(psiInitializer.getParent() instanceof PsiVariable)) {
                return;
            }
            if (!CodeInsightUtilBase.prepareFileForWrite(psiInitializer.getContainingFile())) {
                return;
            }
            PsiVariable variable = (PsiVariable)psiInitializer.getParent();
            PsiDeclarationStatement declaration = (PsiDeclarationStatement)variable.getParent();
            ArrayList<PsiElement> sideEffects = new ArrayList<PsiElement>();
            boolean hasSideEffects = RemoveUnusedVariableFix.checkSideEffects(psiInitializer, variable, sideEffects);
            int res = 2;
            if (hasSideEffects) {
                hasSideEffects = PsiUtil.isStatement((PsiElement)psiInitializer);
                res = RemoveUnusedVariableFix.showSideEffectsWarning(sideEffects, variable, FileEditorManager.getInstance((Project)project).getSelectedTextEditor(), hasSideEffects, ((PsiElement)sideEffects.get(0)).getText(), variable.getTypeElement().getText() + " " + variable.getName() + ";<br>" + psiInitializer.getText());
            }
            try {
                if (res == 2) {
                    psiInitializer.delete();
                } else if (res == 1) {
                    PsiElementFactory factory = JavaPsiFacade.getInstance((Project)variable.getProject()).getElementFactory();
                    PsiStatement statementFromText = factory.createStatementFromText(psiInitializer.getText() + ";", null);
                    declaration.getParent().addAfter((PsiElement)statementFromText, (PsiElement)declaration);
                    psiInitializer.delete();
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/defUse/DefUseInspection$RemoveInitializerFix.getFamilyName must not return null");
            }
            return string;
        }
    }

    private class OptionsPanel
    extends JPanel {
        private final JCheckBox myReportPrefix;
        private final JCheckBox myReportPostfix;
        private final JCheckBox myReportInitializer;

        private OptionsPanel() {
            super(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.weighty = 0.0;
            gc.weightx = 1.0;
            gc.fill = 2;
            gc.anchor = 18;
            this.myReportInitializer = new JCheckBox(InspectionsBundle.message((String)"inspection.unused.assignment.option2", (Object[])new Object[0]));
            this.myReportInitializer.setSelected(DefUseInspection.this.REPORT_REDUNDANT_INITIALIZER);
            this.myReportInitializer.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DefUseInspection.this.REPORT_REDUNDANT_INITIALIZER = OptionsPanel.this.myReportInitializer.isSelected();
                }
            });
            gc.insets = new Insets(0, 0, 15, 0);
            gc.gridy = 0;
            this.add((Component)this.myReportInitializer, gc);
            this.myReportPrefix = new JCheckBox(InspectionsBundle.message((String)"inspection.unused.assignment.option", (Object[])new Object[0]));
            this.myReportPrefix.setSelected(DefUseInspection.this.REPORT_PREFIX_EXPRESSIONS);
            this.myReportPrefix.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DefUseInspection.this.REPORT_PREFIX_EXPRESSIONS = OptionsPanel.this.myReportPrefix.isSelected();
                }
            });
            gc.insets = new Insets(0, 0, 0, 0);
            ++gc.gridy;
            this.add((Component)this.myReportPrefix, gc);
            this.myReportPostfix = new JCheckBox(InspectionsBundle.message((String)"inspection.unused.assignment.option1", (Object[])new Object[0]));
            this.myReportPostfix.setSelected(DefUseInspection.this.REPORT_POSTFIX_EXPRESSIONS);
            this.myReportPostfix.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DefUseInspection.this.REPORT_POSTFIX_EXPRESSIONS = OptionsPanel.this.myReportPostfix.isSelected();
                }
            });
            gc.weighty = 1.0;
            ++gc.gridy;
            this.add((Component)this.myReportPostfix, gc);
        }
    }
}

