/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ModifiableModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Iconable;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class DisableInspectionToolAction
implements IntentionAction,
Iconable {
    private final String myToolId;
    public static final String NAME = InspectionsBundle.message((String)"disable.inspection.action.name", (Object[])new Object[0]);
    private static final Icon ICON = IconLoader.getIcon((String)"/general/inspectionsOff.png");

    public DisableInspectionToolAction(LocalInspectionTool tool) {
        this.myToolId = tool.getShortName();
    }

    public DisableInspectionToolAction(HighlightDisplayKey key) {
        this.myToolId = key.toString();
    }

    @NotNull
    public String getText() {
        String string = NAME;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/DisableInspectionToolAction.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = NAME;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/DisableInspectionToolAction.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ex/DisableInspectionToolAction.isAvailable must not be null");
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ex/DisableInspectionToolAction.invoke must not be null");
        }
        InspectionProjectProfileManager profileManager = InspectionProjectProfileManager.getInstance(file.getProject());
        InspectionProfile inspectionProfile = profileManager.getInspectionProfile();
        ModifiableModel model = inspectionProfile.getModifiableModel();
        model.disableTool(this.myToolId, (PsiElement)file);
        try {
            model.commit();
        }
        catch (IOException e) {
            Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)CommonBundle.getErrorTitle());
        }
        DaemonCodeAnalyzer.getInstance((Project)project).restart();
    }

    public boolean startInWriteAction() {
        return false;
    }

    public Icon getIcon(int flags) {
        return ICON;
    }
}

