/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.CustomSuppressableInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.ex.DescriptorProviderInspection;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.JobDescriptor;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LocalInspectionToolWrapper
extends DescriptorProviderInspection {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.ex.LocalInspectionToolWrapper");
    @NotNull
    private final LocalInspectionTool myTool;

    public LocalInspectionToolWrapper(@NotNull LocalInspectionTool tool) {
        if (tool == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ex/LocalInspectionToolWrapper.<init> must not be null");
        }
        this.myTool = tool;
    }

    @NotNull
    public LocalInspectionTool getTool() {
        LocalInspectionTool localInspectionTool = this.myTool;
        if (localInspectionTool == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/LocalInspectionToolWrapper.getTool must not return null");
        }
        return localInspectionTool;
    }

    public void processFile(PsiFile file, boolean filterSuppressed, InspectionManager manager) {
        this.processFile(file, filterSuppressed, manager, false);
    }

    public void processFile(PsiFile file, boolean filterSuppressed, InspectionManager manager, boolean isOnTheFly) {
        ProblemsHolder holder = new ProblemsHolder(manager, file, isOnTheFly);
        final PsiElementVisitor customVisitor = this.myTool.buildVisitor(holder, isOnTheFly);
        LOG.assertTrue(!(customVisitor instanceof PsiRecursiveElementVisitor), (Object)"The visitor returned from LocalInspectionTool.buildVisitor() must not be recursive");
        file.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                element.accept(customVisitor);
                super.visitElement(element);
            }
        });
        this.addProblemDescriptors(holder.getResults(), filterSuppressed);
    }

    @Override
    @NotNull
    public JobDescriptor[] getJobDescriptors() {
        if (JobDescriptor.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/LocalInspectionToolWrapper.getJobDescriptors must not return null");
        }
        return JobDescriptor.EMPTY_ARRAY;
    }

    public void addProblemDescriptors(List<ProblemDescriptor> descriptors, boolean filterSuppressed) {
        if (descriptors == null || descriptors.isEmpty()) {
            return;
        }
        HashMap<RefElement, ArrayList<ProblemDescriptor>> problems = new HashMap<RefElement, ArrayList<ProblemDescriptor>>();
        RefManagerImpl refManager = (RefManagerImpl)this.getContext().getRefManager();
        for (ProblemDescriptor problemDescriptor : descriptors) {
            PsiElement elt = problemDescriptor.getPsiElement();
            if (elt == null || filterSuppressed && (refManager.isDeclarationsFound() && (this.getContext().isSuppressed(elt, this.myTool.getID()) || this.getContext().isSuppressed(elt, this.myTool.getAlternativeID())) || InspectionManagerEx.inspectionResultSuppressed(elt, this.myTool))) continue;
            PsiNamedElement problemElement = this.myTool.getProblemElement(elt);
            RefElement refElement = refManager.getReference((PsiElement)problemElement);
            ArrayList<ProblemDescriptor> elementProblems = (ArrayList<ProblemDescriptor>)problems.get(refElement);
            if (elementProblems == null) {
                elementProblems = new ArrayList<ProblemDescriptor>();
                problems.put(refElement, elementProblems);
            }
            elementProblems.add(problemDescriptor);
        }
        for (Map.Entry entry : problems.entrySet()) {
            List problemDescriptors = (List)entry.getValue();
            this.addProblemElement((RefEntity)entry.getKey(), filterSuppressed, problemDescriptors.toArray(new CommonProblemDescriptor[problemDescriptors.size()]));
        }
    }

    @Override
    public void runInspection(AnalysisScope scope, final InspectionManager manager) {
        LOG.assertTrue(ApplicationManager.getApplication().isUnitTestMode());
        scope.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitFile(PsiFile file) {
                LocalInspectionToolWrapper.this.processFile(file, true, manager);
            }
        });
    }

    @NotNull
    public String getDisplayName() {
        String string = this.myTool.getDisplayName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/LocalInspectionToolWrapper.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = this.myTool.getGroupDisplayName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/LocalInspectionToolWrapper.getGroupDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        String string = this.myTool.getShortName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/LocalInspectionToolWrapper.getShortName must not return null");
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return this.myTool.isEnabledByDefault();
    }

    @NotNull
    public String[] getGroupPath() {
        String[] stringArray = this.myTool.getGroupPath();
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/LocalInspectionToolWrapper.getGroupPath must not return null");
        }
        return stringArray;
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = this.myTool.getDefaultLevel();
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/LocalInspectionToolWrapper.getDefaultLevel must not return null");
        }
        return highlightDisplayLevel;
    }

    public void readSettings(Element element) throws InvalidDataException {
        this.myTool.readSettings(element);
    }

    public void writeSettings(Element element) throws WriteExternalException {
        this.myTool.writeSettings(element);
    }

    public JComponent createOptionsPanel() {
        return this.myTool.createOptionsPanel();
    }

    public void projectOpened(Project project) {
        this.myTool.projectOpened(project);
    }

    public void projectClosed(Project project) {
        this.myTool.projectClosed(project);
    }

    protected Class<? extends InspectionProfileEntry> getDescriptionContextClass() {
        return this.myTool.getClass();
    }

    @Nullable
    public String getStaticDescription() {
        return this.myTool.getStaticDescription();
    }

    @Override
    @Nullable
    public SuppressIntentionAction[] getSuppressActions() {
        if (this.myTool instanceof CustomSuppressableInspectionTool) {
            return ((CustomSuppressableInspectionTool)this.myTool).getSuppressActions(null);
        }
        return super.getSuppressActions();
    }
}

