/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.miscGenerics;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.BaseLocalInspectionTool;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.IntArrayList;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuspiciousCollectionsMethodCallsInspection
extends BaseLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.miscGenerics.SuspiciousCollectionsMethodCallsInspection");
    private JCheckBox myReportConvertibleCalls;
    private JPanel myPanel;
    public boolean REPORT_CONVERTIBLE_METHOD_CALLS = true;

    public SuspiciousCollectionsMethodCallsInspection() {
        this.$$$setupUI$$$();
        this.myReportConvertibleCalls.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SuspiciousCollectionsMethodCallsInspection.this.REPORT_CONVERTIBLE_METHOD_CALLS = SuspiciousCollectionsMethodCallsInspection.this.myReportConvertibleCalls.isSelected();
            }
        });
    }

    @Nullable
    public JComponent createOptionsPanel() {
        this.myReportConvertibleCalls.setSelected(this.REPORT_CONVERTIBLE_METHOD_CALLS);
        return this.myPanel;
    }

    private static void setupPatternMethods(PsiManager manager, GlobalSearchScope searchScope, List<PsiMethod> patternMethods, IntArrayList indices) {
        PsiClass mapClass;
        PsiClass listClass;
        PsiClass collectionClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.util.Collection", searchScope);
        PsiType[] javaLangObject = new PsiType[]{PsiType.getJavaLangObject((PsiManager)manager, (GlobalSearchScope)searchScope)};
        MethodSignature removeSignature = MethodSignatureUtil.createMethodSignature((String)"remove", (PsiType[])javaLangObject, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        if (collectionClass != null) {
            PsiMethod remove = MethodSignatureUtil.findMethodBySignature((PsiClass)collectionClass, (MethodSignature)removeSignature, (boolean)false);
            SuspiciousCollectionsMethodCallsInspection.addMethod(remove, 0, patternMethods, indices);
            MethodSignature containsSignature = MethodSignatureUtil.createMethodSignature((String)"contains", (PsiType[])javaLangObject, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            PsiMethod contains = MethodSignatureUtil.findMethodBySignature((PsiClass)collectionClass, (MethodSignature)containsSignature, (boolean)false);
            SuspiciousCollectionsMethodCallsInspection.addMethod(contains, 0, patternMethods, indices);
        }
        if ((listClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.util.List", searchScope)) != null) {
            MethodSignature indexofSignature = MethodSignatureUtil.createMethodSignature((String)"indexOf", (PsiType[])javaLangObject, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            PsiMethod indexof = MethodSignatureUtil.findMethodBySignature((PsiClass)listClass, (MethodSignature)indexofSignature, (boolean)false);
            SuspiciousCollectionsMethodCallsInspection.addMethod(indexof, 0, patternMethods, indices);
            MethodSignature lastindexofSignature = MethodSignatureUtil.createMethodSignature((String)"lastIndexOf", (PsiType[])javaLangObject, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            PsiMethod lastindexof = MethodSignatureUtil.findMethodBySignature((PsiClass)listClass, (MethodSignature)lastindexofSignature, (boolean)false);
            SuspiciousCollectionsMethodCallsInspection.addMethod(lastindexof, 0, patternMethods, indices);
        }
        if ((mapClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.util.Map", searchScope)) != null) {
            PsiMethod remove = MethodSignatureUtil.findMethodBySignature((PsiClass)mapClass, (MethodSignature)removeSignature, (boolean)false);
            SuspiciousCollectionsMethodCallsInspection.addMethod(remove, 0, patternMethods, indices);
            MethodSignature getSignature = MethodSignatureUtil.createMethodSignature((String)"get", (PsiType[])javaLangObject, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            PsiMethod get = MethodSignatureUtil.findMethodBySignature((PsiClass)mapClass, (MethodSignature)getSignature, (boolean)false);
            SuspiciousCollectionsMethodCallsInspection.addMethod(get, 0, patternMethods, indices);
            MethodSignature containsKeySignature = MethodSignatureUtil.createMethodSignature((String)"containsKey", (PsiType[])javaLangObject, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            PsiMethod containsKey = MethodSignatureUtil.findMethodBySignature((PsiClass)mapClass, (MethodSignature)containsKeySignature, (boolean)false);
            SuspiciousCollectionsMethodCallsInspection.addMethod(containsKey, 0, patternMethods, indices);
            MethodSignature containsValueSignature = MethodSignatureUtil.createMethodSignature((String)"containsValue", (PsiType[])javaLangObject, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            PsiMethod containsValue = MethodSignatureUtil.findMethodBySignature((PsiClass)mapClass, (MethodSignature)containsValueSignature, (boolean)false);
            SuspiciousCollectionsMethodCallsInspection.addMethod(containsValue, 1, patternMethods, indices);
        }
    }

    private static void addMethod(PsiMethod patternMethod, int typeParamIndex, List<PsiMethod> patternMethods, IntArrayList indices) {
        if (patternMethod != null) {
            patternMethods.add(patternMethod);
            indices.add(typeParamIndex);
        }
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/miscGenerics/SuspiciousCollectionsMethodCallsInspection.buildVisitor must not be null");
        }
        final ArrayList patternMethods = new ArrayList();
        final IntArrayList indices = new IntArrayList();
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                this.visitExpression((PsiExpression)expression);
            }

            public void visitMethodCallExpression(PsiMethodCallExpression methodCall) {
                super.visitMethodCallExpression(methodCall);
                PsiReferenceExpression methodExpression = methodCall.getMethodExpression();
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                if (qualifier == null || qualifier instanceof PsiThisExpression || qualifier instanceof PsiSuperExpression) {
                    return;
                }
                PsiExpression[] args = methodCall.getArgumentList().getExpressions();
                if (args.length != 1) {
                    return;
                }
                PsiType argType = args[0].getType();
                if (argType instanceof PsiPrimitiveType) {
                    argType = ((PsiPrimitiveType)argType).getBoxedType((PsiElement)methodCall);
                }
                if (!(argType instanceof PsiClassType)) {
                    return;
                }
                JavaResolveResult resolveResult = methodExpression.advancedResolve(false);
                PsiMethod calleeMethod = (PsiMethod)resolveResult.getElement();
                if (calleeMethod == null) {
                    return;
                }
                PsiMethod contextMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiMethod.class);
                if (patternMethods.isEmpty()) {
                    SuspiciousCollectionsMethodCallsInspection.setupPatternMethods(methodCall.getManager(), methodCall.getResolveScope(), patternMethods, indices);
                }
                for (int i = 0; i < patternMethods.size(); ++i) {
                    PsiMethod patternMethod = (PsiMethod)patternMethods.get(i);
                    if (!patternMethod.getName().equals(methodExpression.getReferenceName())) continue;
                    int index = indices.get(i);
                    if (contextMethod != null && this.isInheritorOrSelf(contextMethod, patternMethod)) {
                        return;
                    }
                    PsiClass calleeClass = calleeMethod.getContainingClass();
                    PsiSubstitutor substitutor = resolveResult.getSubstitutor();
                    PsiClass patternClass = patternMethod.getContainingClass();
                    substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)patternClass, (PsiClass)calleeClass, (PsiSubstitutor)substitutor);
                    if (substitutor == null || !patternMethod.getSignature(substitutor).equals(calleeMethod.getSignature(PsiSubstitutor.EMPTY))) continue;
                    PsiTypeParameter[] typeParameters = patternClass.getTypeParameters();
                    if (typeParameters.length <= index) {
                        return;
                    }
                    PsiTypeParameter typeParameter = typeParameters[index];
                    PsiType typeParamMapping = substitutor.substitute(typeParameter);
                    if (typeParamMapping == null) {
                        return;
                    }
                    String message = null;
                    if (typeParamMapping instanceof PsiCapturedWildcardType) {
                        typeParamMapping = ((PsiCapturedWildcardType)typeParamMapping).getWildcard();
                    }
                    if (!typeParamMapping.isAssignableFrom(argType)) {
                        if (typeParamMapping.isConvertibleFrom(argType)) {
                            if (SuspiciousCollectionsMethodCallsInspection.this.REPORT_CONVERTIBLE_METHOD_CALLS) {
                                message = InspectionsBundle.message((String)"inspection.suspicious.collections.method.calls.problem.descriptor1", (Object[])new Object[]{PsiFormatUtil.formatMethod((PsiMethod)calleeMethod, (PsiSubstitutor)substitutor, (int)4097, (int)2)});
                            }
                        } else {
                            PsiType qualifierType = qualifier.getType();
                            LOG.assertTrue(qualifierType != null);
                            message = InspectionsBundle.message((String)"inspection.suspicious.collections.method.calls.problem.descriptor", (Object[])new Object[]{PsiFormatUtil.formatType((PsiType)qualifierType, (int)0, (PsiSubstitutor)PsiSubstitutor.EMPTY), PsiFormatUtil.formatType((PsiType)argType, (int)0, (PsiSubstitutor)PsiSubstitutor.EMPTY)});
                        }
                    }
                    if (message != null) {
                        holder.registerProblem((PsiElement)args[0], message, new LocalQuickFix[0]);
                    }
                    return;
                }
            }

            private boolean isInheritorOrSelf(PsiMethod inheritorCandidate, PsiMethod base) {
                PsiClass aClass = inheritorCandidate.getContainingClass();
                PsiClass bClass = base.getContainingClass();
                if (aClass == null || bClass == null) {
                    return false;
                }
                PsiSubstitutor substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)bClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                return substitutor != null && MethodSignatureUtil.findMethodBySignature((PsiClass)bClass, (MethodSignature)inheritorCandidate.getSignature(substitutor), (boolean)false) == base;
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/miscGenerics/SuspiciousCollectionsMethodCallsInspection.buildVisitor must not return null");
        }
        return javaElementVisitor;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.suspicious.collections.method.calls.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/miscGenerics/SuspiciousCollectionsMethodCallsInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.BUGS_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/miscGenerics/SuspiciousCollectionsMethodCallsInspection.getGroupDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("SuspiciousMethodCalls" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/miscGenerics/SuspiciousCollectionsMethodCallsInspection.getShortName must not return null");
        }
        return "SuspiciousMethodCalls";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myReportConvertibleCalls = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/InspectionsBundle").getString("report.suspicious.but.possibly.correct.method.calls"));
        jCheckBox.setSelected(true);
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

