/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefEntityImpl;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.reference.RefProjectImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefModuleImpl
extends RefEntityImpl
implements RefModule {
    private final Module myModule;

    protected RefModuleImpl(Module module, RefManager manager) {
        super(module.getName(), manager);
        this.myModule = module;
        ((RefProjectImpl)manager.getRefProject()).add(this);
    }

    @Override
    public void add(RefEntity child) {
        if (this.myChildren == null) {
            this.myChildren = new ArrayList();
        }
        this.myChildren.add(child);
        if (child.getOwner() == null) {
            ((RefEntityImpl)child).setOwner(this);
        }
    }

    @Override
    protected void removeChild(RefEntity child) {
        if (this.myChildren != null) {
            this.myChildren.remove(child);
        }
    }

    @Override
    public void accept(final RefVisitor refVisitor) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                refVisitor.visitModule((RefModule)RefModuleImpl.this);
            }
        });
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/reference/RefModuleImpl.getModule must not return null");
        }
        return module;
    }

    public boolean isValid() {
        return this.myModule != null && !this.myModule.isDisposed();
    }

    public Icon getIcon(boolean expanded) {
        return this.getModule().getModuleType().getNodeIcon(expanded);
    }

    @Nullable
    public static RefEntity moduleFromName(RefManager manager, String name) {
        return manager.getRefModule(ModuleManager.getInstance((Project)manager.getProject()).findModuleByName(name));
    }
}

