/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler;

import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.compiler.impl.javaCompiler.OutputItemImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.IntermediateOutputCompiler;
import com.intellij.openapi.compiler.TranslatingCompiler;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Chunk;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DummyTranslatingCompiler
implements TranslatingCompiler,
IntermediateOutputCompiler {
    @NonNls
    private static final String DESCRIPTION = "DUMMY TRANSLATOR";
    @NonNls
    private static final String FILETYPE_EXTENSION = ".dummy";

    public boolean isCompilableFile(VirtualFile file, CompileContext context) {
        return file.getName().endsWith(FILETYPE_EXTENSION);
    }

    public void compile(final CompileContext context, Chunk<Module> moduleChunk, final VirtualFile[] files, TranslatingCompiler.OutputSink sink) {
        final ArrayList<File> filesToRefresh = new ArrayList<File>();
        final HashMap outputs = new HashMap();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                for (VirtualFile file : files) {
                    Module module = context.getModuleByFile(file);
                    try {
                        VirtualFile outputDir = context.getModuleOutputDirectory(module);
                        if (outputDir == null) continue;
                        String outputDirPath = outputDir.getPath();
                        File compiledFile = DummyTranslatingCompiler.doCompile(outputDir, file);
                        filesToRefresh.add(compiledFile);
                        ArrayList<OutputItemImpl> collection = (ArrayList<OutputItemImpl>)outputs.get(outputDirPath);
                        if (collection == null) {
                            collection = new ArrayList<OutputItemImpl>();
                            outputs.put(outputDirPath, collection);
                        }
                        collection.add(new OutputItemImpl(FileUtil.toSystemIndependentName((String)compiledFile.getPath()), file));
                    }
                    catch (IOException e) {
                        context.addMessage(CompilerMessageCategory.ERROR, e.getMessage(), null, 0, 0);
                    }
                }
            }
        });
        CompilerUtil.refreshIOFiles(filesToRefresh);
        for (Map.Entry entry : outputs.entrySet()) {
            sink.add((String)entry.getKey(), (Collection)entry.getValue(), VirtualFile.EMPTY_ARRAY);
        }
    }

    private static File doCompile(VirtualFile out, VirtualFile src) throws IOException {
        String originalName = src.getName();
        String compiledName = originalName.substring(0, originalName.length() - FILETYPE_EXTENSION.length());
        File destFile = new File(out.getPath(), compiledName + ".java");
        FileUtil.copy((File)new File(src.getPath()), (File)destFile);
        return destFile;
    }

    @NotNull
    public String getDescription() {
        if (DESCRIPTION == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/impl/javaCompiler/DummyTranslatingCompiler.getDescription must not return null");
        }
        return DESCRIPTION;
    }

    public boolean validateConfiguration(CompileScope scope) {
        return true;
    }
}

