/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler.api;

import com.intellij.compiler.OutputParser;
import com.intellij.compiler.impl.javaCompiler.api.CompilationEvent;
import com.intellij.compiler.impl.javaCompiler.api.MyFileManager;
import com.sun.source.util.JavacTask;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.api.JavacTool;
import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.jetbrains.annotations.NotNull;

public class CompAPIDriver {
    private final BlockingQueue<CompilationEvent> myCompilationResults = new LinkedBlockingQueue<CompilationEvent>();
    private static final CompilationEvent GUARD = new CompilationEvent(){

        @Override
        protected void process(OutputParser.Callback callback) {
        }

        public String toString() {
            return "FINISH";
        }
    };
    private String myOutputDir;
    private volatile boolean compiling;
    private static final PrintWriter COMPILER_ERRORS = new PrintWriter(System.err);
    private volatile boolean processing;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile(List<String> commandLine, List<File> paths, String outputDir) {
        this.myOutputDir = outputDir;
        this.compiling = true;
        assert (this.myCompilationResults.isEmpty());
        JavacTool compiler = JavacTool.create();
        MyFileManager manager = new MyFileManager(this, outputDir);
        Iterable<? extends JavaFileObject> input = manager.getJavaFileObjectsFromFiles(paths);
        DiagnosticListener<JavaFileObject> listener = new DiagnosticListener<JavaFileObject>(){

            @Override
            public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                CompilationEvent event = CompilationEvent.diagnostic(diagnostic);
                CompAPIDriver.this.myCompilationResults.offer(event);
            }
        };
        try {
            JavaCompiler.CompilationTask task = compiler.getTask((Writer)COMPILER_ERRORS, (JavaFileManager)((Object)manager), (DiagnosticListener<? super JavaFileObject>)listener, commandLine, null, input);
            ((JavacTask)task).setTaskListener(new TaskListener(){

                @Override
                public void started(TaskEvent taskEvent) {
                    CompilationEvent event;
                    JavaFileObject sourceFile = taskEvent.getSourceFile();
                    switch (taskEvent.getKind()) {
                        case ANALYZE: {
                            event = CompilationEvent.progress("Analyzing ", sourceFile);
                            break;
                        }
                        case PARSE: {
                            event = CompilationEvent.progress("Parsing ", sourceFile);
                            break;
                        }
                        default: {
                            event = null;
                        }
                    }
                    if (event != null) {
                        CompAPIDriver.this.myCompilationResults.offer(event);
                    }
                }

                @Override
                public void finished(TaskEvent taskEvent) {
                    CompilationEvent event;
                    switch (taskEvent.getKind()) {
                        case ENTER: {
                            event = CompilationEvent.fileProcessed();
                            break;
                        }
                        default: {
                            event = null;
                        }
                    }
                    if (event != null) {
                        CompAPIDriver.this.myCompilationResults.offer(event);
                    }
                }
            });
            task.call();
        }
        finally {
            this.compiling = false;
            this.myCompilationResults.offer(GUARD);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAll(@NotNull OutputParser.Callback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/impl/javaCompiler/api/CompAPIDriver.processAll must not be null");
        }
        try {
            CompilationEvent event;
            this.processing = true;
            while ((event = this.myCompilationResults.take()) != GUARD) {
                event.process(callback);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.processing = false;
        }
    }

    public void finish() {
        assert (!this.compiling) : "still compiling to " + this.myOutputDir;
        assert (!this.processing);
        this.myCompilationResults.clear();
    }

    public void offerClassFile(URI uri, byte[] bytes) {
        CompilationEvent event = CompilationEvent.generateClass(uri, bytes);
        this.myCompilationResults.offer(event);
    }
}

