/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler.jikes;

import com.intellij.compiler.OutputParser;
import com.intellij.compiler.impl.javaCompiler.jikes.JikesConfiguration;
import com.intellij.compiler.impl.javaCompiler.jikes.JikesSettings;
import com.intellij.compiler.impl.javaCompiler.jikes.ParserActionJikes;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;

public class JikesOutputParser
extends OutputParser {
    private final JikesSettings myJikesSettings;
    @NonNls
    private static final String JAVA_FILE_MSG_TAIL = ".java:";
    @NonNls
    private static final String CAUTION = "Caution";
    @NonNls
    private static final String WARNING = "Warning";
    @NonNls
    private static final String ERROR = "Error";
    @NonNls
    private static final String SEMANTIC_WARNING = "Semantic Warning";
    @NonNls
    private static final String SEMANTIC_ERROR = "Semantic Error";
    @NonNls
    private static final String ENTER_TO_CONTINUE_REGEXP = ".*Enter\\s+to\\s+continue.*";

    public JikesOutputParser(Project project) {
        this.myJikesSettings = JikesConfiguration.getSettings(project);
        this.myParserActions.add(new ParserActionJikes());
    }

    @Override
    public boolean processMessageLine(OutputParser.Callback callback) {
        if (super.processMessageLine(callback)) {
            return true;
        }
        String line = callback.getCurrentLine();
        if (line == null) {
            return false;
        }
        if (line.length() == 0) {
            return false;
        }
        if (this.myJikesSettings.IS_EMACS_ERRORS_MODE) {
            String filePath = "";
            int tailIndex = line.indexOf(JAVA_FILE_MSG_TAIL);
            if (tailIndex > 5) {
                filePath = line.substring(0, tailIndex + 5);
            }
            filePath = filePath.replace(File.separatorChar, '/');
            String url = VirtualFileManager.constructUrl((String)"file", (String)filePath);
            if (tailIndex > 6) {
                int colNum;
                int lineNum;
                line = line.substring(tailIndex + 6);
                StringTokenizer tokenizer = new StringTokenizer(line, ":");
                String token = tokenizer.nextToken();
                try {
                    lineNum = Integer.parseInt(token);
                }
                catch (Exception e) {
                    JikesOutputParser.addMessage(callback, CompilerMessageCategory.INFORMATION, line);
                    return true;
                }
                token = tokenizer.nextToken();
                try {
                    colNum = Integer.parseInt(token);
                }
                catch (Exception e) {
                    JikesOutputParser.addMessage(callback, CompilerMessageCategory.INFORMATION, line);
                    return true;
                }
                tokenizer.nextToken();
                tokenizer.nextToken();
                CompilerMessageCategory category = CompilerMessageCategory.INFORMATION;
                token = tokenizer.nextToken().trim();
                if (CAUTION.equalsIgnoreCase(token)) {
                    category = CompilerMessageCategory.WARNING;
                } else if (WARNING.equalsIgnoreCase(token) || SEMANTIC_WARNING.equalsIgnoreCase(token)) {
                    category = CompilerMessageCategory.WARNING;
                } else if (ERROR.equalsIgnoreCase(token) || SEMANTIC_ERROR.equalsIgnoreCase(token)) {
                    category = CompilerMessageCategory.ERROR;
                }
                String message = token;
                message = message.concat("  ");
                message = message.concat(tokenizer.nextToken(""));
                ArrayList<String> messages = new ArrayList<String>();
                messages.add(message);
                if (colNum > 0 && messages.size() > 0) {
                    StringBuffer buf = new StringBuffer();
                    for (String m : messages) {
                        if (buf.length() > 0) {
                            buf.append("\n");
                        }
                        buf.append(m);
                    }
                    JikesOutputParser.addMessage(callback, category, buf.toString(), url, lineNum, colNum);
                    return true;
                }
            }
        }
        if (!line.matches(ENTER_TO_CONTINUE_REGEXP)) {
            JikesOutputParser.addMessage(callback, CompilerMessageCategory.INFORMATION, line);
        }
        return true;
    }
}

