/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.packagingCompiler;

import com.intellij.CommonBundle;
import com.intellij.compiler.CompilerIOUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;

public abstract class MapCache<T> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.MapCache");
    protected Map<String, T> myMap = null;
    protected final File myStoreFile;
    private boolean myIsDirty = false;

    MapCache(String storePath) {
        this.myStoreFile = new File(storePath);
    }

    public boolean isDirty() {
        return this.myIsDirty;
    }

    protected void setDirty() {
        this.myIsDirty = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean load() {
        if (this.myMap == null) {
            this.myMap = new HashMap<String, T>();
            this.myIsDirty = false;
            if (this.myStoreFile.exists() && this.myStoreFile.length() > 0L) {
                try {
                    byte[] bytes = FileUtil.loadFileBytes((File)this.myStoreFile);
                    DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(bytes));
                    try {
                        int version = inputStream.readInt();
                        if (version == 54) {
                            int size = inputStream.readInt();
                            this.myMap = new HashMap<String, T>();
                            for (int i = 0; i < size; ++i) {
                                String key = CompilerIOUtil.readString(inputStream);
                                T value = this.read(inputStream);
                                this.myMap.put(key, value);
                            }
                        }
                    }
                    finally {
                        inputStream.close();
                    }
                }
                catch (Throwable e) {
                    LOG.info(e);
                }
            }
        }
        return true;
    }

    protected abstract T read(DataInputStream var1) throws IOException;

    protected abstract void write(T var1, DataOutputStream var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        block8: {
            if (this.myMap == null) {
                return;
            }
            try {
                FileUtil.createParentDirs((File)this.myStoreFile);
                DataOutputStream outStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.myStoreFile)));
                try {
                    outStream.writeInt(54);
                    Iterator<String> keysIterator = this.myMap.keySet().iterator();
                    outStream.writeInt(this.myMap.size());
                    while (keysIterator.hasNext()) {
                        String key = keysIterator.next();
                        T value = this.myMap.get(key);
                        CompilerIOUtil.writeString(key, outStream);
                        this.write(value, outStream);
                    }
                    this.myIsDirty = false;
                }
                finally {
                    outStream.close();
                }
            }
            catch (IOException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Throwable)e);
                }
                if (ApplicationManager.getApplication().isUnitTestMode()) break block8;
                final String message = CompilerBundle.message((String)"error.saving.data.to.file", (Object[])new Object[]{this.myStoreFile.getPath(), e.getMessage()});
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Messages.showMessageDialog((String)message, (String)CommonBundle.getWarningTitle(), (Icon)Messages.getWarningIcon());
                    }
                });
            }
        }
    }

    public boolean wipe() {
        this.myMap = null;
        this.myIsDirty = false;
        return this.myStoreFile.delete();
    }
}

