/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl;

import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.debugger.ui.tree.ValueMarkup;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.ui.DebuggerColors;
import com.sun.jdi.Method;
import javax.swing.JList;

class FramesListRenderer
extends ColoredListCellRenderer {
    private final EditorColorsScheme myColorScheme = EditorColorsManager.getInstance().getGlobalScheme();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void customizeCellRenderer(JList list, Object item, int index, boolean selected, boolean hasFocus) {
        if (!(item instanceof StackFrameDescriptorImpl)) {
            this.append(item.toString(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        } else {
            StackFrameDescriptorImpl descriptor = (StackFrameDescriptorImpl)item;
            this.setIcon(descriptor.getIcon());
            Object selectedValue = list.getSelectedValue();
            boolean shouldHighlightAsRecursive = selectedValue instanceof StackFrameDescriptorImpl && FramesListRenderer.isOccurrenceOfSelectedFrame((StackFrameDescriptorImpl)selectedValue, descriptor);
            ValueMarkup markup = descriptor.getValueMarkup();
            if (markup != null) {
                this.append("[" + markup.getText() + "] ", new SimpleTextAttributes(1, markup.getColor()));
            }
            if (selected) {
                this.setBackground(UIUtil.getListSelectionBackground());
            } else {
                this.setBackground(shouldHighlightAsRecursive ? this.myColorScheme.getColor(DebuggerColors.RECURSIVE_CALL_ATTRIBUTES) : UIUtil.getListBackground());
            }
            String label = descriptor.getLabel();
            int openingBrace = label.indexOf("{");
            int closingBrace = openingBrace < 0 ? -1 : label.indexOf("}");
            SimpleTextAttributes attributes = FramesListRenderer.getAttributes(descriptor);
            if (openingBrace < 0 || closingBrace < 0) {
                this.append(label, attributes);
            } else {
                this.append(label.substring(0, openingBrace - 1), attributes);
                StringBuilder builder = StringBuilderSpinAllocator.alloc();
                try {
                    builder.append(" (");
                    builder.append(label.substring(openingBrace + 1, closingBrace));
                    builder.append(")");
                    this.append(builder.toString(), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
                }
                finally {
                    StringBuilderSpinAllocator.dispose((StringBuilder)builder);
                }
                this.append(label.substring(closingBrace + 1, label.length()), attributes);
                if (shouldHighlightAsRecursive && descriptor.isRecursiveCall()) {
                    StringBuilder _builder = StringBuilderSpinAllocator.alloc();
                    try {
                        _builder.append(" [").append(descriptor.getOccurrenceIndex()).append("]");
                        this.append(_builder.toString(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    }
                    finally {
                        StringBuilderSpinAllocator.dispose((StringBuilder)_builder);
                    }
                }
            }
        }
    }

    private static boolean isOccurrenceOfSelectedFrame(StackFrameDescriptorImpl selectedDescriptor, StackFrameDescriptorImpl descriptor) {
        Method selectedMethod;
        Method currentMethod = descriptor.getMethod();
        return currentMethod != null && selectedDescriptor != null && (selectedMethod = selectedDescriptor.getMethod()) != null && Comparing.equal((Object)selectedMethod, (Object)currentMethod);
    }

    private static SimpleTextAttributes getAttributes(StackFrameDescriptorImpl descriptor) {
        if (descriptor.isSynthetic() || descriptor.isInLibraryContent()) {
            return SimpleTextAttributes.GRAYED_ATTRIBUTES;
        }
        return SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES;
    }
}

