/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.errorreport.bean;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import org.jetbrains.annotations.NonNls;

public class ExceptionBean {
    private String hashCode;
    private String message;
    private Date date;
    private String stackTrace;
    private int itnThreadId;
    private String buildNumber;
    private String productCode;
    private boolean scrambled;
    public static final int NO_EAP_THREAD = -1;
    private String exceptionClass = "";

    public String getExceptionClass() {
        return this.exceptionClass;
    }

    protected ExceptionBean(ExceptionBean e) {
        this.hashCode = e.hashCode;
        this.message = e.message;
        this.date = e.date;
        this.stackTrace = e.stackTrace;
        this.itnThreadId = e.itnThreadId;
        this.buildNumber = e.buildNumber;
        this.productCode = e.productCode;
        this.scrambled = e.scrambled;
    }

    public ExceptionBean() {
    }

    public ExceptionBean(Throwable throwable) {
        if (throwable != null) {
            this.exceptionClass = throwable.getClass().getName();
            this.message = throwable.getMessage();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            throwable.printStackTrace(new PrintStream(baos, true));
            this.stackTrace = baos.toString();
            try {
                this.hashCode = ExceptionBean.md5(this.stackTrace, "stack-trace");
            }
            catch (NoSuchAlgorithmException e) {
                this.hashCode = null;
            }
        }
    }

    private static String md5(String buffer, @NonNls String key) throws NoSuchAlgorithmException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(buffer.getBytes());
        byte[] code = md5.digest(key.getBytes());
        BigInteger bi = new BigInteger(code).abs();
        return bi.abs().toString(16);
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    public String getHashCode() {
        return this.hashCode;
    }

    public void setHashCode(String hashCode) {
        this.hashCode = hashCode;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(String buildNumber) {
        this.buildNumber = buildNumber;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int getItnThreadId() {
        return this.itnThreadId;
    }

    public void setItnThreadId(int itnThreadId) {
        this.itnThreadId = itnThreadId;
    }

    public boolean isScrambled() {
        return this.scrambled;
    }

    public void setScrambled(boolean scrambled) {
        this.scrambled = scrambled;
    }
}

