/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.PoolOfTestIcons;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.TreeToolTipHandler;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.tree.TreeUtil;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TestTreeView
extends Tree
implements DataProvider {
    private TestFrameworkRunningModel myModel;

    protected abstract TreeCellRenderer getRenderer(TestConsoleProperties var1);

    public abstract AbstractTestProxy getSelectedTest(@NotNull TreePath var1);

    @Nullable
    public AbstractTestProxy getSelectedTest() {
        TreePath selectionPath = this.getSelectionPath();
        return selectionPath != null ? this.getSelectedTest(selectionPath) : null;
    }

    public void attachToModel(TestFrameworkRunningModel model) {
        this.setModel(new DefaultTreeModel(new DefaultMutableTreeNode(model.getRoot())));
        this.getSelectionModel().setSelectionMode(1);
        this.myModel = model;
        Disposer.register((Disposable)this.myModel, (Disposable)new Disposable(){

            public void dispose() {
                TestTreeView.this.setModel(null);
                TestTreeView.this.myModel = null;
            }
        });
        this.installHandlers();
        this.setCellRenderer(this.getRenderer(this.myModel.getProperties()));
    }

    public void setUI(TreeUI ui) {
        super.setUI(ui);
        int fontHeight = this.getFontMetrics(this.getFont()).getHeight();
        int iconHeight = PoolOfTestIcons.PASSED_ICON.getIconHeight();
        this.setRowHeight(Math.max(fontHeight, iconHeight) + 2);
        this.setLargeModel(true);
    }

    public Object getData(String dataId) {
        TreePath selectionPath = this.getSelectionPath();
        if (selectionPath == null) {
            return null;
        }
        AbstractTestProxy testProxy = this.getSelectedTest(selectionPath);
        if (testProxy == null) {
            return null;
        }
        return TestsUIUtil.getData(testProxy, dataId, this.myModel);
    }

    protected void installHandlers() {
        EditSourceOnDoubleClickHandler.install((JTree)((Object)this));
        new TreeSpeedSearch(this, new Convertor<TreePath, String>(){

            public String convert(TreePath path) {
                AbstractTestProxy testProxy = TestTreeView.this.getSelectedTest(path);
                if (testProxy == null) {
                    return null;
                }
                return testProxy.getName();
            }
        });
        TreeToolTipHandler.install((JTree)((Object)this));
        TreeUtil.installActions((JTree)((Object)this));
        PopupHandler.installPopupHandler((JComponent)((Object)this), (String)"TestTreePopupMenu", (String)"TestTreeViewPopup");
    }
}

