/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.ui;

import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.LvcsHelper;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestTreeView;
import com.intellij.execution.testframework.ToolbarPanel;
import com.intellij.execution.testframework.sm.SMRunnerUtil;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsListener;
import com.intellij.execution.testframework.sm.runner.SMTRunnerTreeBuilder;
import com.intellij.execution.testframework.sm.runner.SMTRunnerTreeStructure;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.PropagateSelectionHandler;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerTestTreeView;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerToolbarPanel;
import com.intellij.execution.testframework.sm.runner.ui.TestResultsViewer;
import com.intellij.execution.testframework.sm.runner.ui.TestsPresentationUtil;
import com.intellij.execution.testframework.sm.runner.ui.statistics.StatisticsPanel;
import com.intellij.execution.testframework.ui.AbstractTestTreeBuilder;
import com.intellij.execution.testframework.ui.PrintableTestProxy;
import com.intellij.execution.testframework.ui.TestResultsPanel;
import com.intellij.execution.testframework.ui.TestsProgressAnimator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.util.ColorProgressBar;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.config.AbstractProperty;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SMTestRunnerResultsForm
extends TestResultsPanel
implements TestFrameworkRunningModel,
TestResultsViewer,
SMTRunnerEventsListener {
    @NonNls
    private static final String DEFAULT_SM_RUNNER_SPLITTER_PROPERTY = "SMTestRunner.Splitter.Proportion";
    private SMTRunnerTestTreeView myTreeView;
    private TestsProgressAnimator myAnimator;
    private final SMTestProxy myTestsRootNode;
    private SMTRunnerTreeBuilder myTreeBuilder;
    private final TestConsoleProperties myConsoleProperties;
    private final List<TestResultsViewer.EventsListener> myEventListeners;
    private PropagateSelectionHandler myShowStatisticForProxyHandler;
    private final Project myProject;
    private int myTestsCurrentCount;
    private int myTestsTotal;
    private int myTestsFailuresCount;
    private long myStartTime;
    private long myEndTime;
    private StatisticsPanel myStatisticsPane;
    private String myCurrentCustomProgressCategory;
    private Set<String> myMentionedCategories;

    public SMTestRunnerResultsForm(RunConfigurationBase runConfiguration, @NotNull JComponent console, TestConsoleProperties consoleProperties, RunnerSettings runnerSettings, ConfigurationPerRunnerSettings configurationSettings) {
        if (console == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm.<init> must not be null");
        }
        this(runConfiguration, console, AnAction.EMPTY_ARRAY, consoleProperties, runnerSettings, configurationSettings, null);
    }

    public SMTestRunnerResultsForm(RunConfigurationBase runConfiguration, @NotNull JComponent console, AnAction[] consoleActions, TestConsoleProperties consoleProperties, RunnerSettings runnerSettings, ConfigurationPerRunnerSettings configurationSettings, String splitterPropertyName) {
        if (console == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm.<init> must not be null");
        }
        super(console, consoleActions, consoleProperties, runnerSettings, configurationSettings, splitterPropertyName != null ? DEFAULT_SM_RUNNER_SPLITTER_PROPERTY : splitterPropertyName, 0.5f);
        this.myEventListeners = new ArrayList<TestResultsViewer.EventsListener>();
        this.myTestsTotal = 0;
        this.myMentionedCategories = new LinkedHashSet<String>();
        this.myConsoleProperties = consoleProperties;
        this.myProject = runConfiguration.getProject();
        this.myTestsRootNode = new SMTestProxy("[root]", true, null);
    }

    @Override
    public void initUI() {
        super.initUI();
        KeyStroke shiftEnterKey = KeyStroke.getKeyStroke(10, 1);
        SMRunnerUtil.registerAsAction(shiftEnterKey, "show-statistics-for-test-proxy", new Runnable(){

            @Override
            public void run() {
                SMTestRunnerResultsForm.this.showStatisticsForSelectedProxy();
            }
        }, (JComponent)((Object)this.myTreeView));
    }

    @Override
    protected ToolbarPanel createToolbarPanel() {
        return new SMTRunnerToolbarPanel(this.myConsoleProperties, this.myRunnerSettings, this.myConfigurationSettings, this, this);
    }

    @Override
    protected JComponent createTestTreeView() {
        this.myTreeView = new SMTRunnerTestTreeView();
        this.myTreeView.setLargeModel(true);
        this.myTreeView.attachToModel(this);
        this.myTreeView.setTestResultsViewer(this);
        SMTRunnerTreeStructure structure = new SMTRunnerTreeStructure(this.myProject, this.myTestsRootNode);
        this.myTreeBuilder = new SMTRunnerTreeBuilder((JTree)((Object)this.myTreeView), structure);
        Disposer.register((Disposable)this, (Disposable)this.myTreeBuilder);
        this.myAnimator = new MyAnimator(this, this.myTreeBuilder);
        return this.myTreeView;
    }

    @Override
    protected JComponent createStatisticsPanel() {
        StatisticsPanel statisticsPane = new StatisticsPanel(this.myProject, this);
        statisticsPane.addPropagateSelectionListener(this.createSelectMeListener());
        this.setShowStatisticForProxyHandler(statisticsPane.createSelectMeListener());
        this.myStatisticsPane = statisticsPane;
        return this.myStatisticsPane.getContentPane();
    }

    public StatisticsPanel getStatisticsPane() {
        return this.myStatisticsPane;
    }

    public void addTestsTreeSelectionListener(TreeSelectionListener listener) {
        this.myTreeView.getSelectionModel().addTreeSelectionListener(listener);
    }

    @Override
    public void setShowStatisticForProxyHandler(PropagateSelectionHandler handler) {
        this.myShowStatisticForProxyHandler = handler;
    }

    @Override
    public void onTestingStarted(@NotNull SMTestProxy testsRoot) {
        if (testsRoot == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm.onTestingStarted must not be null");
        }
        this.myAnimator.setCurrentTestCase(this.myTestsRootNode);
        this.myStatusLine.setStatusColor(ColorProgressBar.GREEN);
        this.selectAndNotify(this.myTestsRootNode);
        this.myStartTime = System.currentTimeMillis();
        Date today = new Date(this.myStartTime);
        this.myTestsRootNode.addSystemOutput("Testing started at " + DateFormat.getTimeInstance(3).format(today) + " ...\n");
        this.updateStatusLabel();
        this.fireOnTestingStarted();
    }

    @Override
    public void onTestingFinished(@NotNull SMTestProxy testsRoot) {
        if (testsRoot == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm.onTestingFinished must not be null");
        }
        this.myEndTime = System.currentTimeMillis();
        if (this.myTestsTotal == 0) {
            this.myTestsTotal = this.myTestsCurrentCount;
            this.myStatusLine.setFraction(1.0);
        }
        this.updateStatusLabel();
        if (this.myTestsRootNode.getChildren().size() == 0) {
            this.myStatusLine.setStatusColor(ColorProgressBar.RED);
        }
        this.myAnimator.stopMovie();
        this.myTreeBuilder.updateFromRoot();
        LvcsHelper.addLabel(this);
        this.fireOnTestingFinished();
    }

    @Override
    public void onTestsCountInSuite(int count) {
        this.updateCountersAndProgressOnTestCount(count, false);
    }

    @Override
    public void onTestStarted(@NotNull SMTestProxy testProxy) {
        if (testProxy == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm.onTestStarted must not be null");
        }
        this.updateCountersAndProgressOnTestStarted(false);
        this._addTestOrSuite(testProxy);
        this.fireOnTestNodeAdded(testProxy);
    }

    @Override
    public void onTestFailed(@NotNull SMTestProxy test) {
        if (test == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm.onTestFailed must not be null");
        }
        this.updateCountersAndProgressOnTestFailed(false);
    }

    @Override
    public void onTestIgnored(@NotNull SMTestProxy test) {
        if (test == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm.onTestIgnored must not be null");
        }
    }

    @Override
    public void onSuiteStarted(@NotNull SMTestProxy newSuite) {
        if (newSuite == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm.onSuiteStarted must not be null");
        }
        this._addTestOrSuite(newSuite);
    }

    @Override
    public void onCustomProgressTestsCategory(@Nullable String categoryName, int testCount) {
        this.myCurrentCustomProgressCategory = categoryName;
        this.updateCountersAndProgressOnTestCount(testCount, true);
    }

    @Override
    public void onCustomProgressTestStarted() {
        this.updateCountersAndProgressOnTestStarted(true);
    }

    @Override
    public void onCustomProgressTestFailed() {
        this.updateCountersAndProgressOnTestFailed(true);
    }

    @Override
    public void onTestFinished(@NotNull SMTestProxy test) {
        if (test == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm.onTestFinished must not be null");
        }
    }

    @Override
    public void onSuiteFinished(@NotNull SMTestProxy suite) {
        if (suite == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm.onSuiteFinished must not be null");
        }
    }

    @Override
    public SMTestProxy getTestsRootNode() {
        return this.myTestsRootNode;
    }

    @Override
    public TestConsoleProperties getProperties() {
        return this.myConsoleProperties;
    }

    @Override
    public void setFilter(Filter filter) {
        SMTRunnerTreeStructure treeStructure = this.myTreeBuilder.getRTestUnitTreeStructure();
        treeStructure.setFilter(filter);
        this.myTreeBuilder.updateFromRoot();
    }

    @Override
    public boolean isRunning() {
        return this.getRoot().isInProgress();
    }

    @Override
    public TestTreeView getTreeView() {
        return this.myTreeView;
    }

    @Override
    public boolean hasTestSuites() {
        return this.getRoot().getChildren().size() > 0;
    }

    @Override
    @NotNull
    public AbstractTestProxy getRoot() {
        SMTestProxy sMTestProxy = this.myTestsRootNode;
        if (sMTestProxy == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm.getRoot must not return null");
        }
        return sMTestProxy;
    }

    @Override
    public void selectAndNotify(@Nullable AbstractTestProxy testProxy) {
        this.selectWithoutNotify(testProxy);
        this.showStatisticsForSelectedProxy(testProxy, false);
    }

    @Override
    public void addEventsListener(final TestResultsViewer.EventsListener listener) {
        this.myEventListeners.add(listener);
        this.addTestsTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                PrintableTestProxy selectedProxy = (PrintableTestProxy)SMTestRunnerResultsForm.this.getTreeView().getSelectedTest();
                listener.onSelected(selectedProxy, SMTestRunnerResultsForm.this, SMTestRunnerResultsForm.this);
            }
        });
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myShowStatisticForProxyHandler = null;
        this.myEventListeners.clear();
    }

    @Override
    public void showStatisticsForSelectedProxy() {
        TestConsoleProperties.SHOW_STATISTICS.set((AbstractProperty.AbstractPropertyContainer)this.myProperties, (Object)true);
        AbstractTestProxy selectedProxy = this.myTreeView.getSelectedTest();
        this.showStatisticsForSelectedProxy(selectedProxy, true);
    }

    private void showStatisticsForSelectedProxy(AbstractTestProxy selectedProxy, boolean requestFocus) {
        if (selectedProxy instanceof SMTestProxy && this.myShowStatisticForProxyHandler != null) {
            this.myShowStatisticForProxyHandler.handlePropagateSelectionRequest((SMTestProxy)selectedProxy, this, requestFocus);
        }
    }

    protected int getTestsCurrentCount() {
        return this.myTestsCurrentCount;
    }

    protected int getTestsFailuresCount() {
        return this.myTestsFailuresCount;
    }

    protected Color getTestsStatusColor() {
        return this.myStatusLine.getStatusColor();
    }

    protected int getTestsTotal() {
        return this.myTestsTotal;
    }

    public Set<String> getMentionedCategories() {
        return this.myMentionedCategories;
    }

    protected long getStartTime() {
        return this.myStartTime;
    }

    protected long getEndTime() {
        return this.myEndTime;
    }

    private void _addTestOrSuite(@NotNull SMTestProxy newTestOrSuite) {
        if (newTestOrSuite == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm._addTestOrSuite must not be null");
        }
        SMTestProxy parentSuite = newTestOrSuite.getParent();
        assert (parentSuite != null);
        this.myTreeBuilder.updateTestsSubtree(parentSuite);
        this.myTreeBuilder.repaintWithParents(newTestOrSuite);
        this.myAnimator.setCurrentTestCase(newTestOrSuite);
    }

    private void fireOnTestNodeAdded(SMTestProxy test) {
        for (TestResultsViewer.EventsListener eventListener : this.myEventListeners) {
            eventListener.onTestNodeAdded(this, test);
        }
    }

    private void fireOnTestingFinished() {
        for (TestResultsViewer.EventsListener eventListener : this.myEventListeners) {
            eventListener.onTestingFinished(this);
        }
    }

    private void fireOnTestingStarted() {
        for (TestResultsViewer.EventsListener eventListener : this.myEventListeners) {
            eventListener.onTestingStarted(this);
        }
    }

    private void selectWithoutNotify(final AbstractTestProxy testProxy) {
        if (testProxy == null) {
            return;
        }
        SMRunnerUtil.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                SMTestRunnerResultsForm.this.myTreeBuilder.select(testProxy, null);
            }
        }, ModalityState.NON_MODAL);
    }

    private void updateStatusLabel() {
        if (this.myTestsFailuresCount > 0) {
            this.myStatusLine.setStatusColor(ColorProgressBar.RED);
        }
        this.myStatusLine.setText(TestsPresentationUtil.getProgressStatus_Text(this.myStartTime, this.myEndTime, this.myTestsTotal, this.myTestsCurrentCount, this.myTestsFailuresCount, this.myMentionedCategories));
    }

    public void performUpdate() {
        this.myTreeBuilder.performUpdate();
    }

    public PropagateSelectionHandler createSelectMeListener() {
        return new PropagateSelectionHandler(){

            @Override
            public void handlePropagateSelectionRequest(final @Nullable SMTestProxy selectedTestProxy, @NotNull Object sender, final boolean requestFocus) {
                if (sender == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm$4.handlePropagateSelectionRequest must not be null");
                }
                SMRunnerUtil.addToInvokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SMTestRunnerResultsForm.this.selectWithoutNotify(selectedTestProxy);
                        if (requestFocus) {
                            IdeFocusManager.getInstance((Project)SMTestRunnerResultsForm.this.myProject).requestFocus((Component)((Object)SMTestRunnerResultsForm.this.myTreeView), true);
                        }
                    }
                });
            }
        };
    }

    private void updateCountersAndProgressOnTestCount(int count, boolean isCustomMessage) {
        if (!this.isModeConsistent(isCustomMessage)) {
            return;
        }
        this.myTestsTotal += count;
        this.updateStatusLabel();
    }

    private void updateCountersAndProgressOnTestStarted(boolean isCustomMessage) {
        if (!this.isModeConsistent(isCustomMessage)) {
            return;
        }
        this.myMentionedCategories.add(this.myCurrentCustomProgressCategory != null ? this.myCurrentCustomProgressCategory : "Tests");
        ++this.myTestsCurrentCount;
        if (this.myTestsCurrentCount > this.myTestsTotal && this.myTestsTotal != 0) {
            this.myTestsTotal = this.myTestsCurrentCount;
        }
        if (this.myTestsTotal != 0) {
            this.myStatusLine.setFraction((double)this.myTestsCurrentCount / (double)this.myTestsTotal);
        } else {
            this.myStatusLine.setFraction(0.5);
        }
        this.updateStatusLabel();
    }

    private void updateCountersAndProgressOnTestFailed(boolean isCustomMessage) {
        if (!this.isModeConsistent(isCustomMessage)) {
            return;
        }
        ++this.myTestsFailuresCount;
        this.updateStatusLabel();
    }

    private boolean isModeConsistent(boolean isCustomMessage) {
        return isCustomMessage != (this.myCurrentCustomProgressCategory == null);
    }

    private static class MyFocusTraversalPolicy
    extends FocusTraversalPolicy {
        final List<Component> myComponents;

        private MyFocusTraversalPolicy(List<Component> components) {
            this.myComponents = components;
        }

        @Override
        public Component getComponentAfter(Container container, Component component) {
            return this.myComponents.get((this.myComponents.indexOf(component) + 1) % this.myComponents.size());
        }

        @Override
        public Component getComponentBefore(Container container, Component component) {
            int prevIndex = this.myComponents.indexOf(component) - 1;
            int normalizedIndex = prevIndex < 0 ? this.myComponents.size() - 1 : prevIndex;
            return this.myComponents.get(normalizedIndex);
        }

        @Override
        public Component getFirstComponent(Container container) {
            return this.myComponents.get(0);
        }

        @Override
        public Component getLastComponent(Container container) {
            return this.myComponents.get(this.myComponents.size() - 1);
        }

        @Override
        public Component getDefaultComponent(Container container) {
            return this.getFirstComponent(container);
        }
    }

    private static class MyAnimator
    extends TestsProgressAnimator {
        public MyAnimator(Disposable parentDisposable, AbstractTestTreeBuilder builder) {
            super(parentDisposable);
            this.init(builder);
        }
    }
}

