/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.find.FindManager;
import com.intellij.find.actions.FindUsagesAction;
import com.intellij.find.actions.FindUsagesInFileAction;
import com.intellij.find.actions.ShowUsagesTableCellRenderer;
import com.intellij.find.actions.UsageListCellRenderer;
import com.intellij.find.findUsages.AbstractFindUsagesDialog;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.TableScrollingUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.PsiElementUsageTarget;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageToPsiElementProvider;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.UsageViewSettings;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.NullUsage;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.rules.UsageFilteringRuleProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Icons;
import com.intellij.util.Processor;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.Table;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.tree.MutableTreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ShowUsagesAction
extends AnAction {
    private final boolean showSettingsDialogBefore;
    private static final int USAGES_PAGE_SIZE = 100;
    private static final Comparator<Object> USAGE_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object c1, Object c2) {
            VirtualFile v2;
            String name2;
            if (!(c1 instanceof UsageNode)) {
                return 1;
            }
            if (!(c2 instanceof UsageNode)) {
                return -1;
            }
            Usage o1 = ((UsageNode)c1).getUsage();
            Usage o2 = ((UsageNode)c2).getUsage();
            if (o1 == NullUsage.INSTANCE) {
                return 1;
            }
            if (o2 == NullUsage.INSTANCE) {
                return -1;
            }
            VirtualFile v1 = UsageListCellRenderer.getVirtualFile(o1);
            String name1 = v1 == null ? null : v1.getName();
            int i = Comparing.compare((Comparable)((Object)name1), (Comparable)((Object)(name2 = (v2 = UsageListCellRenderer.getVirtualFile(o2)) == null ? null : v2.getName())));
            if (i != 0) {
                return i;
            }
            if (o1 instanceof Comparable && o2 instanceof Comparable) {
                return ((Comparable)o1).compareTo(o2);
            }
            FileEditorLocation loc1 = o1.getLocation();
            FileEditorLocation loc2 = o2.getLocation();
            return Comparing.compare((Comparable)loc1, (Comparable)loc2);
        }
    };
    private static final Runnable HIDE_HINTS_ACTION = new Runnable(){

        @Override
        public void run() {
            ShowUsagesAction.hideHints();
        }
    };
    private int myWidth;

    public ShowUsagesAction() {
        this.setInjectedContext(true);
        this.showSettingsDialogBefore = false;
    }

    private ShowUsagesAction(boolean showDialogBefore) {
        this.setInjectedContext(true);
        this.showSettingsDialogBefore = showDialogBefore;
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        ShowUsagesAction.hideHints();
        this.myWidth = -1;
        final RelativePoint popupPosition = JBPopupFactory.getInstance().guessBestPopupLocation(e.getDataContext());
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.goto.usages");
        UsageTarget[] usageTargets = (UsageTarget[])e.getData(UsageView.USAGE_TARGETS_KEY);
        final Editor editor = (Editor)e.getData(PlatformDataKeys.EDITOR);
        if (usageTargets == null) {
            FindUsagesAction.chooseAmbiguousTargetAndPerform(project, editor, new PsiElementProcessor<PsiElement>(){

                public boolean execute(PsiElement element) {
                    ShowUsagesAction.this.startFindUsages(element, popupPosition, editor, 100);
                    return false;
                }
            });
        } else {
            PsiElement element = ((PsiElementUsageTarget)usageTargets[0]).getElement();
            if (element != null) {
                this.startFindUsages(element, popupPosition, editor, 100);
            }
        }
    }

    private static void hideHints() {
        HintManager.getInstance().hideHints(2, false, false);
    }

    private void startFindUsages(@NotNull PsiElement element, RelativePoint popupPosition, Editor editor, int maxUsages) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/find/actions/ShowUsagesAction.startFindUsages must not be null");
        }
        Project project = element.getProject();
        FindUsagesManager findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)project)).getFindUsagesManager();
        FindUsagesHandler handler = findUsagesManager.getFindUsagesHandler(element, false);
        if (handler == null) {
            return;
        }
        if (this.showSettingsDialogBefore) {
            this.showDialogAndFindUsages(handler, popupPosition, editor, maxUsages);
            return;
        }
        this.showElementUsages(handler, editor, popupPosition, maxUsages);
    }

    private void showElementUsages(final @NotNull FindUsagesHandler handler, Editor editor, RelativePoint popupPosition, final int maxUsages) {
        if (handler == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/find/actions/ShowUsagesAction.showElementUsages must not be null");
        }
        UsageViewPresentation presentation = new UsageViewPresentation();
        presentation.setDetachedMode(true);
        final UsageViewSettings usageViewSettings = UsageViewSettings.getInstance();
        final UsageViewSettings save = new UsageViewSettings();
        save.loadState(usageViewSettings);
        usageViewSettings.GROUP_BY_FILE_STRUCTURE = false;
        usageViewSettings.GROUP_BY_MODULE = false;
        usageViewSettings.GROUP_BY_PACKAGE = false;
        usageViewSettings.GROUP_BY_USAGE_TYPE = false;
        usageViewSettings.GROUP_BY_SCOPE = false;
        UsageViewManager manager = UsageViewManager.getInstance((Project)handler.getProject());
        final UsageViewImpl usageView = (UsageViewImpl)manager.createUsageView(UsageTarget.EMPTY_ARRAY, Usage.EMPTY_ARRAY, presentation, null);
        Disposer.register((Disposable)usageView, (Disposable)new Disposable(){

            public void dispose() {
                usageViewSettings.GROUP_BY_FILE_STRUCTURE = save.GROUP_BY_FILE_STRUCTURE;
                usageViewSettings.GROUP_BY_MODULE = save.GROUP_BY_MODULE;
                usageViewSettings.GROUP_BY_PACKAGE = save.GROUP_BY_PACKAGE;
                usageViewSettings.GROUP_BY_USAGE_TYPE = save.GROUP_BY_USAGE_TYPE;
                usageViewSettings.GROUP_BY_SCOPE = save.GROUP_BY_SCOPE;
            }
        });
        final ArrayList<Usage> usages = new ArrayList<Usage>();
        final LinkedHashSet<UsageNode> visibleNodes = new LinkedHashSet<UsageNode>();
        Processor<Usage> collect = new Processor<Usage>(){
            final UsageTarget[] myUsageTarget;
            {
                this.myUsageTarget = new UsageTarget[]{new PsiElement2UsageTargetAdapter(handler.getPsiElement())};
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean process(@NotNull Usage usage) {
                if (usage == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/find/actions/ShowUsagesAction$5.process must not be null");
                }
                List list = usages;
                synchronized (list) {
                    if (visibleNodes.size() > maxUsages) {
                        return false;
                    }
                    if (UsageViewManager.isSelfUsage((Usage)usage, (UsageTarget[])this.myUsageTarget)) {
                        return true;
                    }
                    UsageNode node = usageView.doAppendUsage(usage);
                    if (node != null) {
                        if (visibleNodes.size() == maxUsages) {
                            usageView.removeUsage(usage);
                            visibleNodes.add(UsageViewImpl.NULL_NODE);
                            return false;
                        }
                        visibleNodes.add(node);
                    }
                    usages.add(usage);
                }
                return true;
            }
        };
        FindUsagesManager findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)handler.getProject())).getFindUsagesManager();
        presentation = findUsagesManager.processUsages(handler, collect);
        if (presentation == null) {
            Disposer.dispose((Disposable)usageView);
            return;
        }
        String title = presentation.getTabText();
        JBPopup popup = this.createUsagePopup(usages, visibleNodes, title, handler, editor, popupPosition, maxUsages, usageView);
        if (popup == null) {
            Disposer.dispose((Disposable)usageView);
        } else {
            Disposer.register((Disposable)popup, (Disposable)usageView);
            popup.show(popupPosition);
        }
    }

    private void showHint(String text, Editor editor, RelativePoint popupPosition, FindUsagesHandler handler, int maxUsages) {
        JComponent label = this.createHintComponent(text, handler, popupPosition, editor, HIDE_HINTS_ACTION, maxUsages);
        if (editor == null) {
            HintManager.getInstance().showHint(label, popupPosition, 42, 0);
        } else {
            HintManager.getInstance().showInformationHint(editor, label);
        }
    }

    private JComponent createHintComponent(String text, FindUsagesHandler handler, RelativePoint popupPosition, Editor editor, Runnable cancelAction, int maxUsages) {
        JLabel label = HintUtil.createInformationLabel(text);
        InplaceButton button = this.createSettingsButton(handler, popupPosition, editor, maxUsages, cancelAction);
        JPanel panel = new JPanel(new BorderLayout());
        button.setBackground(label.getBackground());
        panel.setBackground(label.getBackground());
        label.setOpaque(false);
        label.setBorder(null);
        panel.setBorder(HintUtil.createHintBorder());
        panel.add((Component)label, "Center");
        panel.add((Component)button, "East");
        return panel;
    }

    private InplaceButton createSettingsButton(final FindUsagesHandler handler, final RelativePoint popupPosition, final Editor editor, final int maxUsages, final Runnable cancelAction) {
        String shortcutText = "";
        KeyboardShortcut shortcut = ShowUsagesAction.getSettingsShortcut();
        if (shortcut != null) {
            shortcutText = "(" + KeymapUtil.getShortcutText((Shortcut)shortcut) + ")";
        }
        return new InplaceButton("Options..." + shortcutText, IconLoader.getIcon((String)"/general/ideOptions.png"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ShowUsagesAction.this.showDialogAndFindUsages(handler, popupPosition, editor, maxUsages);
                    }
                });
                cancelAction.run();
            }
        });
    }

    private void showDialogAndFindUsages(FindUsagesHandler handler, RelativePoint popupPosition, Editor editor, int maxUsages) {
        AbstractFindUsagesDialog dialog = handler.getFindUsagesDialog(false, false, false);
        dialog.show();
        if (dialog.isOK()) {
            dialog.calcFindUsagesOptions();
            this.showElementUsages(handler, editor, popupPosition, maxUsages);
        }
    }

    private static String searchScopePresentableName(FindUsagesHandler handler) {
        SearchScope searchScope = FindUsagesManager.getCurrentSearchScope(handler);
        if (searchScope == null) {
            searchScope = ProjectScope.getAllScope((Project)handler.getProject());
        }
        return searchScope.getDisplayName();
    }

    private JBPopup createUsagePopup(final List<Usage> usages, Set<UsageNode> visibleNodes, String title, final FindUsagesHandler handler, final Editor editor, final RelativePoint popupPosition, final int maxUsages, final UsageViewImpl usageView) {
        Usage usage;
        boolean hasMore = visibleNodes.remove(UsageViewImpl.NULL_NODE);
        final Project project = handler.getProject();
        if (visibleNodes.isEmpty() && usages.isEmpty()) {
            String text = UsageViewBundle.message((String)"no.usages.found.in", (Object[])new Object[]{ShowUsagesAction.searchScopePresentableName(handler)});
            this.showHint(text, editor, popupPosition, handler, maxUsages);
            return null;
        }
        if (visibleNodes.size() == 1 && usages.size() == 1) {
            Usage usage2 = visibleNodes.iterator().next().getUsage();
            this.navigateAndHint(usage2, UsageViewBundle.message((String)"show.usages.only.usage", (Object[])new Object[]{ShowUsagesAction.searchScopePresentableName(handler)}), handler, popupPosition, maxUsages);
            return null;
        }
        if (visibleNodes.size() == 1 && usages.size() >= 1 && ShowUsagesAction.areAllUsagesInThisLine(usage = visibleNodes.iterator().next().getUsage(), usages)) {
            String hint = UsageViewBundle.message((String)"all.usages.are.in.this.line", (Object[])new Object[]{usages.size(), ShowUsagesAction.searchScopePresentableName(handler)});
            this.navigateAndHint(usage, hint, handler, popupPosition, maxUsages);
            return null;
        }
        if (hasMore) {
            usages.add((Usage)NullUsage.INSTANCE);
            visibleNodes.add(UsageViewImpl.NULL_NODE);
        }
        ArrayList<UsageNode> outNodes = new ArrayList<UsageNode>();
        ShowUsagesAction.addUsageNodes(usageView.getRoot(), usageView, outNodes);
        int filtered = ShowUsagesAction.filtered(usages, usageView);
        MyTable table = new MyTable();
        TableScrollingUtil.installActions((JTable)((Object)table));
        Vector<Object> data = new Vector<Object>();
        ShowUsagesAction.setModel((JTable)((Object)table), visibleNodes, usageView, data, filtered);
        Runnable navigateRunnable = new Runnable((JTable)((Object)table), editor, popupPosition, handler, maxUsages){
            final /* synthetic */ JTable val$table;
            final /* synthetic */ Editor val$editor;
            final /* synthetic */ RelativePoint val$popupPosition;
            final /* synthetic */ FindUsagesHandler val$handler;
            final /* synthetic */ int val$maxUsages;
            {
                this.val$table = jTable;
                this.val$editor = editor;
                this.val$popupPosition = relativePoint;
                this.val$handler = findUsagesHandler;
                this.val$maxUsages = n;
            }

            @Override
            public void run() {
                int[] selected;
                for (int i : selected = this.val$table.getSelectedRows()) {
                    Object value = this.val$table.getValueAt(i, 0);
                    if (!(value instanceof UsageNode)) continue;
                    Usage usage = ((UsageNode)value).getUsage();
                    if (usage == NullUsage.INSTANCE) {
                        ShowUsagesAction.this.appendMoreUsages(this.val$editor, this.val$popupPosition, this.val$handler, this.val$maxUsages);
                        return;
                    }
                    ShowUsagesAction.this.navigateAndHint(usage, null, this.val$handler, this.val$popupPosition, this.val$maxUsages);
                }
            }
        };
        SpeedSearchBase<JTable> speedSearch = new SpeedSearchBase<JTable>((JTable)((Object)table), (JTable)((Object)table), data){
            final /* synthetic */ JTable val$table;
            final /* synthetic */ Vector val$data;
            {
                this.val$table = jTable;
                this.val$data = vector;
                super(x0);
            }

            @Override
            protected int getSelectedIndex() {
                return this.val$table.getSelectedRow();
            }

            @Override
            protected Object[] getAllElements() {
                return ArrayUtil.toObjectArray((Collection)this.val$data);
            }

            @Override
            protected String getElementText(Object element) {
                if (!(element instanceof UsageNode)) {
                    return element.toString();
                }
                UsageNode node = (UsageNode)element;
                GroupNode group = (GroupNode)node.getParent();
                return node.getUsage().getPresentation().getPlainText() + group.toString();
            }

            @Override
            protected void selectElement(Object element, String selectedText) {
                int i = this.val$data.indexOf(element);
                if (i == -1) {
                    return;
                }
                this.val$table.getSelectionModel().setSelectionInterval(i, i);
            }
        };
        speedSearch.setComparator(new SpeedSearchBase.SpeedSearchComparator(false));
        PopupChooserBuilder builder = new PopupChooserBuilder((JTable)((Object)table));
        if (title != null) {
            String s = hasMore ? "<html><body><b>Some</b> " + title + " " + "<b>(Only " + (visibleNodes.size() - 1) + " usages shown)</b></body></html>" : title + " (" + UsageViewBundle.message((String)"usages.n", (Object[])new Object[]{usages.size()}) + " found)";
            builder.setTitle(s);
        }
        builder.setMovable(true).setResizable(true);
        builder.setItemChoosenCallback(navigateRunnable);
        final JBPopup[] popup = new JBPopup[1];
        ActionListener editSettings = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                popup[0].cancel();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ShowUsagesAction.this.showDialogAndFindUsages(handler, popupPosition, editor, maxUsages);
                    }
                });
            }
        };
        KeyboardShortcut shortcut = ShowUsagesAction.getSettingsShortcut();
        if (shortcut != null) {
            builder.registerKeyboardAction(shortcut.getFirstKeyStroke(), editSettings);
        }
        InplaceButton button = this.createSettingsButton(handler, popupPosition, editor, maxUsages, new Runnable(){

            @Override
            public void run() {
                popup[0].cancel();
            }
        });
        builder.setCommandButton(button);
        DefaultActionGroup filters = new DefaultActionGroup();
        usageView.addFilteringActions(filters);
        filters.add(new AnAction("Open Find Usages Toolwindow", "Show all usages in a separate toolwindow", IconLoader.getIcon((String)"/general/toolWindowFind.png")){
            {
                super(x0, x1, x2);
                AnAction action = ActionManager.getInstance().getAction("FindUsages");
                this.setShortcutSet(action.getShortcutSet());
            }

            public void actionPerformed(AnActionEvent e) {
                ShowUsagesAction.hideHints();
                popup[0].cancel();
                FindUsagesManager findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)project)).getFindUsagesManager();
                FindUsagesManager.SearchData data = new FindUsagesManager.SearchData();
                data.myOptions = handler.getFindUsagesOptions();
                SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(handler.getPsiElement());
                data.myElements = new SmartPsiElementPointer[]{pointer};
                findUsagesManager.rerunAndRecallFromHistory(data);
            }
        });
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("UsageViewToolbar", (ActionGroup)filters, true);
        actionToolbar.setReservePlaceAutoPopupIcon(false);
        JComponent toolBar = actionToolbar.getComponent();
        toolBar.setOpaque(false);
        builder.setSettingButton((Component)toolBar);
        popup[0] = builder.createPopup();
        for (AnAction action : filters.getChildren(null)) {
            action.unregisterCustomShortcutSet(usageView.getComponent());
            action.registerCustomShortcutSet(action.getShortcutSet(), popup[0].getContent());
        }
        MessageBusConnection messageBusConnection = project.getMessageBus().connect((Disposable)usageView);
        messageBusConnection.subscribe(UsageFilteringRuleProvider.RULES_CHANGED, (Object)new Runnable((JTable)((Object)table), popup){
            final /* synthetic */ JTable val$table;
            final /* synthetic */ JBPopup[] val$popup;
            {
                this.val$table = jTable;
                this.val$popup = jBPopupArray;
            }

            @Override
            public void run() {
                ShowUsagesAction.this.rebuildPopup(usageView, usages, this.val$table, this.val$popup[0]);
            }
        });
        return popup[0];
    }

    private static int filtered(List<Usage> usages, UsageViewImpl usageView) {
        int count = 0;
        for (Usage usage : usages) {
            if (usageView.isVisible(usage)) continue;
            ++count;
        }
        return count;
    }

    private static int getUsageOffset(Usage usage) {
        if (!(usage instanceof UsageInfo2UsageAdapter)) {
            return -1;
        }
        PsiElement element = ((UsageInfo2UsageAdapter)usage).getElement();
        if (element == null) {
            return -1;
        }
        return element.getTextRange().getStartOffset();
    }

    private static boolean areAllUsagesInThisLine(Usage usage, List<Usage> usages) {
        Editor editor = ShowUsagesAction.getEditorFor(usage);
        if (editor == null) {
            return false;
        }
        int offset = ShowUsagesAction.getUsageOffset(usage);
        if (offset == -1) {
            return false;
        }
        int lineNumber = editor.getDocument().getLineNumber(offset);
        for (Usage other : usages) {
            Editor otherEditor = ShowUsagesAction.getEditorFor(other);
            if (otherEditor != editor) {
                return false;
            }
            int otherOffset = ShowUsagesAction.getUsageOffset(other);
            if (otherOffset == -1) {
                return false;
            }
            int otherLine = otherEditor.getDocument().getLineNumber(otherOffset);
            if (otherLine == lineNumber) continue;
            return false;
        }
        return true;
    }

    private static int setModel(JTable table, Collection<UsageNode> visibleNodes, UsageViewImpl usageView, final Vector<Object> data, int filtered) {
        if (filtered != 0) {
            data.add(UsageViewBundle.message((String)"usages.were.filtered.out", (Object[])new Object[]{filtered}));
        }
        data.addAll(visibleNodes);
        Collections.sort(data, USAGE_COMPARATOR);
        AbstractTableModel model = new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return data.size();
            }

            @Override
            public int getColumnCount() {
                return data.get(0) instanceof UsageNode ? 3 : 1;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                return data.get(rowIndex);
            }
        };
        table.setModel(model);
        table.setRowHeight(Icons.CLASS_ICON.getIconHeight() + 2);
        table.setShowGrid(false);
        table.setShowVerticalLines(false);
        table.setShowHorizontalLines(false);
        table.setTableHeader(null);
        table.setAutoResizeMode(3);
        ShowUsagesTableCellRenderer renderer = new ShowUsagesTableCellRenderer(usageView);
        for (int i = 0; i < table.getColumnModel().getColumnCount(); ++i) {
            TableColumn column = table.getColumnModel().getColumn(i);
            column.setCellRenderer(renderer);
        }
        table.setIntercellSpacing(new Dimension(0, 0));
        int colsNum = table.getColumnModel().getColumnCount();
        int totalWidth = 0;
        for (int col = 0; col < colsNum - 1; ++col) {
            TableColumn column = table.getColumnModel().getColumn(col);
            int preferred = column.getPreferredWidth();
            int width = Math.max(preferred, ShowUsagesAction.calcMaxWidth(table, col));
            totalWidth += width;
            column.setMinWidth(width);
            column.setMaxWidth(width);
            column.setWidth(width);
            column.setPreferredWidth(width);
        }
        Dimension dimension = new Dimension(totalWidth += ShowUsagesAction.calcMaxWidth(table, colsNum - 1), table.getRowHeight() * data.size());
        table.setMinimumSize(dimension);
        table.setSize(dimension);
        table.setPreferredSize(dimension);
        table.setMaximumSize(dimension);
        table.setPreferredScrollableViewportSize(dimension);
        return totalWidth;
    }

    private static int calcMaxWidth(JTable table, int col) {
        TableColumn column = table.getColumnModel().getColumn(col);
        int width = 0;
        for (int row = 0; row < table.getRowCount(); ++row) {
            Component component = table.prepareRenderer(column.getCellRenderer(), row, col);
            int rendererWidth = component.getPreferredSize().width;
            width = Math.max(width, rendererWidth + table.getIntercellSpacing().width);
        }
        return width;
    }

    private void rebuildPopup(final UsageViewImpl usageView, final List<Usage> usages, final JTable table, final JBPopup popup) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JComponent content = popup.getContent();
                Window window = SwingUtilities.windowForComponent(content);
                Dimension d = window.getSize();
                ArrayList nodes = new ArrayList();
                ShowUsagesAction.addUsageNodes(usageView.getRoot(), usageView, nodes);
                int filtered = ShowUsagesAction.filtered(usages, usageView);
                int old = table.getModel().getRowCount();
                Vector data = new Vector();
                int width = ShowUsagesAction.setModel(table, nodes, usageView, data, filtered);
                if (ShowUsagesAction.this.myWidth == -1) {
                    ShowUsagesAction.this.myWidth = width;
                }
                Dimension newDim = new Dimension(Math.max(width, d.width + width - ShowUsagesAction.this.myWidth), d.height + (data.size() - old) * table.getRowHeight());
                ShowUsagesAction.this.myWidth = width;
                window.setSize(newDim);
                window.validate();
                window.repaint();
                table.revalidate();
                table.repaint();
            }
        });
    }

    private void appendMoreUsages(Editor editor, RelativePoint popupPosition, FindUsagesHandler handler, int maxUsages) {
        this.showElementUsages(handler, editor, popupPosition, maxUsages + 100);
    }

    private static KeyboardShortcut getSettingsShortcut() {
        return ActionManagerEx.getInstanceEx().getKeyboardShortcut("ShowUsagesSettings");
    }

    private static void addUsageNodes(GroupNode root, UsageViewImpl usageView, List<UsageNode> outNodes) {
        for (UsageNode node : root.getUsageNodes()) {
            Usage usage = node.getUsage();
            if (!usageView.isVisible(usage)) continue;
            node.setParent((MutableTreeNode)root);
            outNodes.add(node);
        }
        for (GroupNode groupNode : root.getSubGroups()) {
            groupNode.setParent((MutableTreeNode)root);
            ShowUsagesAction.addUsageNodes(groupNode, usageView, outNodes);
        }
    }

    public void update(AnActionEvent e) {
        FindUsagesInFileAction.updateFindUsagesAction(e);
    }

    private void navigateAndHint(Usage usage, final String hint, final FindUsagesHandler handler, final RelativePoint popupPosition, final int maxUsages) {
        usage.navigate(true);
        if (hint == null) {
            return;
        }
        final Editor newEditor = ShowUsagesAction.getEditorFor(usage);
        if (newEditor == null) {
            return;
        }
        final Project project = handler.getProject();
        IdeFocusManager.getInstance((Project)project).doWhenFocusSettlesDown(new Runnable(){

            @Override
            public void run() {
                newEditor.getScrollingModel().runActionOnScrollingFinished(new Runnable(){

                    @Override
                    public void run() {
                        IdeFocusManager.getInstance((Project)project).doWhenFocusSettlesDown(new Runnable(){

                            @Override
                            public void run() {
                                if (newEditor.getComponent().isShowing()) {
                                    ShowUsagesAction.this.showHint(hint, newEditor, popupPosition, handler, maxUsages);
                                }
                            }
                        });
                    }
                });
            }
        });
    }

    private static Editor getEditorFor(Usage usage) {
        FileEditorLocation location = usage.getLocation();
        FileEditor newFileEditor = location == null ? null : location.getEditor();
        return newFileEditor instanceof TextEditor ? ((TextEditor)newFileEditor).getEditor() : null;
    }

    private static class MyTable
    extends Table
    implements DataProvider {
        private MyTable() {
        }

        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        public Object getData(@NonNls String dataId) {
            PsiElement element;
            Usage usage;
            Object at;
            int[] selected;
            if (LangDataKeys.PSI_ELEMENT.is(dataId) && (selected = this.getSelectedRows()).length == 1 && (at = this.getValueAt(selected[0], 0)) instanceof UsageNode && (usage = ((UsageNode)at).getUsage()) instanceof UsageInfo2UsageAdapter && (element = ((UsageInfo2UsageAdapter)usage).getElement()) != null) {
                PsiElement view = UsageToPsiElementProvider.findAppropriateParentFrom((PsiElement)element);
                return view == null ? element : view;
            }
            return null;
        }
    }

    public static class ShowSettings
    extends ShowUsagesAction {
        public ShowSettings() {
            super(true);
        }
    }
}

