/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.AbstractBlockWrapper;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.LeafBlockWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;

class AlignmentImpl
extends Alignment {
    private static final List<LeafBlockWrapper> EMPTY = Collections.unmodifiableList(new ArrayList(0));
    private Collection<LeafBlockWrapper> myOffsetRespBlocks = EMPTY;
    private final int myFlags;
    private static int ourId = 0;
    private static final int ID_SHIFT = 1;
    private AlignmentImpl myParentAlignment;

    public String getId() {
        return String.valueOf(System.identityHashCode((Object)this));
    }

    public void reset() {
        if (this.myOffsetRespBlocks != EMPTY) {
            this.myOffsetRespBlocks.clear();
        }
    }

    public void setParent(Alignment base) {
        this.myParentAlignment = (AlignmentImpl)base;
    }

    public AlignmentImpl(Type type) {
        this.myFlags = ourId++ >> 1 | type.ordinal();
    }

    final Type getType() {
        return Type.values()[this.myFlags & 1];
    }

    LeafBlockWrapper getOffsetRespBlockBefore(LeafBlockWrapper block) {
        AbstractBlockWrapper result = null;
        if (this.myOffsetRespBlocks != EMPTY) {
            AbstractBlockWrapper lastBlockAfterLineFeed = null;
            AbstractBlockWrapper firstAlignedBlock = null;
            AbstractBlockWrapper lastAlignedBlock = null;
            for (LeafBlockWrapper current : this.myOffsetRespBlocks) {
                if (block != null && current.getStartOffset() >= block.getStartOffset()) continue;
                if (firstAlignedBlock == null || firstAlignedBlock.getStartOffset() > current.getStartOffset()) {
                    firstAlignedBlock = current;
                }
                if (lastAlignedBlock == null || lastAlignedBlock.getStartOffset() < current.getStartOffset()) {
                    lastAlignedBlock = current;
                }
                if (!current.getWhiteSpace().containsLineFeeds() || lastBlockAfterLineFeed != null && lastBlockAfterLineFeed.getStartOffset() >= current.getStartOffset()) continue;
                lastBlockAfterLineFeed = current;
            }
            result = lastBlockAfterLineFeed != null ? lastBlockAfterLineFeed : (firstAlignedBlock != null ? firstAlignedBlock : lastAlignedBlock);
        }
        if (result == null && this.myParentAlignment != null) {
            return this.myParentAlignment.getOffsetRespBlockBefore(block);
        }
        return result;
    }

    void setOffsetRespBlock(LeafBlockWrapper block) {
        if (this.myOffsetRespBlocks == EMPTY) {
            this.myOffsetRespBlocks = new LinkedHashSet<LeafBlockWrapper>(1);
        }
        this.myOffsetRespBlocks.add(block);
    }

    static enum Type {
        FULL,
        NORMAL;

    }
}

