/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core;

import com.intellij.history.core.storage.Content;
import com.intellij.history.core.storage.Storage;
import com.intellij.history.core.storage.UnavailableContent;
import java.io.IOException;
import java.util.Arrays;

public abstract class ContentFactory {
    public static final int MAX_CONTENT_LENGTH = 0x100000;

    public Content createContent(Storage s) {
        try {
            if (this.isTooLong()) {
                return new UnavailableContent();
            }
            return s.storeContent(this.getBytes());
        }
        catch (IOException e) {
            return new UnavailableContent();
        }
    }

    private boolean isTooLong() throws IOException {
        return this.getLength() > 0x100000L;
    }

    public boolean equalsTo(Content c) {
        try {
            if (!c.isAvailable()) {
                return false;
            }
            if (this.isTooLong()) {
                return false;
            }
            if (this.getLength() != (long)c.getBytes().length) {
                return false;
            }
            return Arrays.equals(this.getBytes(), c.getBytes());
        }
        catch (IOException e) {
            return false;
        }
    }

    protected abstract byte[] getBytes() throws IOException;

    protected abstract long getLength() throws IOException;
}

