/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.tree;

import com.intellij.history.core.Paths;
import com.intellij.history.core.revisions.Difference;
import com.intellij.history.core.storage.Stream;
import com.intellij.history.core.tree.Entry;
import com.intellij.util.SmartList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DirectoryEntry
extends Entry {
    private final List<Entry> myChildren;

    public DirectoryEntry(int id, String name) {
        super(id, name);
        this.myChildren = new ArrayList<Entry>(3);
    }

    public DirectoryEntry(Stream s) throws IOException {
        super(s);
        int count = s.readInteger();
        Object object = this.myChildren = count == 0 ? new SmartList() : new ArrayList(count);
        while (count-- > 0) {
            this.unsafeAddChild(s.readEntry());
        }
    }

    @Override
    public void write(Stream s) throws IOException {
        super.write(s);
        s.writeInteger(this.myChildren.size());
        for (Entry child : this.myChildren) {
            s.writeEntry(child);
        }
    }

    protected String getPathAppendedWith(String name) {
        return Paths.appended(this.getPath(), name);
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public void addChild(Entry child) {
        this.checkDoesNotExist(child, child.getName());
        this.unsafeAddChild(child);
    }

    private void unsafeAddChild(Entry child) {
        this.myChildren.add(child);
        child.setParent(this);
    }

    protected void checkDoesNotExist(Entry e, String name) {
        Entry found = this.findChild(name);
        if (found == null || found == e) {
            return;
        }
        throw new RuntimeException(String.format("entry '%s' already exists in '%s'", name, this.getPath()));
    }

    @Override
    public void removeChild(Entry child) {
        this.myChildren.remove(child);
        child.setParent(null);
    }

    @Override
    public List<Entry> getChildren() {
        return this.myChildren;
    }

    @Override
    public boolean hasUnavailableContent(List<Entry> entriesWithUnavailableContent) {
        for (Entry e : this.myChildren) {
            e.hasUnavailableContent(entriesWithUnavailableContent);
        }
        return !entriesWithUnavailableContent.isEmpty();
    }

    @Override
    public DirectoryEntry copy() {
        DirectoryEntry result = this.copyEntry();
        for (Entry child : this.myChildren) {
            result.unsafeAddChild(child.copy());
        }
        return result;
    }

    protected DirectoryEntry copyEntry() {
        return new DirectoryEntry(this.myId, this.myName);
    }

    @Override
    public void collectDifferencesWith(Entry right, List<Difference> result) {
        DirectoryEntry e = (DirectoryEntry)right;
        if (!this.getPath().equals(e.getPath())) {
            result.add(new Difference(false, this, e));
        }
        this.addCreatedChildrenDifferences(e, result);
        this.addDeletedChildrenDifferences(e, result);
        this.addModifiedChildrenDifferences(e, result);
    }

    private void addCreatedChildrenDifferences(DirectoryEntry e, List<Difference> result) {
        for (Entry child : e.myChildren) {
            if (this.findDirectChild(child.getId()) != null) continue;
            child.collectCreatedDifferences(result);
        }
    }

    private void addDeletedChildrenDifferences(DirectoryEntry e, List<Difference> result) {
        for (Entry child : this.myChildren) {
            if (e.findDirectChild(child.getId()) != null) continue;
            child.collectDeletedDifferences(result);
        }
    }

    private void addModifiedChildrenDifferences(DirectoryEntry e, List<Difference> result) {
        for (Entry myChild : this.myChildren) {
            Entry itsChild = e.findDirectChild(myChild.getId());
            if (itsChild == null) continue;
            myChild.collectDifferencesWith(itsChild, result);
        }
    }

    Entry findDirectChild(int id) {
        for (Entry child : this.getChildren()) {
            if (child.getId() != id) continue;
            return child;
        }
        return null;
    }

    @Override
    protected void collectCreatedDifferences(List<Difference> result) {
        result.add(new Difference(false, null, this));
        for (Entry child : this.myChildren) {
            child.collectCreatedDifferences(result);
        }
    }

    @Override
    protected void collectDeletedDifferences(List<Difference> result) {
        result.add(new Difference(false, this, null));
        for (Entry child : this.myChildren) {
            child.collectDeletedDifferences(result);
        }
    }
}

