/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration;

import com.intellij.diagnostic.Diagnostic;
import com.intellij.history.core.LocalVcs;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.CacheUpdaterProcessor;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.utils.LocalHistoryLog;
import com.intellij.ide.caches.CacheUpdater;
import com.intellij.ide.caches.FileContent;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class LocalHistoryCacheUpdater
implements CacheUpdater {
    private final LocalVcs myVcs;
    private final IdeaGateway myGateway;
    private final String myChangeSetName;
    private VirtualFile[] myVfsRoots;
    private CacheUpdaterProcessor myProcessor;

    public LocalHistoryCacheUpdater(String changeSetName, LocalVcs vcs, IdeaGateway gw) {
        this.myChangeSetName = changeSetName;
        this.myVcs = vcs;
        this.myGateway = gw;
    }

    public VirtualFile[] queryNeededFiles() {
        this.myVfsRoots = this.selectParentlessRootsAndSort(this.myGateway.getContentRoots());
        this.myProcessor = new CacheUpdaterProcessor(this.myVcs);
        this.myVcs.beginChangeSet();
        this.deleteObsoleteRoots();
        this.createAndUpdateRoots();
        return this.myProcessor.queryNeededFiles();
    }

    protected VirtualFile[] selectParentlessRootsAndSort(List<VirtualFile> roots) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (VirtualFile r : roots) {
            if (!this.parentIsNotUnderContentRoot(r)) continue;
            result.add(r);
        }
        ContainerUtil.removeDuplicates(result);
        LocalHistoryCacheUpdater.sortRoots(result);
        return VfsUtil.toVirtualFileArray(result);
    }

    private static void sortRoots(List<VirtualFile> roots) {
        Collections.sort(roots, new Comparator<VirtualFile>(){

            @Override
            public int compare(VirtualFile a, VirtualFile b) {
                boolean ancestor = VfsUtil.isAncestor((VirtualFile)a, (VirtualFile)b, (boolean)false);
                return ancestor ? -1 : 1;
            }
        });
    }

    private boolean parentIsNotUnderContentRoot(VirtualFile r) {
        VirtualFile p = r.getParent();
        return p == null || !this.myGateway.getFileFilter().isUnderContentRoot(p);
    }

    public void processFile(FileContent c) {
        this.myProcessor.processFile(c);
    }

    public int getNumberOfPendingUpdateJobs() {
        return 0;
    }

    public void updatingDone() {
        this.myVcs.endChangeSet(this.myChangeSetName);
        this.myVfsRoots = null;
        this.myProcessor = null;
    }

    public void canceled() {
        this.updatingDone();
    }

    private void deleteObsoleteRoots() {
        ArrayList<Entry> obsolete = new ArrayList<Entry>();
        for (Entry r : this.myVcs.getRoots()) {
            if (this.hasVfsRoot(r)) continue;
            obsolete.add(r);
        }
        for (Entry e : obsolete) {
            this.myVcs.delete(e.getPath());
        }
    }

    private boolean hasVfsRoot(Entry e) {
        for (VirtualFile f : this.myVfsRoots) {
            if (!e.pathEquals(f.getPath())) continue;
            return true;
        }
        return false;
    }

    private void createAndUpdateRoots() {
        for (VirtualFile r : this.myVfsRoots) {
            if (!this.hasVcsRoot(r)) {
                this.createRecursively(r);
                continue;
            }
            this.updateRecursively(this.myVcs.getEntry(r.getPath()), r);
        }
    }

    private boolean hasVcsRoot(VirtualFile f) {
        for (Entry e : this.myVcs.getRoots()) {
            if (!e.pathEquals(f.getPath())) continue;
            return true;
        }
        return false;
    }

    private void updateRecursively(Entry entry, VirtualFile dir) {
        for (VirtualFile f : dir.getChildren()) {
            boolean isFileRO;
            if (this.notAllowed(f)) continue;
            Entry e = entry.findChild(f.getName());
            if (e == null) {
                this.createRecursively(f);
                continue;
            }
            if (!LocalHistoryCacheUpdater.sameKind(e, f)) {
                this.myVcs.delete(e.getPath());
                this.createRecursively(f);
                continue;
            }
            if (!e.getName().equals(f.getName())) {
                this.myVcs.rename(e.getPath(), f.getName());
            }
            if (f.isDirectory()) {
                this.updateRecursively(e, f);
                continue;
            }
            boolean bl = isFileRO = !f.isWritable();
            if (e.isReadOnly() != isFileRO) {
                this.myVcs.changeROStatus(f.getPath(), isFileRO);
            }
            if (!e.isOutdated(f.getTimeStamp())) continue;
            this.myProcessor.addFileToUpdate(f);
        }
        this.deleteObsoleteFiles(entry, dir);
    }

    private static boolean sameKind(Entry e, VirtualFile f) {
        return e.isDirectory() == f.isDirectory();
    }

    private void deleteObsoleteFiles(Entry entry, VirtualFile dir) {
        ArrayList<Entry> obsolete = new ArrayList<Entry>();
        for (Entry e : entry.getChildren()) {
            VirtualFile f = dir.findChild(e.getName());
            if (f != null && !this.notAllowed(f)) continue;
            obsolete.add(e);
        }
        for (Entry e : obsolete) {
            this.myVcs.delete(e.getPath());
        }
    }

    private void createRecursively(VirtualFile fileOrDir) {
        if (this.notAllowed(fileOrDir)) {
            return;
        }
        if (!this.checkDoesNotExist(fileOrDir)) {
            return;
        }
        if (fileOrDir.isDirectory()) {
            this.myVcs.createDirectory(fileOrDir.getPath());
            for (VirtualFile f : fileOrDir.getChildren()) {
                this.createRecursively(f);
            }
        } else {
            this.myProcessor.addFileToCreate(fileOrDir);
        }
    }

    private boolean notAllowed(VirtualFile f) {
        return !this.myGateway.getFileFilter().isAllowedAndUnderContentRoot(f);
    }

    private boolean checkDoesNotExist(VirtualFile f) {
        if (!Diagnostic.isJavaAssertionsEnabled()) {
            return true;
        }
        Entry e = this.myVcs.findEntry(f.getPath());
        if (e == null) {
            return true;
        }
        StringBuilder b = new StringBuilder();
        b.append("already exists!!\n");
        b.append("file: '" + f + "'\n");
        b.append("file.name: '" + f.getName() + "'\n");
        b.append("file.parent: '" + f.getParent() + "'\n");
        if (f.getParent() != null) {
            b.append("file.parent.name: '" + f.getParent().getName() + "'\n");
        }
        b.append("entry: '" + e + "'\n");
        b.append("entry.parent: '" + e.getParent() + "'\n");
        if (f.getParent() != null) {
            b.append("entry for file.parent: '" + this.myVcs.findEntry(f.getParent().getPath()) + "'\n");
        }
        b.append("has vcs root: " + this.hasVcsRoot(f) + "\n");
        b.append("has vfs root: " + this.hasVfsRoot(e) + "\n");
        b.append("is file allowed: " + !this.notAllowed(f) + "\n");
        if (f.getParent() != null) {
            b.append("is file parent allowed: " + !this.notAllowed(f.getParent()) + "\n");
        }
        LocalHistoryCacheUpdater.log(b, "vfs roots:", this.myVfsRoots);
        LocalHistoryCacheUpdater.log(b, "vcs roots:", this.myVcs.getRoots());
        if (f.getParent() != null) {
            LocalHistoryCacheUpdater.log(b, "vfs siblings:", f.getParent().getChildren());
        }
        LocalHistoryCacheUpdater.log(b, "vcs siblings:", e.getParent().getChildren());
        LocalHistoryLog.LOG.warn(b.toString());
        return false;
    }

    private static void log(StringBuilder b, String title, VirtualFile[] roots) {
        b.append(title + "\n");
        for (VirtualFile r : roots) {
            b.append("-'" + r + "'\n");
        }
    }

    private static void log(StringBuilder b, String title, List<Entry> roots) {
        b.append(title + "\n");
        for (Entry r : roots) {
            b.append("-'" + r + "'\n");
        }
    }
}

