/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.models;

import com.intellij.diff.Block;
import com.intellij.diff.FindBlock;
import com.intellij.history.core.revisions.Revision;
import com.intellij.history.core.storage.Content;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.ui.models.Progress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SelectionCalculator {
    private final IdeaGateway myGateway;
    private final List<Revision> myRevisions;
    private final int myFromLine;
    private final int myToLine;
    private final Map<Integer, Block> myCache = new HashMap<Integer, Block>();

    public SelectionCalculator(IdeaGateway gw, List<Revision> rr, int fromLine, int toLine) {
        this.myGateway = gw;
        this.myRevisions = rr;
        this.myFromLine = fromLine;
        this.myToLine = toLine;
    }

    public boolean canCalculateFor(Revision r, Progress p) {
        try {
            this.doGetSelectionFor(r, p);
        }
        catch (ContentIsUnavailableException e) {
            return false;
        }
        return true;
    }

    public Block getSelectionFor(Revision r, Progress p) {
        return this.doGetSelectionFor(r, p);
    }

    private Block doGetSelectionFor(Revision r, Progress p) {
        int target = this.myRevisions.indexOf(r);
        return this.getSelectionFor(target, target + 1, p);
    }

    private Block getSelectionFor(int revisionIndex, int totalRevisions, Progress p) {
        Block result;
        Block cached = this.myCache.get(revisionIndex);
        if (cached != null) {
            return cached;
        }
        String content = this.getRevisionContent(this.myRevisions.get(revisionIndex));
        p.processed((totalRevisions - revisionIndex) * 100 / totalRevisions);
        if (revisionIndex == 0) {
            result = new Block(content, this.myFromLine, this.myToLine);
        } else {
            Block prev = this.getSelectionFor(revisionIndex - 1, totalRevisions, p);
            result = new FindBlock(content, prev).getBlockInThePrevVersion();
        }
        this.myCache.put(revisionIndex, result);
        return result;
    }

    private String getRevisionContent(Revision r) {
        Entry e = r.getEntry();
        Content c = e.getContent();
        if (!c.isAvailable()) {
            throw new ContentIsUnavailableException();
        }
        return c.getString(e, this.myGateway);
    }

    private static class ContentIsUnavailableException
    extends RuntimeException {
        private ContentIsUnavailableException() {
        }
    }
}

