/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.views;

import com.intellij.history.core.LocalVcs;
import com.intellij.history.core.revisions.Difference;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.history.integration.ui.models.DirectoryHistoryDialogModel;
import com.intellij.history.integration.ui.views.DirectoryChange;
import com.intellij.history.integration.ui.views.HistoryDialog;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.SimpleDiffRequest;
import com.intellij.openapi.diff.ex.DiffStatusBar;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeList;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.tree.DefaultTreeModel;

public class DirectoryHistoryDialog
extends HistoryDialog<DirectoryHistoryDialogModel> {
    private ChangesTreeList<Change> myChangesTree;

    public DirectoryHistoryDialog(IdeaGateway gw, VirtualFile f) {
        this(gw, f, true);
    }

    protected DirectoryHistoryDialog(IdeaGateway gw, VirtualFile f, boolean doInit) {
        super(gw, f, doInit);
    }

    @Override
    protected void init() {
        super.init();
        this.setTitle(((DirectoryHistoryDialogModel)this.myModel).getTitle());
    }

    @Override
    protected DirectoryHistoryDialogModel createModel(LocalVcs vcs) {
        return new DirectoryHistoryDialogModel(this.myGateway, vcs, this.myFile);
    }

    @Override
    protected Dimension getInitialSize() {
        return new Dimension(700, 600);
    }

    @Override
    protected JComponent createDiffPanel() {
        this.initChangesTree();
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)new DiffStatusBar(DiffStatusBar.DEFAULT_TYPES), "South");
        p.add(this.myChangesTree, "Center");
        ActionToolbar tb = ActionManager.getInstance().createActionToolbar("unknown", this.createChangesTreeActions(), true);
        p.add((Component)tb.getComponent(), "North");
        return p;
    }

    private void initChangesTree() {
        this.myChangesTree = this.createChangesTree();
        this.registerChangesTreeActions();
        this.updateDiffs();
    }

    private ChangesTreeList<Change> createChangesTree() {
        return new ChangesTreeList<Change>(this.getProject(), Collections.emptyList(), false, false, null, null){

            @Override
            protected DefaultTreeModel buildTreeModel(List<Change> cc, ChangeNodeDecorator changeNodeDecorator) {
                return new TreeModelBuilder(DirectoryHistoryDialog.this.getProject(), false).buildModel(cc, changeNodeDecorator);
            }

            @Override
            protected List<Change> getSelectedObjects(ChangesBrowserNode node) {
                return node.getAllChangesUnder();
            }

            @Override
            protected Change getLeadSelectedObject(ChangesBrowserNode node) {
                Object o = node.getUserObject();
                if (o instanceof Change) {
                    return (Change)o;
                }
                return null;
            }
        };
    }

    private void registerChangesTreeActions() {
        this.myChangesTree.setDoubleClickHandler(new Runnable(){

            @Override
            public void run() {
                ShowDifferenceAction a = new ShowDifferenceAction();
                if (a.isEnabled()) {
                    a.perform();
                }
            }
        });
        this.myChangesTree.installPopupHandler(this.createChangesTreeActions());
    }

    private ActionGroup createChangesTreeActions() {
        DefaultActionGroup result = new DefaultActionGroup();
        ShowDifferenceAction a = new ShowDifferenceAction();
        a.registerCustomShortcutSet(CommonShortcuts.getDiff(), this.myChangesTree);
        result.add((AnAction)a);
        result.add((AnAction)new RevertSelectionAction());
        return result;
    }

    @Override
    protected void updateDiffs() {
        this.myChangesTree.setChangesToDisplay(((DirectoryHistoryDialogModel)this.myModel).getChanges());
    }

    @Override
    protected String getHelpId() {
        return "reference.dialogs.localHistory.show.folder";
    }

    private List<DirectoryChange> getSelectedChanges() {
        return this.myChangesTree.getSelectedChanges();
    }

    private abstract class ActionOnSelection
    extends AnAction {
        public ActionOnSelection(String name, String iconName) {
            super(name, null, IconLoader.getIcon((String)iconName));
        }

        public void actionPerformed(AnActionEvent e) {
            this.perform();
        }

        public void perform() {
            this.performOn(DirectoryHistoryDialog.this.getSelectedChanges());
        }

        protected abstract void performOn(List<DirectoryChange> var1);

        public void update(AnActionEvent e) {
            Presentation p = e.getPresentation();
            p.setEnabled(this.isEnabled());
        }

        public boolean isEnabled() {
            return this.isEnabledFor(DirectoryHistoryDialog.this.getSelectedChanges());
        }

        protected boolean isEnabledFor(List<DirectoryChange> changes) {
            return true;
        }
    }

    private class RevertSelectionAction
    extends ActionOnSelection {
        public RevertSelectionAction() {
            super(LocalHistoryBundle.message("action.revert.selection", new Object[0]), "/actions/rollback.png");
        }

        @Override
        protected void performOn(List<DirectoryChange> changes) {
            ArrayList<Difference> diffs = new ArrayList<Difference>();
            for (DirectoryChange each : changes) {
                diffs.add(each.getModel().getDifference());
            }
            DirectoryHistoryDialog.this.revert(((DirectoryHistoryDialogModel)DirectoryHistoryDialog.this.myModel).createRevisionReverter(diffs));
        }

        @Override
        protected boolean isEnabledFor(List<DirectoryChange> changes) {
            return ((DirectoryHistoryDialogModel)DirectoryHistoryDialog.this.myModel).isRevertEnabled();
        }
    }

    private class ShowDifferenceAction
    extends ActionOnSelection {
        public ShowDifferenceAction() {
            super(LocalHistoryBundle.message("action.show.difference", new Object[0]), "/actions/diff.png");
        }

        @Override
        protected void performOn(List<DirectoryChange> changes) {
            SimpleDiffRequest r = DirectoryHistoryDialog.this.createDifference(this.getFirstChange(changes).getFileDifferenceModel());
            DiffManager.getInstance().getDiffTool().show((DiffRequest)r);
        }

        @Override
        protected boolean isEnabledFor(List<DirectoryChange> changes) {
            DirectoryChange c = this.getFirstChange(changes);
            return c != null && c.canShowFileDifference();
        }

        private DirectoryChange getFirstChange(List<DirectoryChange> changes) {
            return changes.isEmpty() ? null : changes.get(0);
        }
    }
}

